/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.userutil;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.userutil.ImmutableAttachment;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImmutableMessage {
    private static Logger logger = LogManager.getLogger(ImmutableMessage.class);
    private Message message;

    public ImmutableMessage(Message message) {
        this.message = message;
    }

    public Long getMessageId() {
        return this.message.getMessageId();
    }

    public String getServerId() {
        return this.message.getServerId();
    }

    public String getChannelId() {
        return this.message.getChannelId();
    }

    @Deprecated
    public Calendar getReceivedDate() {
        logger.error("This method is deprecated and will soon be removed. This method currently returns the received date of the source connector message.");
        return (Calendar)this.message.getReceivedDate().clone();
    }

    public boolean isProcessed() {
        return this.message.isProcessed();
    }

    public Long getOriginalId() {
        return this.message.getOriginalId();
    }

    public Long getImportId() {
        return this.message.getImportId();
    }

    public String getImportChannelId() {
        return this.message.getImportChannelId();
    }

    public List<ImmutableAttachment> getAttachments() {
        ArrayList<ImmutableAttachment> attachments = new ArrayList<ImmutableAttachment>();
        if (CollectionUtils.isNotEmpty((Collection)this.message.getAttachments())) {
            for (Attachment attachment : this.message.getAttachments()) {
                attachments.add(new ImmutableAttachment(attachment));
            }
        }
        return attachments;
    }

    public Map<Integer, ImmutableConnectorMessage> getConnectorMessages() {
        LinkedHashMap<Integer, ImmutableConnectorMessage> map = new LinkedHashMap<Integer, ImmutableConnectorMessage>(){

            @Override
            public ImmutableConnectorMessage get(Object key) {
                if (key instanceof Double) {
                    key = ((Double)key).intValue();
                }
                return (ImmutableConnectorMessage)super.get(key);
            }
        };
        for (Integer key : this.message.getConnectorMessages().keySet()) {
            map.put(key, new ImmutableConnectorMessage((ConnectorMessage)this.message.getConnectorMessages().get(key), false, this.getDestinationIdMap()));
        }
        return map;
    }

    public ImmutableConnectorMessage getMergedConnectorMessage() {
        return new ImmutableConnectorMessage(this.message.getMergedConnectorMessage(), false, this.getDestinationIdMap());
    }

    @Deprecated
    public Map<String, String> getDestinationNameMap() {
        logger.error("This method is deprecated and will soon be removed. Please use getDestinationIdMap() instead.");
        HashMap<String, CallSite> destinationNameMap = new HashMap<String, CallSite>();
        for (ConnectorMessage destinationMessage : this.message.getConnectorMessages().values()) {
            destinationNameMap.put(destinationMessage.getConnectorName(), (CallSite)((Object)("d" + String.valueOf(destinationMessage.getMetaDataId()))));
        }
        return Collections.unmodifiableMap(destinationNameMap);
    }

    public Map<String, Integer> getDestinationIdMap() {
        LinkedHashMap<String, Integer> destinationIdMap = new LinkedHashMap<String, Integer>();
        for (ConnectorMessage destinationMessage : this.message.getConnectorMessages().values()) {
            destinationIdMap.put(destinationMessage.getConnectorName(), destinationMessage.getMetaDataId());
        }
        return Collections.unmodifiableMap(destinationIdMap);
    }

    public String toString() {
        return this.message.toString();
    }
}

