/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.base.AbstractXMLStreamReader;
import de.odysseus.staxon.base.XMLStreamReaderScope;
import de.odysseus.staxon.json.JsonXMLStreamScopeInfo;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class JsonXMLStreamReader
extends AbstractXMLStreamReader<ScopeInfo> {
    protected final JsonStreamSource source;
    protected final boolean multiplePI;
    private final char namespaceSeparator;
    protected boolean documentArray = false;

    public JsonXMLStreamReader(JsonStreamSource source, boolean multiplePI, char namespaceSeparator) throws XMLStreamException {
        this(source, multiplePI, namespaceSeparator, null);
    }

    public JsonXMLStreamReader(JsonStreamSource source, boolean multiplePI, char namespaceSeparator, Map<String, String> namespaceMappings) throws XMLStreamException {
        super((Object)new ScopeInfo(), (Location)source);
        this.source = source;
        this.multiplePI = multiplePI;
        this.namespaceSeparator = namespaceSeparator;
        this.initialize(namespaceMappings);
    }

    private void initialize(Map<String, String> namespaceMappings) throws XMLStreamException {
        if (namespaceMappings != null && !namespaceMappings.isEmpty()) {
            for (Map.Entry<String, String> namespace : namespaceMappings.entrySet()) {
                this.getScope().setPrefix(namespace.getKey(), namespace.getValue());
            }
        }
        super.initialize();
    }

    protected void readStartElementTag(String name) throws XMLStreamException {
        int separator = name.indexOf(this.namespaceSeparator);
        if (separator < 0) {
            this.readStartElementTag("", name, null, (Object)new ScopeInfo());
        } else {
            this.readStartElementTag(name.substring(0, separator), name.substring(separator + 1), null, (Object)new ScopeInfo());
        }
    }

    protected void readAttrNsDecl(String name, String value) throws XMLStreamException {
        int separator = name.indexOf(this.namespaceSeparator);
        if (separator < 0) {
            if ("xmlns".equals(name)) {
                this.readNsDecl("", value);
            } else {
                this.readAttr("", name, null, value);
            }
        } else if (name.startsWith("xmlns") && separator == "xmlns".length()) {
            this.readNsDecl(name.substring(separator + 1), value);
        } else {
            this.readAttr(name.substring(0, separator), name.substring(separator + 1), null, value);
        }
    }

    protected void readData(JsonStreamSource.Value value, int type) throws XMLStreamException {
        this.readData(value.text, value.data, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void consumeName(ScopeInfo info) throws XMLStreamException, IOException {
        String fieldName = this.source.name();
        if (fieldName.startsWith("@")) {
            fieldName = fieldName.substring(1);
            if (this.source.peek() == JsonStreamToken.VALUE) {
                this.readAttrNsDecl(fieldName, this.source.value().text);
                return;
            } else {
                if (!"xmlns".equals(fieldName)) throw new IllegalStateException("Expected attribute value");
                this.source.startObject();
                while (this.source.peek() == JsonStreamToken.NAME) {
                    String prefix = this.source.name();
                    if ("$".equals(prefix)) {
                        this.readNsDecl("", this.source.value().text);
                        continue;
                    }
                    this.readNsDecl(prefix, this.source.value().text);
                }
                this.source.endObject();
            }
            return;
        } else if ("$".equals(fieldName)) {
            this.readData(this.source.value(), 4);
            return;
        } else {
            info.currentTagName = fieldName;
        }
    }

    protected boolean consume() throws XMLStreamException, IOException {
        XMLStreamReaderScope scope = this.getScope();
        switch (this.source.peek()) {
            case NAME: {
                this.consumeName((ScopeInfo)((Object)scope.getInfo()));
                return this.consume();
            }
            case START_ARRAY: {
                this.source.startArray();
                if (((ScopeInfo)((Object)scope.getInfo())).isArray()) {
                    throw new IOException("Array start inside array");
                }
                if (scope.isRoot() && !this.isStartDocumentRead()) {
                    this.documentArray = true;
                } else {
                    if (((ScopeInfo)((Object)scope.getInfo())).currentTagName == null) {
                        throw new IOException("Array name missing");
                    }
                    ((ScopeInfo)((Object)scope.getInfo())).startArray(((ScopeInfo)((Object)scope.getInfo())).currentTagName);
                }
                if (this.multiplePI) {
                    this.readPI("xml-multiple", ((ScopeInfo)((Object)scope.getInfo())).currentTagName);
                }
                return this.consume();
            }
            case START_OBJECT: {
                this.source.startObject();
                if (scope.isRoot() && !this.isStartDocumentRead()) {
                    this.readStartDocument(null, null, null);
                } else {
                    if (((ScopeInfo)((Object)scope.getInfo())).isArray()) {
                        ((ScopeInfo)((Object)scope.getInfo())).incArraySize();
                    }
                    if (((ScopeInfo)((Object)scope.getInfo())).currentTagName != null) {
                        this.readStartElementTag(((ScopeInfo)((Object)scope.getInfo())).currentTagName);
                    }
                }
                return this.consume();
            }
            case END_OBJECT: {
                this.source.endObject();
                if (scope.isRoot() && this.isStartDocumentRead()) {
                    this.readEndDocument();
                    return this.documentArray;
                }
                this.readEndElementTag();
                return true;
            }
            case VALUE: {
                String name = ((ScopeInfo)((Object)scope.getInfo())).currentTagName;
                if (((ScopeInfo)((Object)scope.getInfo())).isArray()) {
                    ((ScopeInfo)((Object)scope.getInfo())).incArraySize();
                    name = ((ScopeInfo)((Object)scope.getInfo())).getArrayName();
                }
                if (this.getScope().isRoot() && !this.isStartDocumentRead()) {
                    this.readData(this.source.value(), 4);
                } else {
                    this.readStartElementTag(name);
                    JsonStreamSource.Value value = this.source.value();
                    if (value != JsonStreamSource.NULL) {
                        this.readData(value, 4);
                    }
                    this.readEndElementTag();
                }
                return true;
            }
            case END_ARRAY: {
                this.source.endArray();
                if (this.getScope().isRoot() && this.documentArray) {
                    return false;
                }
                if (!((ScopeInfo)((Object)scope.getInfo())).isArray()) {
                    throw new IllegalStateException("Array end without matching start");
                }
                ((ScopeInfo)((Object)scope.getInfo())).endArray();
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw new IOException("Unexpected token: " + String.valueOf(this.source.peek()));
    }

    public boolean hasNumber() {
        return this.getEventData() instanceof Number;
    }

    public Number getNumber() {
        return (Number)this.getEventData();
    }

    public boolean hasBoolean() {
        return this.getEventData() instanceof Boolean;
    }

    public Boolean getBoolean() {
        return (Boolean)this.getEventData();
    }

    public void close() throws XMLStreamException {
        super.close();
        try {
            this.source.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public static class ScopeInfo
    extends JsonXMLStreamScopeInfo {
        public String currentTagName;
    }
}

