/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.connectors.tcp.TcpConfiguration;
import com.mirth.connect.util.TcpUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class SocketUtil {
    public static Socket createSocket(TcpConfiguration configuration) throws UnknownHostException, IOException {
        return SocketUtil.createSocket(configuration, null);
    }

    public static Socket createSocket(TcpConfiguration configuration, String localAddr) throws UnknownHostException, IOException {
        return SocketUtil.createSocket(configuration, localAddr, 0);
    }

    public static Socket createSocket(TcpConfiguration configuration, String localAddr, int localPort) throws UnknownHostException, IOException {
        Socket socket = configuration.createSocket();
        if (StringUtils.isNotEmpty((CharSequence)localAddr)) {
            InetAddress localAddress = InetAddress.getByName(TcpUtil.getFixedHost((String)localAddr));
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        return socket;
    }

    public static Socket createResponseSocket(TcpConfiguration configuration) throws UnknownHostException, IOException {
        return configuration.createResponseSocket();
    }

    public static void connectSocket(Socket socket, String host, int port, int timeout) throws UnknownHostException, IOException {
        socket.connect(new InetSocketAddress(InetAddress.getByName(TcpUtil.getFixedHost((String)host)), port), timeout);
    }

    public static void closeSocket(Socket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public static String getInetAddress(Socket socket) {
        String inetAddress;
        String string = inetAddress = socket == null || socket.getInetAddress() == null ? "" : socket.getInetAddress().toString() + ":" + socket.getPort();
        if (inetAddress.startsWith("/")) {
            inetAddress = inetAddress.substring(1);
        }
        return inetAddress;
    }

    public static String getLocalAddress(Socket socket) {
        String localAddress;
        String string = localAddress = socket == null || socket.getLocalAddress() == null ? "" : socket.getLocalAddress().toString() + ":" + socket.getLocalPort();
        if (localAddress.startsWith("/")) {
            localAddress = localAddress.substring(1);
        }
        return localAddress;
    }
}

