/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.connectors.tcp.StateAwareSocketInterface;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import org.apache.commons.lang3.StringUtils;

public class StateAwareSocket
extends Socket
implements StateAwareSocketInterface {
    protected BufferedInputStream bis = null;

    public StateAwareSocket() {
    }

    public StateAwareSocket(String host, int port) throws Exception {
        super(host, port);
    }

    public StateAwareSocket(InetAddress address, int port) throws Exception {
        super(address, port);
    }

    public StateAwareSocket(SocketImpl impl) throws SocketException {
        super(impl);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.bis == null) {
            this.bis = new BufferedInputStream(super.getInputStream());
        }
        return this.bis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remoteSideHasClosed() throws IOException {
        int oldTimeout;
        if (this.isClosed()) {
            return true;
        }
        try {
            oldTimeout = this.getSoTimeout();
        }
        catch (IOException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Socket Closed")) {
                return true;
            }
            throw e;
        }
        this.setSoTimeout(100);
        this.getInputStream().mark(1);
        try {
            boolean e = this.bis.read() == -1;
            return e;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.bis.reset();
            }
            catch (IOException iOException) {}
            try {
                this.setSoTimeout(oldTimeout);
            }
            catch (SocketException socketException) {}
        }
    }
}

