/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.cli;

import com.mirth.connect.cli.IntToken;
import com.mirth.connect.cli.Quit;
import com.mirth.connect.cli.StringToken;
import com.mirth.connect.cli.Token;
import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ListHandlerException;
import com.mirth.connect.client.core.PaginatedEventList;
import com.mirth.connect.client.core.PaginatedMessageList;
import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelStatistics;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.filters.EventFilter;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.util.ConfigurationProperty;
import com.mirth.connect.util.MessageExporter;
import com.mirth.connect.util.MessageImporter;
import com.mirth.connect.util.PaginatedList;
import com.mirth.connect.util.messagewriter.AttachmentSource;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import com.mirth.connect.util.messagewriter.MessageWriterFactory;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CommandLineInterface {
    private String DEFAULT_CHARSET = "UTF-8";
    private Client client;
    private boolean debug;
    private SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yy_HH-mm-ss.SS");
    private String currentUser = new String();
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.out, true);

    public CommandLineInterface(String[] args) {
        this.run(args);
    }

    public static void main(String[] args) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.properties");
        new CommandLineInterface(args);
    }

    private void run(String[] args) {
        OptionBuilder.withArgName((String)"address");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"server address");
        Option serverOption = OptionBuilder.create((String)"a");
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"user login");
        Option userOption = OptionBuilder.create((String)"u");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"user password");
        Option passwordOption = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"script");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"script file");
        Option scriptOption = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"version");
        Option versionOption = OptionBuilder.create((String)"v");
        OptionBuilder.withArgName((String)"config file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"path to default configuration [default: mirth-cli-config.properties]");
        Option configOption = OptionBuilder.create((String)"c");
        Option helpOption = new Option("h", "help");
        Option debugOption = new Option("d", "debug");
        Options options = new Options();
        options.addOption(configOption);
        options.addOption(serverOption);
        options.addOption(userOption);
        options.addOption(passwordOption);
        options.addOption(scriptOption);
        options.addOption(versionOption);
        options.addOption(helpOption);
        options.addOption(debugOption);
        GnuParser parser = new GnuParser();
        try {
            Properties configDefaults;
            CommandLine line;
            block7: {
                line = parser.parse(options, args);
                if (line.hasOption("h")) {
                    new HelpFormatter().printHelp("Shell", options);
                    System.exit(0);
                }
                configDefaults = new Properties();
                try {
                    configDefaults.load(new FileInputStream(line.getOptionValue("c", "conf" + File.separator + "mirth-cli-config.properties")));
                }
                catch (IOException e) {
                    if (!line.hasOption("c")) break block7;
                    this.error("We could not find the file: " + line.getOptionValue("c"), null);
                    System.exit(2);
                }
            }
            String server = line.getOptionValue("a", configDefaults.getProperty("address"));
            String user = line.getOptionValue("u", configDefaults.getProperty("user"));
            String password = line.getOptionValue("p", configDefaults.getProperty("password"));
            String script = line.getOptionValue("s", configDefaults.getProperty("script"));
            if (server != null && user != null && password != null) {
                this.runShell(server, user, password, script, line.hasOption("d"));
            } else {
                new HelpFormatter().printHelp("Shell", options);
                this.error("all of address, user, password, and version options must be supplied as arguments or in the default configuration file", null);
                System.exit(2);
            }
        }
        catch (ParseException e) {
            this.error("Could not parse input arguments.", e);
            System.exit(2);
        }
    }

    private void runShell(String server, String user, String password, String script, boolean debug) {
        try {
            this.client = new Client(server);
            this.debug = debug;
            LoginStatus loginStatus = this.client.login(user, password);
            if (loginStatus.getStatus() != LoginStatus.Status.SUCCESS) {
                this.error("Could not login to server.", null);
                return;
            }
            String serverVersion = this.client.getVersion();
            try {
                ObjectXMLSerializer.getInstance().init(serverVersion);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out.println("Connected to BridgeLink server @ " + server + " (" + serverVersion + ")");
            this.currentUser = StringUtils.defaultString((String)loginStatus.getUpdatedUsername(), (String)user);
            if (script != null) {
                this.runScript(script);
            } else {
                this.runConsole();
            }
            this.client.logout();
            this.client.close();
            this.out.println("Disconnected from server.");
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            this.error("Could not load script file.", ioe);
        }
        catch (URISyntaxException e) {
            this.error("Invalid server address.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(String script) throws IOException {
        String statement = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(script));){
            while ((statement = reader.readLine()) != null) {
                this.out.println("Executing statement: " + statement);
                this.executeStatement(statement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConsole() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String statement = null;
        this.writePrompt();
        try {
            while ((statement = reader.readLine()) != null) {
                this.executeStatement(statement);
                this.writePrompt();
            }
            this.out.println();
        }
        catch (Quit quit) {
        }
        finally {
            reader.close();
        }
    }

    private void error(String message, Throwable t) {
        this.err.println("Error: " + message);
        if (t != null && this.debug) {
            this.err.println(ExceptionUtils.getStackTrace((Throwable)t));
        }
    }

    private void writePrompt() {
        this.out.print("$");
        this.out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeStatement(String command) {
        try {
            Token[] arguments = this.tokenizeCommand(command);
            if (arguments.length < 1) return;
            Token arg1 = arguments[0];
            if (arg1 == Token.HELP) {
                this.commandHelp(arguments);
                return;
            }
            if (arg1 == Token.USER) {
                if (arguments.length < 2) {
                    this.error("invalid number of arguments.", null);
                    return;
                }
                Token arg2 = arguments[1];
                if (arg2 == Token.LIST) {
                    this.commandUserList(arguments);
                    return;
                }
                if (arg2 == Token.ADD) {
                    this.commandUserAdd(arguments);
                    return;
                }
                if (arg2 == Token.REMOVE) {
                    this.commandUserRemove(arguments);
                    return;
                }
                if (arg2 != Token.CHANGEPW) return;
                this.commandUserChangePassword(arguments);
                return;
            }
            if (arg1 == Token.DEPLOY) {
                this.commandDeploy(arguments);
                return;
            }
            if (arg1 == Token.EXPORTCFG) {
                this.commandExportConfig(arguments);
                return;
            }
            if (arg1 == Token.IMPORTCFG) {
                this.commandImportConfig(arguments);
                return;
            }
            if (arg1 == Token.IMPORT) {
                this.commandImport(arguments);
                return;
            }
            if (arg1 == Token.IMPORTALERTS) {
                this.commandImportAlerts(arguments);
                return;
            }
            if (arg1 == Token.EXPORTALERTS) {
                this.commandExportAlerts(arguments);
                return;
            }
            if (arg1 == Token.IMPORTSCRIPTS) {
                this.commandImportScripts(arguments);
                return;
            }
            if (arg1 == Token.EXPORTSCRIPTS) {
                this.commandExportScripts(arguments);
                return;
            }
            if (arg1 == Token.IMPORTCODETEMPLATES) {
                this.error("The importcodetemplates command is deprecated. Please use \"codetemplate [library] import path [force]\" instead.", null);
                if (this.hasInvalidNumberOfArguments(arguments, 2)) return;
                this.commandImportCodeTemplates(arguments[1].getText(), true);
                return;
            }
            if (arg1 == Token.EXPORTCODETEMPLATES) {
                this.error("The exportcodetemplates command is deprecated. Please use \"codetemplate [library] export id|name|* path\" instead.", null);
                if (this.hasInvalidNumberOfArguments(arguments, 2)) return;
                this.commandExportCodeTemplateLibraries("*", arguments[1].getText());
                return;
            }
            if (arg1 == Token.IMPORTMESSAGES) {
                this.commandImportMessages(arguments);
                return;
            }
            if (arg1 == Token.EXPORTMESSAGES) {
                this.commandExportMessages(arguments);
                return;
            }
            if (arg1 == Token.IMPORTMAP) {
                this.commandImportMap(arguments);
                return;
            }
            if (arg1 == Token.EXPORTMAP) {
                this.commandExportMap(arguments);
                return;
            }
            if (arg1 == Token.STATUS) {
                this.commandStatus(arguments);
                return;
            }
            if (arg1 == Token.EXPORT) {
                this.commandExport(arguments);
                return;
            }
            if (arg1 == Token.CHANNEL) {
                String syntax = "invalid number of arguments. Syntax is: channel start|stop|pause|resume|stats|remove|enable|disable <id|name>, channel rename <id|name> newname, or channel list|stats";
                if (arguments.length < 2) {
                    this.error(syntax, null);
                    return;
                }
                if (arguments.length < 3 && arguments[1] != Token.LIST && arguments[1] != Token.STATS) {
                    this.error(syntax, null);
                    return;
                }
                Token comm = arguments[1];
                if (comm == Token.STATS && arguments.length < 3) {
                    this.commandAllChannelStats(arguments);
                    return;
                }
                if (comm == Token.LIST) {
                    this.commandChannelList(arguments);
                    return;
                }
                if (comm == Token.DISABLE) {
                    this.commandChannelDisable(arguments);
                    return;
                }
                if (comm == Token.ENABLE) {
                    this.commandChannelEnable(arguments);
                    return;
                }
                if (comm == Token.REMOVE) {
                    this.commandChannelRemove(arguments);
                    return;
                }
                if (comm == Token.START) {
                    this.commandChannelStart(arguments);
                    return;
                }
                if (comm == Token.STOP) {
                    this.commandChannelStop(arguments);
                    return;
                }
                if (comm == Token.HALT) {
                    this.commandChannelHalt(arguments);
                    return;
                }
                if (comm == Token.PAUSE) {
                    this.commandChannelPause(arguments);
                    return;
                }
                if (comm == Token.RESUME) {
                    this.commandChannelResume(arguments);
                    return;
                }
                if (comm == Token.STATS) {
                    this.commandChannelStats(arguments);
                    return;
                }
                if (comm == Token.RENAME) {
                    this.commandChannelRename(arguments);
                    return;
                }
                if (comm == Token.DEPLOY) {
                    this.commandChannelDeploy(arguments);
                    return;
                }
                if (comm == Token.UNDEPLOY) {
                    this.commandChannelUndeploy(arguments);
                    return;
                }
                this.error("unknown channel command " + String.valueOf(comm), null);
                return;
            }
            if (arg1 == Token.CODE_TEMPLATE) {
                if (arguments.length < 2) {
                    this.error("Invalid number of arguments. Syntax is: codetemplate library list [includecodetemplates], codetemplate list, codetemplate [library] import path [force], codetemplate export id|name path, codetemplate library export id|name|* path, codetemplate remove id|name, or codetemplate library remove id|name|*", null);
                    return;
                }
                Token arg2 = arguments[1];
                if (arg2 == Token.LIBRARY) {
                    if (arguments.length < 3) {
                        this.error("Invalid number of arguments. Syntax is: codetemplate library list [includecodetemplates], codetemplate library import path [force], codetemplate library export id|name|* path, or codetemplate library remove id|name|*", null);
                        return;
                    }
                    Token arg3 = arguments[2];
                    if (arg3 == Token.LIST) {
                        this.commandListCodeTemplateLibraries(arguments.length > 3 && StringUtils.equalsIgnoreCase((CharSequence)arguments[3].getText(), (CharSequence)"includecodetemplates"));
                        return;
                    }
                    if (arg3 == Token.IMPORT) {
                        if (arguments.length < 4) {
                            this.error("Invalid number of arguments. Syntax is: codetemplate library import path [force]", null);
                            return;
                        }
                        this.commandImportCodeTemplateLibraries(arguments[3].getText(), arguments.length > 4 && StringUtils.equalsIgnoreCase((CharSequence)arguments[4].getText(), (CharSequence)"force"));
                        return;
                    }
                    if (arg3 == Token.EXPORT) {
                        if (arguments.length < 5) {
                            this.error("Invalid number of arguments. Syntax is: codetemplate library export id|name|* path", null);
                            return;
                        }
                        this.commandExportCodeTemplateLibraries(arguments[3].getText(), arguments[4].getText());
                        return;
                    }
                    if (arg3 != Token.REMOVE) {
                        this.error("Unknown code template library command " + String.valueOf(arg3) + ". Syntax is: codetemplate library list [includecodetemplates], codetemplate library import path [force], codetemplate library export id|name|* path, or codetemplate library remove id|name|*", null);
                        return;
                    }
                    if (arguments.length < 4) {
                        this.error("Invalid number of arguments. Syntax is: codetemplate library remove id|name|*", null);
                        return;
                    }
                    this.commandRemoveCodeTemplateLibraries(arguments[3].getText());
                    return;
                }
                if (arg2 == Token.LIST) {
                    this.commandListCodeTemplates();
                    return;
                }
                if (arg2 == Token.IMPORT) {
                    if (arguments.length < 3) {
                        this.error("Invalid number of arguments. Syntax is: codetemplate import path [force]", null);
                        return;
                    }
                    this.commandImportCodeTemplates(arguments[2].getText(), arguments.length > 3 && StringUtils.equalsIgnoreCase((CharSequence)arguments[3].getText(), (CharSequence)"force"));
                    return;
                }
                if (arg2 == Token.EXPORT) {
                    if (arguments.length < 4) {
                        this.error("Invalid number of arguments. Syntax is: codetemplate export id|name path", null);
                        return;
                    }
                    this.commandExportCodeTemplate(arguments[2].getText(), arguments[3].getText());
                    return;
                }
                if (arg2 != Token.REMOVE) {
                    this.error("Unknown code template command " + String.valueOf(arg2) + ". Syntax is: codetemplate library list [includecodetemplates], codetemplate list, codetemplate [library] import path [force], codetemplate export id|name path, codetemplate library export id|name|* path, codetemplate remove id|name, or codetemplate library remove id|name|*", null);
                    return;
                }
                if (arguments.length < 3) {
                    this.error("Invalid number of arguments. Syntax is: codetemplate remove id|name", null);
                    return;
                }
                this.commandRemoveCodeTemplate(arguments[2].getText());
                return;
            }
            if (arg1 == Token.CLEARALLMESSAGES) {
                this.commandClearAllMessages(arguments);
                return;
            }
            if (arg1 == Token.RESETSTATS) {
                this.commandResetstats(arguments);
                return;
            }
            if (arg1 == Token.DUMP) {
                if (arguments.length < 2) {
                    this.error("missing dump commands.", null);
                    return;
                }
                Token arg2 = arguments[1];
                if (arg2 == Token.STATS) {
                    this.commandDumpStats(arguments);
                    return;
                }
                if (arg2 == Token.EVENTS) {
                    this.commandDumpEvents(arguments);
                    return;
                }
                this.error("unknown dump command: " + String.valueOf(arg2), null);
                return;
            }
            if (arg1 == Token.QUIT) {
                throw new Quit();
            }
            this.error("unknown command: " + command, null);
            return;
        }
        catch (ClientException e) {
            e.printStackTrace(this.err);
        }
    }

    private boolean hasInvalidNumberOfArguments(Token[] arguments, int expected) {
        if (arguments.length - 1 < expected) {
            this.error("invalid number of arguments.", null);
            return true;
        }
        return false;
    }

    private Token[] tokenizeCommand(String command) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder currentToken = null;
        char[] chars = command.toCharArray();
        boolean inQuotes = false;
        for (int idx = 0; idx < chars.length; ++idx) {
            char ch = chars[idx];
            if (currentToken == null) {
                if (ch == ' ') continue;
                currentToken = new StringBuilder();
            }
            if (inQuotes && ch != '\"') {
                currentToken.append(ch);
                continue;
            }
            if (inQuotes && ch == '\"') {
                inQuotes = false;
                continue;
            }
            if (!inQuotes && ch == '\"') {
                inQuotes = true;
                continue;
            }
            if (!inQuotes && ch == ' ') {
                this.addToken(tokens, currentToken);
                currentToken = null;
                continue;
            }
            if (!inQuotes && ch == '#') break;
            if (!inQuotes) {
                currentToken.append(ch);
                continue;
            }
            throw new IllegalStateException("impossible state in tokenizer: inQuotes=" + inQuotes + ", char=" + ch);
        }
        this.addToken(tokens, currentToken);
        Token[] arguments = new Token[tokens.size()];
        tokens.toArray(arguments);
        return arguments;
    }

    private void addToken(List<Token> tokens, StringBuilder currentText) {
        if (currentText == null || StringUtils.isEmpty((CharSequence)currentText.toString())) {
            return;
        }
        String text = currentText.toString();
        Token token = Token.getKeyword(text);
        if (token == null) {
            try {
                token = Token.intToken(text);
            }
            catch (NumberFormatException e) {
                token = Token.stringToken(text);
            }
        }
        tokens.add(token);
    }

    private void commandHelp(Token[] arguments) {
        this.out.println("Available Commands:");
        this.out.println("status\n\tReturns status of deployed channels\n");
        this.out.println("deploy [timeout]\n\tDeploys all Channels with optional timeout (in seconds)\n");
        this.out.println("import \"path\" [force]\n\tImports channel specified by <path>.  Optional 'force' overwrites existing channels.\n");
        this.out.println("export id|\"name\"|* \"path\"\n\tExports the specified channel to <path>\n");
        this.out.println("importcfg \"path\" [nodeploy] [overwriteconfigmap]\n\tImports configuration specified by <path>.  Optional 'nodeploy' stops channels from being deployed after importing.  Optional 'overwriteconfigmap' will overwrite the Configuration Map.\n");
        this.out.println("exportcfg \"path\"\n\tExports the configuration to <path>\n");
        this.out.println("importalert \"path\" [force]\n\tImports alert specified by <path>.  Optional 'force' overwrites existing alerts.\n");
        this.out.println("exportalert id|\"name\"|* \"path\"\n\tExports the specified alert to <path>\n");
        this.out.println("importscripts \"path\"\n\tImports global script specified by <path>\n");
        this.out.println("exportscripts \"path\"\n\tExports global script to <path>\n");
        this.out.println("codetemplate library list [includecodetemplates]\n\tLists all code template libraries. Optional 'includecodetemplates' additionally lists the code templates within each library.\n");
        this.out.println("codetemplate list\n\tLists all code templates.\n");
        this.out.println("codetemplate [library] import path [force]\n\tImports code templates or libraries (with the 'library' option).\n");
        this.out.println("codetemplate library export id|name|* path\n\tExports all matched code template libraries to <path>.\n");
        this.out.println("codetemplate export id|name path\n\tExports a single code template to <path>.\n");
        this.out.println("codetemplate library remove id|name|*\n\tRemoves all matched code template libraries.\n");
        this.out.println("codetemplate remove id|name\n\tRemoves a single code template.\n");
        this.out.println("importmessages \"path\" id\n\tImports messages specified by <path> into the channel specified by <id>\n");
        this.out.println("exportmessages \"path/file-pattern\" id [xml|xml-attach|raw|processedraw|transformed|encoded|response] [pageSize]\n\tExports all messages for channel specified by <id> to <path>\n");
        this.out.println("importmap \"path\"\n\tImports configuration map specified by <path>\n");
        this.out.println("exportmap \"path\"\n\tExports configuration map to <path>\n");
        this.out.println("channel undeploy|deploy|start|stop|halt|pause|resume|stats id|\"name\"|*\n\tPerforms specified channel action\n");
        this.out.println("channel remove|enable|disable id|\"name\"|*\n\tRemove, enable or disable specified channel\n");
        this.out.println("channel list\n\tLists all Channels\n");
        this.out.println("clearallmessages\n\tRemoves all messages from all Channels (running channels will be restarted)\n");
        this.out.println("resetstats [lifetime]\n\tRemoves all stats from all Channels. Optional 'lifetime' includes resetting lifetime stats.\n");
        this.out.println("dump stats|events \"path\"\n\tDumps stats or events to specified file\n");
        this.out.println("user list\n\tReturns a list of the current users\n");
        this.out.println("user add username \"password\" \"firstName\" \"lastName\" \"organization\" \"email\"\n\tAdds the specified user\n");
        this.out.println("user remove id|username\n\tRemoves the specified user\n");
        this.out.println("user changepw id|username \"newpassword\"\n\tChanges the specified user's password\n");
        this.out.println("quit\n\tQuits BridgeLink Shell");
    }

    private void commandUserList(Token[] arguments) throws ClientException {
        List users = this.client.getAllUsers();
        this.out.println("ID\tUser Name\tName\t\t\tEmail");
        for (User user : users) {
            this.out.println(user.getId() + "\t" + user.getUsername() + "\t\t" + user.getFirstName() + "\t\t" + user.getLastName() + "\t\t" + user.getOrganization() + "\t\t" + user.getEmail());
        }
    }

    private void commandUserAdd(Token[] arguments) throws ClientException {
        if (arguments.length < 8) {
            this.error("invalid number of arguments. Syntax is user add username \"password\" \"firstName\" \"lastName\" \"organization\" \"email\"", null);
            return;
        }
        String username = arguments[2].getText();
        if (username.length() < 1) {
            this.error("unable to add user: username too short.", null);
            return;
        }
        String password = arguments[3].getText();
        String firstName = arguments[4].getText();
        String lastName = arguments[5].getText();
        String organization = arguments[6].getText();
        String email = arguments[7].getText();
        User user = new User();
        user.setUsername(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setOrganization(organization);
        user.setEmail(email);
        List users = this.client.getAllUsers();
        for (Object luser : users) {
            if (!luser.getUsername().equalsIgnoreCase(username)) continue;
            this.error("unable to add user: username in use.", null);
            return;
        }
        try {
            List responses = this.client.checkUserPassword(password);
            if (responses != null) {
                for (String response : responses) {
                    this.out.println(response);
                }
                return;
            }
            this.client.createUser(user);
            User newUser = this.client.getUser(username);
            responses = this.client.updateUserPassword(newUser.getId(), password);
            if (responses != null) {
                System.out.println("User \"" + username + "\" has been created but the password could not be set:");
                for (String response : responses) {
                    this.out.println(response);
                }
            } else {
                this.out.println("User \"" + username + "\" added successfully.");
            }
        }
        catch (Exception e) {
            this.error("unable to add user \"" + username + "\": " + String.valueOf(e), e);
        }
    }

    private void commandUserRemove(Token[] arguments) throws ClientException {
        if (arguments.length < 3) {
            this.error("invalid number of arguments. Syntax is user remove username|id", null);
            return;
        }
        String key = arguments[2].getText();
        if (key.equalsIgnoreCase(this.currentUser)) {
            this.error("cannot remove current user.", null);
            return;
        }
        List users = this.client.getAllUsers();
        for (User user : users) {
            if (!user.getId().toString().equalsIgnoreCase(key) && !user.getUsername().equalsIgnoreCase(key)) continue;
            this.client.removeUser(user.getId());
            this.out.println("User \"" + user.getUsername() + "\" successfully removed.");
            return;
        }
    }

    private void commandUserChangePassword(Token[] arguments) throws ClientException {
        if (arguments.length < 4) {
            this.error("invalid number of arguments. Syntax is user changepw username|id \"newpassword\"", null);
            return;
        }
        String key = arguments[2].getText();
        String newPassword = arguments[3].getText();
        List users = this.client.getAllUsers();
        for (User user : users) {
            if (!user.getId().toString().equalsIgnoreCase(key) && !user.getUsername().equalsIgnoreCase(key)) continue;
            List responses = this.client.updateUserPassword(user.getId(), newPassword);
            if (responses != null) {
                for (String response : responses) {
                    this.out.println(response);
                }
            } else {
                this.out.println("User \"" + user.getUsername() + "\" password updated.");
            }
            return;
        }
    }

    private void commandDeploy(Token[] arguments) throws ClientException {
        this.out.println("Deploying Channels");
        List channels = this.client.getAllChannels();
        Map metadataMap = this.client.getChannelMetadata();
        boolean hasChannels = false;
        for (Channel channel : channels) {
            ChannelMetadata metadata = (ChannelMetadata)metadataMap.get(channel.getId());
            if (channel instanceof InvalidChannel || metadata == null || !metadata.isEnabled()) continue;
            hasChannels = true;
            break;
        }
        this.client.redeployAllChannels();
        if (hasChannels) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            List channelStatus = this.client.getAllChannelStatuses();
            int limit = 60;
            if (arguments.length > 1 && arguments[1] instanceof IntToken) {
                limit = ((IntToken)arguments[1]).getValue() * 2;
            }
            while (channelStatus.size() == 0 && limit > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                channelStatus = this.client.getAllChannelStatuses();
                --limit;
            }
            if (limit > 0) {
                this.out.println("Channels Deployed");
            } else {
                this.out.println("Deployment Timed out");
            }
        } else {
            this.out.println("No Channels to Deploy");
        }
    }

    private void commandExportConfig(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        try {
            ServerConfiguration configuration = this.client.getServerConfiguration();
            String backupDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            configuration.setDate(backupDate);
            File fXml = new File(path);
            this.out.println("Exporting Configuration");
            String configurationXML = serializer.serialize((Object)configuration);
            FileUtils.writeStringToFile((File)fXml, (String)configurationXML);
        }
        catch (IOException e) {
            this.error("unable to write file " + path + ": " + String.valueOf(e), e);
        }
        this.out.println("Configuration Export Complete.");
    }

    private void commandImportConfig(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        File fXml = new File(path);
        boolean deploy = true;
        boolean overwriteConfigMap = false;
        if (arguments.length >= 3) {
            if (arguments[2] == Token.NODEPLOY) {
                deploy = false;
            } else if (arguments[2] == Token.OVERWRITECONFIGMAP) {
                overwriteConfigMap = true;
            }
            if (arguments.length >= 4) {
                if (arguments[3] == Token.NODEPLOY) {
                    deploy = false;
                } else if (arguments[3] == Token.OVERWRITECONFIGMAP) {
                    overwriteConfigMap = true;
                }
            }
        }
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        try {
            this.client.setServerConfiguration((ServerConfiguration)serializer.deserialize(FileUtils.readFileToString((File)fXml), ServerConfiguration.class), deploy, overwriteConfigMap);
        }
        catch (IOException e) {
            this.error("cannot read " + path, e);
            return;
        }
        this.out.println("Configuration Import Complete.");
    }

    private void commandImport(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        boolean force = false;
        if (arguments.length >= 3 && arguments[2] == Token.FORCE) {
            force = true;
        }
        File fXml = new File(path);
        this.doImportChannel(fXml, force);
    }

    private void commandImportAlerts(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        boolean force = false;
        if (arguments.length >= 3 && arguments[2] == Token.FORCE) {
            force = true;
        }
        File fXml = new File(path);
        this.doImportAlert(fXml, force);
    }

    private void commandExportAlerts(Token[] arguments) throws ClientException {
        if (arguments.length < 3) {
            this.error("invalid number of arguments. Syntax is: export id|name|* \"path\"", null);
            return;
        }
        Token key = arguments[1];
        String path = arguments[2].getText();
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        List alerts = this.client.getAllAlerts();
        if (key == Token.WILDCARD) {
            for (AlertModel alert : alerts) {
                try {
                    File fXml = new File(path + alert.getName() + ".xml");
                    this.out.println("Exporting " + alert.getName());
                    String alertXML = serializer.serialize((Object)alert);
                    FileUtils.writeStringToFile((File)fXml, (String)alertXML);
                }
                catch (IOException e) {
                    this.error("unable to write file " + path + ": " + String.valueOf(e), e);
                }
            }
            this.out.println("Export Complete.");
            return;
        }
        File fXml = new File(path);
        StringToken skey = Token.stringToken(key.getText());
        for (AlertModel alert : alerts) {
            if (skey.equalsIgnoreCase(alert.getName()) == skey.equalsIgnoreCase(alert.getId())) continue;
            this.out.println("Exporting " + alert.getName());
            String alertXML = serializer.serialize((Object)alert);
            try {
                FileUtils.writeStringToFile((File)fXml, (String)alertXML);
            }
            catch (IOException e) {
                this.error("unable to write file " + path + ": " + String.valueOf(e), e);
            }
            this.out.println("Export Complete.");
            return;
        }
    }

    private void commandExportScripts(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        String path = arguments[1].getText();
        File fXml = new File(path);
        try {
            String scriptsXml = serializer.serialize((Object)this.client.getGlobalScripts());
            this.out.println("Exporting scripts");
            FileUtils.writeStringToFile((File)fXml, (String)scriptsXml);
        }
        catch (IOException e) {
            this.error("unable to write file " + path + ": " + String.valueOf(e), e);
        }
        this.out.println("Script Export Complete.");
    }

    private void commandImportScripts(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        File fXml = new File(path);
        this.doImportScript(fXml);
        this.out.println("Scripts Import Complete");
    }

    private void commandListCodeTemplateLibraries(boolean includeCodeTemplates) throws ClientException {
        List libraries = this.client.getCodeTemplateLibraries(null, includeCodeTemplates);
        int maxLibraryNameLength = 4;
        for (Object library : libraries) {
            if (library.getName().length() <= maxLibraryNameLength) continue;
            maxLibraryNameLength = library.getName().length();
        }
        int maxCodeTemplateNameLength = 4;
        if (includeCodeTemplates) {
            for (CodeTemplateLibrary library : libraries) {
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    if (codeTemplate.getName().length() <= maxCodeTemplateNameLength) continue;
                    maxCodeTemplateNameLength = codeTemplate.getName().length();
                }
            }
        }
        boolean showLibraryHeader = true;
        for (CodeTemplateLibrary library : libraries) {
            if (showLibraryHeader) {
                this.out.printf("%-" + maxLibraryNameLength + "s  %-36s  %-8s  %s\n", "Name", "Id", "Revision", "Last Modified");
                this.out.printf("%-" + maxLibraryNameLength + "s  %-36s  %-8s  %s\n", StringUtils.repeat((char)'-', (int)maxLibraryNameLength), StringUtils.repeat((char)'-', (int)36), StringUtils.repeat((char)'-', (int)8), StringUtils.repeat((char)'-', (int)19));
                showLibraryHeader = false;
            }
            this.out.printf("%-" + maxLibraryNameLength + "s  %-36s  %-8d  %tF %<tT\n", library.getName(), library.getId(), library.getRevision(), library.getLastModified());
            if (!includeCodeTemplates || library.getCodeTemplates().size() <= 0) continue;
            this.out.println();
            this.listCodeTemplates(library.getCodeTemplates(), true, maxCodeTemplateNameLength);
            this.out.println();
            showLibraryHeader = true;
        }
    }

    private void commandImportCodeTemplateLibraries(String path, boolean force) throws ClientException {
        try {
            List libraries = ObjectXMLSerializer.getInstance().deserializeList(FileUtils.readFileToString((File)new File(path)), CodeTemplateLibrary.class);
            this.removeInvalidItems(libraries, CodeTemplateLibrary.class);
            if (libraries.isEmpty()) {
                this.out.println("No code template libraries found in file \"" + path + "\".");
                return;
            }
            HashMap<String, Object> libraryMap = new HashMap<String, Object>();
            for (Object library : this.client.getCodeTemplateLibraries(null, false)) {
                libraryMap.put(library.getId(), library);
            }
            HashMap<String, CodeTemplate> codeTemplateMap = new HashMap<String, CodeTemplate>();
            for (CodeTemplateLibrary library : libraries) {
                CodeTemplateLibrary matchingLibrary = (CodeTemplateLibrary)libraryMap.get((library = new CodeTemplateLibrary(library)).getId());
                if (matchingLibrary != null) {
                    library.getEnabledChannelIds().addAll(matchingLibrary.getEnabledChannelIds());
                    library.getDisabledChannelIds().addAll(matchingLibrary.getDisabledChannelIds());
                    library.getDisabledChannelIds().removeAll(library.getEnabledChannelIds());
                    for (CodeTemplate codeTemplate : matchingLibrary.getCodeTemplates()) {
                        boolean found = false;
                        for (CodeTemplate codeTemplate2 : library.getCodeTemplates()) {
                            if (!codeTemplate.getId().equals(codeTemplate2.getId())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        library.getCodeTemplates().add(codeTemplate);
                    }
                }
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    if (codeTemplate.getName() == null) continue;
                    codeTemplateMap.put(codeTemplate.getId(), codeTemplate);
                }
                libraryMap.put(library.getId(), library);
            }
            CodeTemplateLibrarySaveResult updateSummary = this.client.updateLibrariesAndTemplates(new ArrayList(libraryMap.values()), new HashSet(), new ArrayList(codeTemplateMap.values()), new HashSet(), force);
            if (!updateSummary.isOverrideNeeded()) {
                if (updateSummary.isLibrariesSuccess()) {
                    this.out.println(libraries.size() + " code template libraries imported successfully.");
                    ArrayList<CodeTemplate> failedCodeTemplates = new ArrayList<CodeTemplate>();
                    Throwable firstCause = null;
                    for (Map.Entry entry : updateSummary.getCodeTemplateResults().entrySet()) {
                        if (((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)entry.getValue()).isSuccess()) continue;
                        failedCodeTemplates.add((CodeTemplate)codeTemplateMap.get(entry.getKey()));
                        if (firstCause != null) continue;
                        firstCause = ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)entry.getValue()).getCause();
                    }
                    if (!failedCodeTemplates.isEmpty()) {
                        this.out.println("The following code templates failed to be imported:\n");
                        this.listCodeTemplates(failedCodeTemplates, true);
                    }
                    if (firstCause != null) {
                        throw new ClientException(firstCause);
                    }
                } else {
                    this.error("Failed to import code template libraries.", updateSummary.getLibrariesCause());
                }
            } else {
                this.error("One or more code templates or libraries is outdated (use the \"force\" option to import them anyway).", null);
            }
        }
        catch (IOException e) {
            this.error("Failed to read file: " + path, e);
        }
        catch (SerializerException e) {
            this.error("Invalid code template file: " + path, e);
        }
    }

    private void commandExportCodeTemplateLibraries(String searchText, String path) throws ClientException {
        List libraries = this.client.getCodeTemplateLibraries(null, true);
        ArrayList<CodeTemplateLibrary> exportLibraries = new ArrayList<CodeTemplateLibrary>();
        for (CodeTemplateLibrary library : libraries) {
            if (library.getId().equals(searchText)) {
                exportLibraries.clear();
                exportLibraries.add(library);
                break;
            }
            if (!searchText.equals("*") && !StringUtils.equals((CharSequence)library.getName(), (CharSequence)searchText)) continue;
            exportLibraries.add(library);
        }
        if (exportLibraries.isEmpty()) {
            this.out.println("No code template libraries found for search criteria \"" + searchText + "\".");
            return;
        }
        try {
            FileUtils.writeStringToFile((File)new File(path), (String)ObjectXMLSerializer.getInstance().serialize(exportLibraries));
            this.out.println("Successfully exported " + exportLibraries.size() + " code template librar" + (exportLibraries.size() == 1 ? "y" : "ies") + ".");
        }
        catch (IOException e) {
            this.error("Error exporting code template libraries to file: " + path, e);
        }
    }

    private void commandRemoveCodeTemplateLibraries(String searchText) throws ClientException {
        List libraries = this.client.getCodeTemplateLibraries(null, false);
        ArrayList<CodeTemplateLibrary> matchedLibraries = new ArrayList<CodeTemplateLibrary>();
        for (CodeTemplateLibrary library : libraries) {
            if (library.getId().equals(searchText)) {
                matchedLibraries.clear();
                matchedLibraries.add(library);
                break;
            }
            if (!searchText.equals("*") && !StringUtils.equals((CharSequence)library.getName(), (CharSequence)searchText)) continue;
            matchedLibraries.add(library);
        }
        if (matchedLibraries.isEmpty()) {
            this.out.println("No code template libraries found for search criteria \"" + searchText + "\".");
            return;
        }
        ArrayList<CodeTemplateLibrary> updatedLibraries = new ArrayList<CodeTemplateLibrary>();
        for (CodeTemplateLibrary library : libraries) {
            if (matchedLibraries.contains(library)) continue;
            updatedLibraries.add(library);
        }
        if (this.client.updateCodeTemplateLibraries(updatedLibraries, true)) {
            this.out.println("Successfully removed " + matchedLibraries.size() + " code template librar" + (matchedLibraries.size() == 1 ? "y" : "ies") + ".");
            for (CodeTemplateLibrary library : matchedLibraries) {
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    try {
                        this.client.removeCodeTemplate(codeTemplate.getId());
                    }
                    catch (ClientException e) {
                        this.error("Error removing code template " + codeTemplate.getId() + ".", e);
                    }
                }
            }
        }
    }

    private void commandListCodeTemplates() throws ClientException {
        this.listCodeTemplates(this.client.getCodeTemplates(null), false);
    }

    private void listCodeTemplates(List<CodeTemplate> codeTemplates, boolean indent) {
        this.listCodeTemplates(codeTemplates, indent, 4);
    }

    private void listCodeTemplates(List<CodeTemplate> codeTemplates, boolean indent, int maxNameLength) {
        for (CodeTemplate codeTemplate : codeTemplates) {
            if (codeTemplate.getName().length() <= maxNameLength) continue;
            maxNameLength = codeTemplate.getName().length();
        }
        this.out.printf(String.valueOf(indent ? Character.valueOf('\t') : "") + "%-" + maxNameLength + "s  %-36s  %-24s  %-8s  %s\n", "Name", "Id", "Type", "Revision", "Last Modified");
        this.out.printf(String.valueOf(indent ? Character.valueOf('\t') : "") + "%-" + maxNameLength + "s  %-36s  %-24s  %-8s  %s\n", StringUtils.repeat((char)'-', (int)maxNameLength), StringUtils.repeat((char)'-', (int)36), StringUtils.repeat((char)'-', (int)24), StringUtils.repeat((char)'-', (int)8), StringUtils.repeat((char)'-', (int)19));
        for (CodeTemplate codeTemplate : codeTemplates) {
            this.out.printf(String.valueOf(indent ? Character.valueOf('\t') : "") + "%-" + maxNameLength + "s  %-36s  %-24s  %-8d  %tF %<tT\n", codeTemplate.getName(), codeTemplate.getId(), codeTemplate.getType(), codeTemplate.getRevision(), codeTemplate.getLastModified());
        }
    }

    private void commandImportCodeTemplates(String path, boolean force) throws ClientException {
        try {
            List codeTemplates = ObjectXMLSerializer.getInstance().deserializeList(FileUtils.readFileToString((File)new File(path)), CodeTemplate.class);
            this.removeInvalidItems(codeTemplates, CodeTemplate.class);
            if (codeTemplates.isEmpty()) {
                this.out.println("No code templates found in file \"" + path + "\".");
                return;
            }
            ArrayList<CodeTemplate> outdatedCodeTemplates = new ArrayList<CodeTemplate>();
            ArrayList<CodeTemplate> failedCodeTemplates = new ArrayList<CodeTemplate>();
            ClientException firstCause = null;
            Iterator it = codeTemplates.iterator();
            while (it.hasNext()) {
                CodeTemplate codeTemplate = (CodeTemplate)it.next();
                try {
                    if (this.client.updateCodeTemplate(codeTemplate, force)) continue;
                    outdatedCodeTemplates.add(codeTemplate);
                    it.remove();
                }
                catch (ClientException e) {
                    failedCodeTemplates.add(codeTemplate);
                    it.remove();
                    if (firstCause != null) continue;
                    firstCause = e;
                }
            }
            this.out.println(codeTemplates.size() + " code template" + (codeTemplates.size() == 1 ? "" : "s") + " imported successfully.");
            if (!outdatedCodeTemplates.isEmpty()) {
                this.out.println("The following code template" + (outdatedCodeTemplates.size() == 1 ? " is" : "s are") + " outdated (use the \"force\" option to import them anyway):\n");
                this.listCodeTemplates(outdatedCodeTemplates, true);
            }
            if (!failedCodeTemplates.isEmpty()) {
                this.out.println("The following code template" + (failedCodeTemplates.size() == 1 ? "" : "s") + " failed to be imported:\n");
                this.listCodeTemplates(failedCodeTemplates, true);
            }
            if (firstCause != null) {
                throw firstCause;
            }
        }
        catch (IOException e) {
            this.error("Failed to read file: " + path, e);
        }
        catch (SerializerException e) {
            this.error("Invalid code template file: " + path, e);
        }
    }

    private void commandExportCodeTemplate(String searchText, String path) throws ClientException {
        List codeTemplates = this.client.getCodeTemplates(null);
        ArrayList<CodeTemplate> exportCodeTemplates = new ArrayList<CodeTemplate>();
        for (CodeTemplate codeTemplate : codeTemplates) {
            if (StringUtils.equals((CharSequence)codeTemplate.getId(), (CharSequence)searchText)) {
                exportCodeTemplates.clear();
                exportCodeTemplates.add(codeTemplate);
                break;
            }
            if (!StringUtils.equals((CharSequence)codeTemplate.getName(), (CharSequence)searchText)) continue;
            exportCodeTemplates.add(codeTemplate);
        }
        if (exportCodeTemplates.isEmpty()) {
            this.out.println("No code templates found for search criteria \"" + searchText + "\".");
            return;
        }
        if (exportCodeTemplates.size() > 1) {
            this.error("Error exporting code template by name, multiple found:", null);
            this.listCodeTemplates(exportCodeTemplates, false);
            return;
        }
        try {
            FileUtils.writeStringToFile((File)new File(path), (String)ObjectXMLSerializer.getInstance().serialize(exportCodeTemplates.get(0)));
            this.out.println("Successfully exported code template.");
        }
        catch (IOException e) {
            this.error("Error exporting code template to file: " + path, e);
        }
    }

    private void commandRemoveCodeTemplate(String searchText) throws ClientException {
        List codeTemplates = this.client.getCodeTemplates(null);
        ArrayList<CodeTemplate> removeCodeTemplates = new ArrayList<CodeTemplate>();
        for (CodeTemplate codeTemplate : codeTemplates) {
            if (StringUtils.equals((CharSequence)codeTemplate.getId(), (CharSequence)searchText)) {
                removeCodeTemplates.clear();
                removeCodeTemplates.add(codeTemplate);
                break;
            }
            if (!StringUtils.equals((CharSequence)codeTemplate.getName(), (CharSequence)searchText)) continue;
            removeCodeTemplates.add(codeTemplate);
        }
        if (removeCodeTemplates.isEmpty()) {
            this.out.println("No code templates found for search criteria \"" + searchText + "\".");
            return;
        }
        if (removeCodeTemplates.size() > 1) {
            this.error("Error removing code template by name, multiple found:", null);
            this.listCodeTemplates(removeCodeTemplates, false);
            return;
        }
        this.out.println("Removing code template \"" + ((CodeTemplate)removeCodeTemplates.get(0)).getName() + "\"...");
        this.client.removeCodeTemplate(((CodeTemplate)removeCodeTemplates.get(0)).getId());
        this.out.println("Successfully removed code template.");
    }

    private void commandImportMessages(Token[] arguments) {
        if (this.hasInvalidNumberOfArguments(arguments, 2)) {
            return;
        }
        String path = arguments[1].getText();
        final String channelId = arguments[2].getText();
        MessageWriter importer = new MessageWriter(){

            public boolean write(Message message) throws MessageWriterException {
                try {
                    CommandLineInterface.this.client.importMessage(channelId, message);
                }
                catch (ClientException e) {
                    throw new MessageWriterException((Throwable)e);
                }
                return true;
            }

            public void finishWrite() throws MessageWriterException {
            }

            public void close() throws MessageWriterException {
            }
        };
        try {
            MessageImportResult result = new MessageImporter().importMessages(path, Boolean.valueOf(true), importer, new File(".").getAbsolutePath());
            this.out.println(result.getSuccessCount() + " out of " + result.getTotalCount() + " messages imported successfully.");
        }
        catch (InterruptedException e) {
            this.error("Message import was interrupted.", null);
        }
        catch (MessageImporter.MessageImportException e) {
            this.error("An error occurred while attempting to import messages", e);
        }
        catch (MessageImporter.MessageImportInvalidPathException e) {
            this.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandExportMessages(Token[] arguments) {
        if (this.hasInvalidNumberOfArguments(arguments, 2)) {
            return;
        }
        String path = arguments[1].getText();
        File fXml = new File(path);
        MessageFilter filter = new MessageFilter();
        String channelId = arguments[2].getText();
        ContentType contentType = null;
        boolean includeAttachments = false;
        if (arguments.length >= 4) {
            String modeArg = arguments[3].getText();
            if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"raw")) {
                contentType = ContentType.RAW;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"processedraw")) {
                contentType = ContentType.PROCESSED_RAW;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"transformed")) {
                contentType = ContentType.TRANSFORMED;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"encoded")) {
                contentType = ContentType.ENCODED;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"sent")) {
                contentType = ContentType.SENT;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"response")) {
                contentType = ContentType.RESPONSE;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"responsetransformed")) {
                contentType = ContentType.RESPONSE_TRANSFORMED;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"processedresponse")) {
                contentType = ContentType.PROCESSED_RESPONSE;
            } else if (StringUtils.equals((CharSequence)modeArg, (CharSequence)"xml-attach")) {
                includeAttachments = true;
            }
        }
        int pageSize = 100;
        if (arguments.length == 5) {
            pageSize = NumberUtils.toInt((String)arguments[4].getText());
        }
        int messageCount = 0;
        try {
            Throwable cause;
            filter.setMaxMessageId(this.client.getMaxMessageId(channelId));
            MessageWriter messageWriter = null;
            try {
                this.out.println("Exporting messages to file: " + fXml.getPath());
                PaginatedMessageList messageList = new PaginatedMessageList();
                messageList.setChannelId(channelId);
                messageList.setClient(this.client);
                messageList.setIncludeContent(true);
                messageList.setMessageFilter(filter);
                messageList.setPageSize(pageSize);
                MessageWriterOptions writerOptions = new MessageWriterOptions();
                writerOptions.setBaseFolder(new File(".").getPath());
                writerOptions.setContentType(contentType);
                writerOptions.setDestinationContent(false);
                writerOptions.setEncrypt(false);
                writerOptions.setRootFolder(FilenameUtils.getFullPath((String)fXml.getAbsolutePath()));
                writerOptions.setFilePattern(FilenameUtils.getName((String)fXml.getAbsolutePath()));
                writerOptions.setArchiveFormat(null);
                writerOptions.setCompressFormat(null);
                writerOptions.setIncludeAttachments(includeAttachments);
                messageWriter = MessageWriterFactory.getInstance().getMessageWriter(writerOptions, this.client.getEncryptor());
                AttachmentSource attachmentSource = null;
                if (writerOptions.includeAttachments()) {
                    attachmentSource = new AttachmentSource(){

                        public List<Attachment> getMessageAttachments(Message message) throws ClientException {
                            return CommandLineInterface.this.client.getAttachmentsByMessageId(message.getChannelId(), message.getMessageId());
                        }
                    };
                }
                messageCount = new MessageExporter().exportMessages((PaginatedList)messageList, messageWriter, attachmentSource, writerOptions);
                messageWriter.finishWrite();
            }
            catch (Exception e) {
                cause = ExceptionUtils.getRootCause((Throwable)e);
                this.error("unable to write file(s) " + path + ": " + String.valueOf(cause), cause);
            }
            finally {
                if (messageWriter != null) {
                    try {
                        messageWriter.close();
                    }
                    catch (Exception e) {
                        cause = ExceptionUtils.getRootCause((Throwable)e);
                        this.error("unable to close file(s) " + path + ": " + String.valueOf(cause), cause);
                    }
                }
            }
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            this.error("Unable to retrieve max message ID: " + String.valueOf(cause), cause);
        }
        this.out.println("Messages Export Complete. " + messageCount + " Messages Exported.");
    }

    private void commandImportMap(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        File file = new File(path);
        if (file != null && file.exists()) {
            try {
                PropertiesConfiguration properties = PropertiesConfigurationUtil.create((File)file);
                HashMap<String, ConfigurationProperty> configurationMap = new HashMap<String, ConfigurationProperty>();
                Iterator iterator = properties.getKeys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = properties.getString(key);
                    String comment = properties.getLayout().getCanonicalComment(key, false);
                    configurationMap.put(key, new ConfigurationProperty(value, comment));
                }
                this.client.setConfigurationMap(configurationMap);
                this.out.println("Configuration map import complete");
            }
            catch (IOException | ConfigurationException e) {
                this.error("Unable to import configuration map", e);
            }
        } else {
            this.error("Unable to read file " + path, null);
        }
    }

    private void commandExportMap(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 1)) {
            return;
        }
        String path = arguments[1].getText();
        File file = new File(path);
        if (file != null) {
            try {
                PropertiesConfiguration properties = PropertiesConfigurationUtil.create((File)file);
                properties.clear();
                PropertiesConfigurationLayout layout = properties.getLayout();
                Map configurationMap = this.client.getConfigurationMap();
                TreeMap sortedMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                sortedMap.putAll(configurationMap);
                for (Map.Entry entry : sortedMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = ((ConfigurationProperty)entry.getValue()).getValue();
                    String comment = ((ConfigurationProperty)entry.getValue()).getComment();
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    properties.setProperty(key, (Object)value);
                    layout.setComment(key, StringUtils.isBlank((CharSequence)comment) ? null : comment);
                }
                PropertiesConfigurationUtil.saveTo((PropertiesConfiguration)properties, (File)file);
                this.out.println("Configuration map export complete.");
            }
            catch (IOException | ConfigurationException e) {
                this.error("Unable to export configuration map.", e);
            }
        }
    }

    private void commandStatus(Token[] arguments) throws ClientException {
        this.out.println("ID\t\t\t\t\tStatus\t\tName");
        List channels = this.client.getAllChannelStatuses();
        for (DashboardStatus channel : channels) {
            this.out.println(channel.getChannelId() + "\t" + channel.getState().toString() + "\t\t" + channel.getName());
        }
    }

    private void commandExport(Token[] arguments) throws ClientException {
        if (arguments.length < 3) {
            this.error("invalid number of arguments. Syntax is: export id|name|* \"path\"", null);
            return;
        }
        Token key = arguments[1];
        String path = arguments[2].getText();
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        List channels = this.client.getAllChannels();
        Set channelDependencies = this.client.getChannelDependencies();
        if (key == Token.WILDCARD) {
            for (Channel channel : channels) {
                try {
                    this.addDependenciesToChannel(channelDependencies, channel);
                    File fXml = new File(path + channel.getName() + ".xml");
                    this.out.println("Exporting " + channel.getName());
                    String channelXML = serializer.serialize((Object)channel);
                    FileUtils.writeStringToFile((File)fXml, (String)channelXML);
                }
                catch (IOException e) {
                    this.error("unable to write file " + path + ": " + String.valueOf(e), e);
                }
            }
            this.out.println("Export Complete.");
            return;
        }
        File fXml = new File(path);
        StringToken skey = Token.stringToken(key.getText());
        for (Channel channel : channels) {
            if (skey.equalsIgnoreCase(channel.getName()) == skey.equalsIgnoreCase(channel.getId())) continue;
            this.addDependenciesToChannel(channelDependencies, channel);
            this.out.println("Exporting " + channel.getName());
            String channelXML = serializer.serialize((Object)channel);
            try {
                FileUtils.writeStringToFile((File)fXml, (String)channelXML);
            }
            catch (IOException e) {
                this.error("unable to write file " + path + ": " + String.valueOf(e), e);
            }
            this.out.println("Export Complete.");
            return;
        }
    }

    private void addDependenciesToChannel(Set<ChannelDependency> channelDependencies, Channel channel) {
        HashSet<String> dependentIds = new HashSet<String>();
        HashSet<String> dependencyIds = new HashSet<String>();
        for (ChannelDependency channelDependency : channelDependencies) {
            if (StringUtils.equals((CharSequence)channelDependency.getDependencyId(), (CharSequence)channel.getId())) {
                dependentIds.add(channelDependency.getDependentId());
                continue;
            }
            if (!StringUtils.equals((CharSequence)channelDependency.getDependentId(), (CharSequence)channel.getId())) continue;
            dependencyIds.add(channelDependency.getDependencyId());
        }
        if (CollectionUtils.isNotEmpty(dependentIds)) {
            channel.getExportData().setDependentIds(dependentIds);
        }
        if (CollectionUtils.isNotEmpty(dependencyIds)) {
            channel.getExportData().setDependencyIds(dependencyIds);
        }
    }

    private void commandAllChannelStats(Token[] arguments) throws ClientException {
        this.out.println("Received\tFiltered\tQueued\t\tSent\t\tErrored\t\tName");
        List channelStatuses = this.client.getAllChannelStatuses();
        for (DashboardStatus channelStatus : channelStatuses) {
            ChannelStatistics stats = this.client.getStatistics(channelStatus.getChannelId());
            this.out.println(stats.getReceived() + "\t\t" + stats.getFiltered() + "\t\t" + channelStatus.getQueued() + "\t\t" + stats.getSent() + "\t\t" + stats.getError() + "\t\t" + channelStatus.getName());
        }
    }

    private void commandChannelList(Token[] arguments) throws ClientException {
        List allChannels = this.client.getAllChannels();
        Map metadataMap = this.client.getChannelMetadata();
        this.out.println("ID\t\t\t\t\tEnabled\t\tName");
        String enable = "";
        for (Channel channel : allChannels) {
            ChannelMetadata metadata = (ChannelMetadata)metadataMap.get(channel.getId());
            enable = !(channel instanceof InvalidChannel) && metadata != null && metadata.isEnabled() ? "YES" : "NO";
            this.out.println(channel.getId() + "\t" + enable + "\t\t" + channel.getName());
        }
    }

    private void commandChannelDisable(Token[] arguments) throws ClientException {
        Map metadataMap = this.client.getChannelMetadata();
        for (Channel channel : this.getMatchingChannels(arguments[2])) {
            ChannelMetadata metadata = (ChannelMetadata)metadataMap.get(channel.getId());
            if (metadata == null || !metadata.isEnabled()) continue;
            this.client.setChannelEnabled(channel.getId(), false);
            this.out.println("Channel '" + channel.getName() + "' Disabled");
        }
    }

    private void commandChannelEnable(Token[] arguments) throws ClientException {
        Map metadataMap = this.client.getChannelMetadata();
        for (Channel channel : this.getMatchingChannels(arguments[2])) {
            ChannelMetadata metadata = (ChannelMetadata)metadataMap.get(channel.getId());
            if (channel instanceof InvalidChannel || metadata != null && metadata.isEnabled()) continue;
            this.client.setChannelEnabled(channel.getId(), true);
            this.out.println("Channel '" + channel.getName() + "' Enabled");
        }
    }

    private void commandChannelRemove(Token[] arguments) throws ClientException {
        for (Channel channel : this.getMatchingChannels(arguments[2])) {
            this.client.removeChannel(channel.getId());
            this.out.println("Channel '" + channel.getName() + "' Removed");
        }
    }

    private void commandChannelStart(Token[] arguments) throws ClientException {
        for (DashboardStatus channel : this.getMatchingChannelStatuses(arguments[2])) {
            if (!channel.getState().equals((Object)DeployedState.PAUSED) && !channel.getState().equals((Object)DeployedState.STOPPED)) continue;
            if (channel.getState().equals((Object)DeployedState.PAUSED)) {
                this.client.resumeChannel(channel.getChannelId());
                this.out.println("Channel '" + channel.getName() + "' Resumed");
                continue;
            }
            this.client.startChannel(channel.getChannelId());
            this.out.println("Channel '" + channel.getName() + "' Started");
        }
    }

    private void commandChannelStop(Token[] arguments) throws ClientException {
        for (DashboardStatus channel : this.getMatchingChannelStatuses(arguments[2])) {
            if (!channel.getState().equals((Object)DeployedState.PAUSED) && !channel.getState().equals((Object)DeployedState.STARTED)) continue;
            this.client.stopChannel(channel.getChannelId());
            this.out.println("Channel '" + channel.getName() + "' Stopped");
        }
    }

    private void commandChannelHalt(Token[] arguments) throws ClientException {
        for (DashboardStatus channel : this.getMatchingChannelStatuses(arguments[2])) {
            this.client.haltChannel(channel.getChannelId());
            this.out.println("Channel '" + channel.getName() + "' Halted");
        }
    }

    private void commandChannelPause(Token[] arguments) throws ClientException {
        for (DashboardStatus channel : this.getMatchingChannelStatuses(arguments[2])) {
            if (!channel.getState().equals((Object)DeployedState.STARTED)) continue;
            this.client.pauseChannel(channel.getChannelId());
            this.out.println("Channel '" + channel.getName() + "' Paused");
        }
    }

    private void commandChannelResume(Token[] arguments) throws ClientException {
        for (DashboardStatus channel : this.getMatchingChannelStatuses(arguments[2])) {
            if (!channel.getState().equals((Object)DeployedState.PAUSED)) continue;
            this.client.resumeChannel(channel.getChannelId());
            this.out.println("Channel '" + channel.getName() + "' Resumed");
        }
    }

    private void commandChannelStats(Token[] arguments) throws ClientException {
        for (DashboardStatus channel : this.getMatchingChannelStatuses(arguments[2])) {
            ChannelStatistics stats = this.client.getStatistics(channel.getChannelId());
            this.out.println("Channel Stats for " + channel.getName());
            this.out.println("Received: " + stats.getReceived());
            this.out.println("Filtered: " + stats.getFiltered());
            this.out.println("Queued: " + channel.getQueued());
            this.out.println("Sent: " + stats.getSent());
            this.out.println("Errored: " + stats.getError());
        }
    }

    private void commandChannelRename(Token[] arguments) throws ClientException {
        for (Channel channel : this.getMatchingChannels(arguments[2])) {
            if (channel instanceof InvalidChannel) continue;
            String oldName = channel.getName();
            channel.setName(arguments[3].getText());
            if (!this.checkChannelName(channel.getName())) continue;
            this.client.updateChannel(channel, true, null);
            this.out.println("Channel '" + oldName + "' renamed to '" + channel.getName() + "'");
        }
    }

    private void commandChannelDeploy(Token[] arguments) throws ClientException {
        LinkedHashSet<String> channelIds = new LinkedHashSet<String>();
        for (Channel channel : this.getMatchingChannels(arguments[2])) {
            channelIds.add(channel.getId());
        }
        if (CollectionUtils.isNotEmpty(channelIds) || arguments[2] == Token.WILDCARD) {
            this.client.deployChannels(channelIds);
        } else {
            this.out.println("No channels matched ID or name \"" + arguments[2].getText() + "\".");
        }
    }

    private void commandChannelUndeploy(Token[] arguments) throws ClientException {
        LinkedHashSet<String> channelIds = new LinkedHashSet<String>();
        for (Channel channel : this.getMatchingChannels(arguments[2])) {
            channelIds.add(channel.getId());
        }
        if (CollectionUtils.isNotEmpty(channelIds) || arguments[2] == Token.WILDCARD) {
            this.client.undeployChannels(channelIds);
        } else {
            this.out.println("No channels matched ID or name \"" + arguments[2].getText() + "\".");
        }
    }

    public Channel getChannelById(String id) throws ClientException {
        for (Channel channel : this.client.getAllChannels()) {
            if (!channel.getId().equalsIgnoreCase(id)) continue;
            return channel;
        }
        return null;
    }

    public boolean checkChannelName(String name) throws ClientException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.out.println("Channel name cannot be empty.");
            return false;
        }
        if (name.length() > 40) {
            this.out.println("Channel name cannot be longer than 40 characters.");
            return false;
        }
        Pattern alphaNumericPattern = Pattern.compile("^[a-zA-Z_0-9\\-\\s]*$");
        Matcher matcher = alphaNumericPattern.matcher(name);
        if (!matcher.find()) {
            this.out.println("Channel name cannot have special characters besides hyphen, underscore, and space.");
            return false;
        }
        return this.getChannelByName(name) == null;
    }

    private Channel getChannelByName(String name) throws ClientException {
        for (Channel channel : this.client.getAllChannels()) {
            if (!channel.getName().equalsIgnoreCase(name)) continue;
            this.out.println("Channel \"" + name + "\" already exists.");
            return channel;
        }
        return null;
    }

    private List<Channel> getMatchingChannels(Token key) throws ClientException {
        ArrayList<Channel> result = new ArrayList<Channel>();
        for (Channel channel : this.client.getAllChannels()) {
            if (!this.matchesChannel(key, channel.getName(), channel.getId())) continue;
            result.add(channel);
        }
        return result;
    }

    private List<DashboardStatus> getMatchingChannelStatuses(Token key) throws ClientException {
        ArrayList<DashboardStatus> result = new ArrayList<DashboardStatus>();
        for (DashboardStatus status : this.client.getAllChannelStatuses()) {
            if (!this.matchesChannel(key, status.getName(), status.getChannelId())) continue;
            result.add(status);
        }
        return result;
    }

    private boolean matchesChannel(Token key, String name, String id) {
        if (key == Token.WILDCARD) {
            return true;
        }
        StringToken skey = (StringToken)key;
        return skey.equalsIgnoreCase(name) || skey.equalsIgnoreCase(id);
    }

    private void commandClearAllMessages(Token[] arguments) throws ClientException {
        HashSet<String> channelIds = new HashSet<String>();
        for (Channel channel : this.client.getAllChannels()) {
            channelIds.add(channel.getId());
        }
        this.client.removeAllMessages(channelIds, true, false);
    }

    private void commandResetstats(Token[] arguments) throws ClientException {
        boolean lifetime = false;
        if (arguments.length >= 2 && arguments[1] == Token.LIFETIME) {
            lifetime = true;
        }
        if (lifetime) {
            this.client.clearAllStatistics();
        } else {
            List channelStatuses = this.client.getAllChannelStatuses();
            HashMap<String, ArrayList<Integer>> channelConnectorMap = new HashMap<String, ArrayList<Integer>>();
            for (DashboardStatus status : channelStatuses) {
                String channelId = status.getChannelId();
                Integer metaDataId = status.getMetaDataId();
                ArrayList<Integer> metaDataIds = (ArrayList<Integer>)channelConnectorMap.get(channelId);
                if (metaDataIds == null) {
                    metaDataIds = new ArrayList<Integer>();
                    channelConnectorMap.put(channelId, metaDataIds);
                }
                metaDataIds.add(metaDataId);
                if (!CollectionUtils.isNotEmpty((Collection)status.getChildStatuses())) continue;
                for (DashboardStatus childStatus : status.getChildStatuses()) {
                    metaDataIds.add(childStatus.getMetaDataId());
                }
            }
            this.client.clearStatistics(channelConnectorMap, true, true, true, true);
        }
    }

    private void commandDumpEvents(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 2)) {
            return;
        }
        String dumpFilename = arguments[2].getText();
        dumpFilename = this.replaceValues(dumpFilename);
        StringBuilder builder = new StringBuilder();
        builder.append("BridgeLink Event Log Dump: " + new Date().toString() + "\n");
        builder.append(ServerEvent.getExportHeader() + "\n");
        File dumpFile = new File(dumpFilename);
        try {
            int maxEventId = this.client.getMaxEventId();
            EventFilter filter = new EventFilter();
            filter.setMaxEventId(Integer.valueOf(maxEventId));
            PaginatedEventList eventList = new PaginatedEventList();
            eventList.setClient(this.client);
            eventList.setPageSize(20);
            eventList.setEventFilter(filter);
            int pageNumber = 1;
            while (eventList.loadPageNumber(pageNumber)) {
                for (ServerEvent event : eventList) {
                    builder.append(event.toExportString() + "\n");
                }
                ++pageNumber;
            }
            FileUtils.writeStringToFile((File)dumpFile, (String)builder.toString());
        }
        catch (ListHandlerException lhe) {
            lhe.printStackTrace();
        }
        catch (IOException ioe) {
            this.error("Could not write file: " + dumpFile.getAbsolutePath(), ioe);
        }
        catch (Exception e) {
            this.error("Could not retrieve events", e);
            e.printStackTrace();
        }
        this.out.println("Events written to " + dumpFilename);
    }

    private void commandDumpStats(Token[] arguments) throws ClientException {
        if (this.hasInvalidNumberOfArguments(arguments, 2)) {
            return;
        }
        String dumpFilename = arguments[2].getText();
        dumpFilename = this.replaceValues(dumpFilename);
        StringBuilder builder = new StringBuilder();
        builder.append("BridgeLink Channel Statistics Dump: " + new Date().toString() + "\n");
        builder.append("Name, Received, Filtered, Queued, Sent, Errored\n");
        List channelStatuses = this.client.getAllChannelStatuses();
        for (DashboardStatus channelStatus : channelStatuses) {
            ChannelStatistics stats = this.client.getStatistics(channelStatus.getChannelId());
            builder.append(channelStatus.getName() + ", " + stats.getReceived() + ", " + stats.getFiltered() + ", " + channelStatus.getQueued() + ", " + stats.getSent() + ", " + stats.getError() + "\n");
        }
        File dumpFile = new File(dumpFilename);
        try {
            FileUtils.writeStringToFile((File)dumpFile, (String)builder.toString());
            this.out.println("Stats written to " + dumpFilename);
        }
        catch (IOException e) {
            this.error("Could not write file: " + dumpFile.getAbsolutePath(), e);
        }
    }

    private void doImportScript(File scriptFile) throws ClientException {
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        String scriptsXml = new String();
        try {
            scriptsXml = FileUtils.readFileToString((File)scriptFile);
        }
        catch (Exception e) {
            this.error("invalid script file.", e);
            return;
        }
        Map scriptsMap = (Map)serializer.deserialize(scriptsXml, Map.class);
        this.client.setGlobalScripts(scriptsMap);
    }

    private void doImportChannel(File importFile, boolean force) throws ClientException {
        Channel importChannel = null;
        try {
            String channelXML = FileUtils.readFileToString((File)importFile);
            importChannel = (Channel)ObjectXMLSerializer.getInstance().deserialize(channelXML, Channel.class);
        }
        catch (Exception e1) {
            this.error("invalid channel file.", e1);
            return;
        }
        String channelName = importChannel.getName();
        String channelId = importChannel.getId();
        String tempId = this.client.getGuid();
        importChannel.setRevision(0);
        Channel idChannelMatch = this.getChannelById(channelId);
        Channel nameChannelMatch = this.getChannelByName(channelName);
        if (idChannelMatch != null) {
            if (!force) {
                importChannel.setId(tempId);
            } else {
                importChannel.setRevision(idChannelMatch.getRevision().intValue());
            }
        }
        if (nameChannelMatch != null) {
            if (!force) {
                importChannel.setName(tempId);
            } else {
                importChannel.setRevision(nameChannelMatch.getRevision().intValue());
                importChannel.setId(nameChannelMatch.getId());
            }
        }
        this.importChannelDependencies(importChannel);
        this.client.updateChannel(importChannel, true, null);
        this.out.println("Channel '" + channelName + "' imported successfully.");
    }

    private void importChannelDependencies(Channel importChannel) throws ClientException {
        if (CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependentIds()) || CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependencyIds())) {
            Set cachedChannelDependencies = this.client.getChannelDependencies();
            HashSet<ChannelDependency> channelDependencies = new HashSet<ChannelDependency>(cachedChannelDependencies);
            if (CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependentIds())) {
                for (String dependentId : importChannel.getExportData().getDependentIds()) {
                    if (!StringUtils.isNotBlank((CharSequence)dependentId) || StringUtils.equals((CharSequence)dependentId, (CharSequence)importChannel.getId())) continue;
                    channelDependencies.add(new ChannelDependency(dependentId, importChannel.getId()));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependencyIds())) {
                for (String dependencyId : importChannel.getExportData().getDependencyIds()) {
                    if (!StringUtils.isNotBlank((CharSequence)dependencyId) || StringUtils.equals((CharSequence)dependencyId, (CharSequence)importChannel.getId())) continue;
                    channelDependencies.add(new ChannelDependency(importChannel.getId(), dependencyId));
                }
            }
            if (!channelDependencies.equals(cachedChannelDependencies)) {
                try {
                    this.client.setChannelDependencies(channelDependencies);
                }
                catch (ClientException e) {
                    this.error("Unable to save channel dependencies.", e);
                }
            }
            importChannel.getExportData().clearAllExceptMetadata();
        }
    }

    private void doImportAlert(File importFile, boolean force) throws ClientException {
        List alertList;
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        try {
            alertList = serializer.deserializeList(FileUtils.readFileToString((File)importFile).replaceAll("\\&\\#x0D;\\n", "\n").replaceAll("\\&\\#x0D;", "\n"), AlertModel.class);
        }
        catch (Exception e) {
            this.error("invalid alert file.", e);
            return;
        }
        this.removeInvalidItems(alertList, AlertModel.class);
        for (AlertModel importAlert : alertList) {
            String alertName = importAlert.getName();
            String tempId = this.client.getGuid();
            if (!this.checkAlertName(alertName)) {
                if (!force) {
                    importAlert.setName(tempId);
                    importAlert.setId(tempId);
                } else {
                    for (AlertModel alert : this.client.getAllAlerts()) {
                        if (!alert.getName().equalsIgnoreCase(alertName)) continue;
                        importAlert.setId(alert.getId());
                    }
                }
            }
            this.client.updateAlert(importAlert);
            this.out.println("Alert '" + alertName + "' imported successfully.");
        }
    }

    private boolean checkAlertName(String name) throws ClientException {
        if (name.equals("")) {
            this.out.println("Alert name cannot be empty.");
            return false;
        }
        Pattern alphaNumericPattern = Pattern.compile("^[a-zA-Z_0-9\\-\\s]*$");
        Matcher matcher = alphaNumericPattern.matcher(name);
        if (!matcher.find()) {
            this.out.println("Alert name cannot have special characters besides hyphen, underscore, and space.");
            return false;
        }
        for (AlertModel alert : this.client.getAllAlerts()) {
            if (!alert.getName().equalsIgnoreCase(name)) continue;
            this.out.println("Alert \"" + name + "\" already exists.");
            return false;
        }
        return true;
    }

    private String replaceValues(String source) {
        source = source.replaceAll("\\$\\{date\\}", this.getTimeStamp());
        return source;
    }

    private String getTimeStamp() {
        Date currentTime = new Date();
        return this.formatter.format(currentTime);
    }

    private void removeInvalidItems(List<?> list, Class<?> expectedClass) {
        int originalSize = list.size();
        for (int i = 0; i < list.size(); ++i) {
            if (expectedClass.isInstance(list.get(i))) continue;
            list.remove(i--);
        }
        if (list.size() < originalSize) {
            if (list.size() == 0) {
                this.out.println("The imported object(s) are not of the expected class: " + expectedClass.getSimpleName());
            } else {
                this.out.println("One or more imported objects were skipped, because they are not of the expected class: " + expectedClass.getSimpleName());
            }
        }
    }
}

