/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.connectors.file.FileConnector;
import com.mirth.connect.connectors.file.FileConnectorServletInterface;
import com.mirth.connect.connectors.file.FileDispatcherProperties;
import com.mirth.connect.connectors.file.FileReceiverProperties;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnectionFactory;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ConnectionTestResponse;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

public class FileConnectorServlet
extends MirthServlet
implements FileConnectorServletInterface {
    protected static final TemplateValueReplacer replacer = new TemplateValueReplacer();

    public FileConnectorServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "File Connector Service");
    }

    public ConnectionTestResponse testRead(String channelId, String channelName, FileReceiverProperties properties) {
        return this.testReadOrWrite(channelId, channelName, (ConnectorProperties)properties, properties.getHost(), properties.isAnonymous(), properties.getUsername(), properties.getPassword(), properties.getSchemeProperties(), properties.getScheme(), properties.getTimeout(), properties.isSecure(), properties.isPassive(), true);
    }

    public ConnectionTestResponse testWrite(String channelId, String channelName, FileDispatcherProperties properties) {
        return this.testReadOrWrite(channelId, channelName, (ConnectorProperties)properties, properties.getHost(), properties.isAnonymous(), properties.getUsername(), properties.getPassword(), properties.getSchemeProperties(), properties.getScheme(), properties.getTimeout(), properties.isSecure(), properties.isPassive(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConnectionTestResponse testReadOrWrite(String channelId, String channelName, ConnectorProperties connectorProperties, String host, boolean anonymous, String username, String password, SchemeProperties schemeProperties, FileScheme scheme, String timeoutString, boolean secure, boolean passive, boolean read) {
        try {
            host = replacer.replaceValues(host, channelId, channelName);
            username = replacer.replaceValues(username, channelId, channelName);
            password = replacer.replaceValues(password, channelId, channelName);
            if (schemeProperties instanceof SftpSchemeProperties) {
                SftpSchemeProperties sftpProperties = (SftpSchemeProperties)schemeProperties;
                sftpProperties.setKeyFile(replacer.replaceValues(sftpProperties.getKeyFile(), channelId, channelName));
                sftpProperties.setPassPhrase(replacer.replaceValues(sftpProperties.getPassPhrase(), channelId, channelName));
                sftpProperties.setKnownHostsFile(replacer.replaceValues(sftpProperties.getKnownHostsFile(), channelId, channelName));
                sftpProperties.setConfigurationSettings(replacer.replaceValues(sftpProperties.getConfigurationSettings(), channelId, channelName));
            } else if (schemeProperties instanceof S3SchemeProperties) {
                S3SchemeProperties s3Properties = (S3SchemeProperties)schemeProperties;
                s3Properties.setCustomHeaders(replacer.replaceKeysAndValuesInMap(s3Properties.getCustomHeaders(), channelId, channelName));
            }
            int timeout = Integer.parseInt(timeoutString);
            FileConnector fileConnector = new FileConnector(channelId, connectorProperties, null);
            URI address = fileConnector.getEndpointURI(host, scheme, schemeProperties, secure);
            String addressHost = address.getHost();
            int port = address.getPort();
            String dir = address.getPath();
            Object hostDisplayName = "";
            if (!scheme.equals((Object)FileScheme.FILE)) {
                hostDisplayName = scheme.getDisplayName() + "://" + address.getHost();
            }
            hostDisplayName = (String)hostDisplayName + dir;
            FileSystemConnectionFactory factory = new FileSystemConnectionFactory(scheme, new FileSystemConnectionOptions(anonymous, username, password, schemeProperties), addressHost, port, passive, secure, timeout);
            FileSystemConnection connection = null;
            try {
                connection = (FileSystemConnection)factory.makeObject().getObject();
                if (read && connection.canRead(dir) || !read && connection.canWrite(dir)) {
                    ConnectionTestResponse connectionTestResponse = new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Successfully connected to: " + (String)hostDisplayName);
                    return connectionTestResponse;
                }
                ConnectionTestResponse connectionTestResponse = new ConnectionTestResponse(ConnectionTestResponse.Type.FAILURE, "Unable to connect to: " + (String)hostDisplayName);
                return connectionTestResponse;
            }
            catch (Exception e) {
                ConnectionTestResponse connectionTestResponse2 = new ConnectionTestResponse(ConnectionTestResponse.Type.FAILURE, "Unable to connect to: " + (String)hostDisplayName + ", Reason: " + e.getMessage());
                return connectionTestResponse2;
            }
            finally {
                if (connection != null) {
                    connection.destroy();
                }
            }
        }
        catch (Exception e2) {
            throw new MirthApiException((Throwable)e2);
        }
    }
}

