/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.mirth.connect.connectors.file.FTPSchemeProperties;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filesystems.HaltableFTPClient;
import com.mirth.connect.connectors.file.filters.RegexFilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpConnection
implements FileSystemConnection {
    private static transient Log logger = LogFactory.getLog(FtpConnection.class);
    protected FTPClient client = null;

    public FtpConnection(String host, int port, FileSystemConnectionOptions fileSystemOptions, boolean passive, int timeout) throws Exception {
        this(host, port, fileSystemOptions, passive, timeout, new HaltableFTPClient());
    }

    public FtpConnection(String host, int port, FileSystemConnectionOptions fileSystemOptions, boolean passive, int timeout, FTPClient client) throws Exception {
        this.client = client;
        client.setDataTimeout(timeout);
        client.setConnectTimeout(timeout);
        try {
            if (port > 0) {
                client.connect(host, port);
            } else {
                client.connect(host);
            }
            client.setSoTimeout(timeout);
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IOException("Ftp error: " + client.getReplyCode());
            }
            if (!client.login(fileSystemOptions.getUsername(), fileSystemOptions.getPassword())) {
                throw new IOException("Ftp error: " + client.getReplyCode());
            }
            if (!client.setFileType(2)) {
                throw new IOException("Ftp error");
            }
            this.initialize((FTPSchemeProperties)fileSystemOptions.getSchemeProperties());
            if (passive) {
                client.enterLocalPassiveMode();
            }
        }
        catch (Exception e) {
            if (client.isConnected()) {
                client.disconnect();
            }
            throw e;
        }
    }

    protected void initialize(FTPSchemeProperties schemeProperties) throws Exception {
        List commands;
        if (schemeProperties != null && CollectionUtils.isNotEmpty((Collection)(commands = schemeProperties.getInitialCommands()))) {
            for (String command : commands) {
                int result = this.client.sendCommand(command);
                if (FTPReply.isPositiveCompletion((int)result)) continue;
                logger.error((Object)("failed to issue command " + command + " with result " + this.client.getReplyString()));
            }
        }
    }

    @Override
    public List<FileInfo> listFiles(String fromDir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        RegexFilenameFilter filenameFilter = isRegex ? new RegexFilenameFilter(filenamePattern) : new WildcardFileFilter(filenamePattern.trim().split("\\s*,\\s*"));
        if (!this.cwd(fromDir)) {
            logger.error((Object)("listFiles.changeWorkingDirectory: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
        FTPFile[] files = this.client.listFiles();
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            logger.error((Object)("listFiles.listFiles: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
        if (files == null || files.length == 0) {
            return new ArrayList<FileInfo>();
        }
        ArrayList<FileInfo> v = new ArrayList<FileInfo>(files.length);
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || !files[i].isFile() || filenameFilter != null && !filenameFilter.accept(null, files[i].getName()) || ignoreDot && files[i].getName().startsWith(".")) continue;
            v.add(new FtpFileInfo(fromDir, files[i]));
        }
        return v;
    }

    @Override
    public List<String> listDirectories(String fromDir) throws Exception {
        ArrayList<String> directories = new ArrayList<String>();
        if (!this.cwd(fromDir)) {
            logger.error((Object)("listFiles.changeWorkingDirectory: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
        FTPFile[] ftpDirectories = this.client.listDirectories();
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            logger.error((Object)("listFiles.listFiles: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
        for (FTPFile directory : ftpDirectories) {
            if (directory == null) continue;
            directories.add(new FtpFileInfo(fromDir, directory).getAbsolutePath());
        }
        return directories;
    }

    @Override
    public boolean exists(String file, String path) {
        try {
            FTPFile[] files = this.client.listFiles(path + "/" + file);
            return files != null && files.length == 1;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canRead(String readDir) {
        try {
            return this.cwd(readDir);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite(String writeDir) {
        try {
            return this.cwd(writeDir);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean cwd(String destDir) throws IOException {
        return this.client.changeWorkingDirectory(destDir);
    }

    @Override
    public InputStream readFile(String file, String fromDir, Map<String, Object> sourceMap) throws Exception {
        if (!this.cwd(fromDir)) {
            logger.error((Object)("readFile.changeWorkingDirectory: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
        return this.client.retrieveFileStream(file);
    }

    @Override
    public void closeReadFile() throws Exception {
        if (!this.client.completePendingCommand()) {
            logger.error((Object)("closeReadFile.completePendingCommand: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
    }

    @Override
    public boolean canAppend() {
        return true;
    }

    @Override
    public void writeFile(String file, String toDir, boolean append, InputStream is, long contentLength, Map<String, Object> connectorMap) throws Exception {
        this.cdmake(toDir);
        if (append) {
            this.client.appendFile(file, is);
        } else {
            this.client.storeFile(file, is);
        }
        is.close();
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            logger.error((Object)("writeFile: " + this.client.getReplyString()));
            throw new IOException(this.client.getReplyString());
        }
    }

    @Override
    public void delete(String file, String fromDir, boolean mayNotExist) throws Exception {
        if (!this.cwd(fromDir)) {
            if (!mayNotExist) {
                logger.error((Object)("delete.changeWorkingDirectory: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
                throw new IOException("Ftp error: " + this.client.getReplyCode());
            }
            return;
        }
        boolean deleteSucceeded = this.client.deleteFile(file);
        if (!deleteSucceeded && !mayNotExist) {
            logger.error((Object)("delete.deleteFile: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
    }

    private void cdmake(String dir) throws Exception {
        if (!this.cwd(dir)) {
            if (!this.client.makeDirectory(dir)) {
                String[] dirs;
                String tempDir = dir;
                if (tempDir.startsWith("/")) {
                    tempDir = tempDir.substring(1);
                    if (!this.client.changeWorkingDirectory("/")) {
                        throw new Exception("Unable to change to destination directory: /");
                    }
                }
                if ((dirs = tempDir.split("/")).length > 0) {
                    for (int i = 0; i < dirs.length; ++i) {
                        if (this.client.changeWorkingDirectory(dirs[i])) continue;
                        logger.debug((Object)("Making directory: " + dirs[i]));
                        if (!this.client.makeDirectory(dirs[i])) {
                            throw new Exception("Unable to make destination directory: " + dirs[i]);
                        }
                        if (this.client.changeWorkingDirectory(dirs[i])) continue;
                        throw new Exception("Unable to change to destination directory: " + dirs[i]);
                    }
                }
            } else if (!this.cwd(dir)) {
                throw new Exception("Unable to change to destination directory: " + dir);
            }
        }
    }

    @Override
    public void move(String fromName, String fromDir, String toName, String toDir) throws Exception {
        this.cwd(fromDir);
        this.cdmake(toDir);
        try {
            this.client.deleteFile(toName);
        }
        catch (Exception e) {
            logger.info((Object)"Unable to delete destination file");
        }
        if (!this.cwd(fromDir)) {
            throw new Exception("Unable to change to directory: " + fromDir.substring(1) + "/");
        }
        boolean renameSucceeded = this.client.rename(fromName.replaceAll("//", "/"), (toDir + "/" + toName).replaceAll("//", "/"));
        if (!renameSucceeded) {
            logger.error((Object)("move.rename: " + this.client.getReplyCode() + "-" + this.client.getReplyString()));
            throw new IOException("Ftp error: " + this.client.getReplyCode());
        }
    }

    @Override
    public boolean isConnected() {
        if (this.client != null) {
            return this.client.isConnected();
        }
        return false;
    }

    @Override
    public void disconnect() {
        if (this.client instanceof HaltableFTPClient) {
            ((HaltableFTPClient)this.client).closeDataSockets();
        }
        try {
            this.client.disconnect();
        }
        catch (IOException e) {
            logger.debug((Object)e);
        }
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
    }

    @Override
    public void destroy() {
        try {
            this.client.logout();
            this.client.disconnect();
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.client.sendNoOp();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public class FtpFileInfo
    implements FileInfo {
        String thePath;
        FTPFile theFile;

        public FtpFileInfo(String path, FTPFile theFile) {
            this.thePath = path;
            this.theFile = theFile;
        }

        @Override
        public long getLastModified() {
            return this.theFile.getTimestamp().getTimeInMillis();
        }

        @Override
        public String getName() {
            return this.theFile.getName();
        }

        @Override
        public String getAbsolutePath() {
            return this.getParent() + "/" + this.getName();
        }

        @Override
        public String getCanonicalPath() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParent() {
            return this.thePath;
        }

        @Override
        public long getSize() {
            return this.theFile.getSize();
        }

        @Override
        public boolean isDirectory() {
            return this.theFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.theFile.isFile();
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public void populateSourceMap(Map<String, Object> sourceMap) {
        }
    }
}

