/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.pdfviewer;

import com.sun.pdfview.PDFViewer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MirthPDFViewer
extends PDFViewer {
    public static final String TITLE = "BridgeLink PDF Viewer";
    private File tempFile;

    public MirthPDFViewer(boolean useThumbs) {
        super(useThumbs);
    }

    public MirthPDFViewer(boolean useThumbs, File tempFile) throws IOException {
        super(useThumbs);
        super.openFile(tempFile);
        this.tempFile = tempFile;
    }

    public void doQuit() {
        super.doClose();
        super.dispose();
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    public Icon getIcon(String name) {
        ImageIcon icon = null;
        URL url = null;
        try {
            url = PDFViewer.class.getResource(name);
            icon = new ImageIcon(url);
            if (icon == null) {
                System.out.println("Couldn't find " + String.valueOf(url));
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't find " + ((Object)((Object)this)).getClass().getName() + "/" + name);
            e.printStackTrace();
        }
        return icon;
    }

    public void setTitle(String title) {
        Object newTitle = TITLE;
        int index = title.indexOf(":");
        if (index != -1) {
            newTitle = (String)newTitle + title.substring(index);
        }
        super.setTitle((String)newTitle);
    }
}

