/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.event.EventType;
import com.mirth.connect.model.Connector;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import com.mirth.connect.plugins.dashboardstatus.ConnectionStateItem;
import com.mirth.connect.plugins.dashboardstatus.DefaultConnectionLogController;
import com.mirth.connect.server.ExtensionLoader;
import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ConnectionStatusLogController {
    private static ConnectionStatusLogController instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionStatusLogController getInstance() {
        Class<DefaultConnectionLogController> clazz = DefaultConnectionLogController.class;
        synchronized (DefaultConnectionLogController.class) {
            if (instance == null && (instance = (ConnectionStatusLogController)ExtensionLoader.getInstance().getControllerInstance(ConnectionStatusLogController.class)) == null) {
                instance = new DefaultConnectionLogController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public abstract void processEvent(Event var1);

    public abstract LinkedList<ConnectionLogItem> getChannelLog(String var1, String var2, int var3, Long var4);

    public abstract Map<String, Object[]> getConnectorStateMap(String var1);

    public abstract Map<String, Map<String, List<ConnectionStateItem>>> getConnectionStatesForServer(String var1);

    public Set<EventType> getEventTypes() {
        HashSet<EventType> EventTypes = new HashSet<EventType>();
        EventTypes.add(EventType.CONNECTION_STATUS);
        return EventTypes;
    }

    public Connector getConnectorFromMetaDataId(List<Connector> connectors, int metaDataId) {
        for (Connector connector : connectors) {
            if (connector.getMetaDataId() != metaDataId) continue;
            return connector;
        }
        return null;
    }

    public Color getColor(ConnectionStatusEventType type) {
        switch (type) {
            case IDLE: 
            case CONNECTING: 
            case WAITING_FOR_RESPONSE: {
                return Color.yellow;
            }
            case WRITING: 
            case SENDING: 
            case READING: 
            case RECEIVING: 
            case POLLING: 
            case CONNECTED: {
                return Color.green;
            }
            case DISCONNECTED: {
                return Color.red;
            }
            case INFO: {
                return Color.blue;
            }
        }
        return Color.black;
    }
}

