/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ConnectorCountEvent;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import com.mirth.connect.plugins.dashboardstatus.ConnectionStateItem;
import com.mirth.connect.plugins.dashboardstatus.ConnectionStatusLogController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConnectionLogController
extends ConnectionStatusLogController {
    private Logger logger = LogManager.getLogger(this.getClass());
    private static final int MAX_LOG_SIZE = 1000;
    private static long logId = 1L;
    private Map<String, Object[]> connectorStateMap = new ConcurrentHashMap<String, Object[]>();
    private Map<String, ConnectionStatusEventType> connectorStateTypeMap = new ConcurrentHashMap<String, ConnectionStatusEventType>();
    private Map<String, AtomicInteger> connectorCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, Integer> maxConnectionMap = new ConcurrentHashMap<String, Integer>();
    private Map<String, LinkedList<ConnectionLogItem>> connectorInfoLogs = new ConcurrentHashMap<String, LinkedList<ConnectionLogItem>>();
    private LinkedList<ConnectionLogItem> entireConnectorInfoLogs = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(Event event) {
        if (event instanceof ConnectionStatusEvent) {
            ConnectionStatusEvent connectionStatusEvent = (ConnectionStatusEvent)event;
            String channelId = connectionStatusEvent.getChannelId();
            Integer metaDataId = connectionStatusEvent.getMetaDataId();
            String information = connectionStatusEvent.getMessage();
            Timestamp timestamp = new Timestamp(event.getDateTime());
            String connectorId = channelId + "_" + metaDataId;
            ConnectionStatusEventType eventType = connectionStatusEvent.getState();
            Integer connectorCount = null;
            Integer maximum = null;
            if (event instanceof ConnectorCountEvent) {
                ConnectorCountEvent connectorCountEvent = (ConnectorCountEvent)connectionStatusEvent;
                maximum = connectorCountEvent.getMaximum();
                Boolean increment = connectorCountEvent.isIncrement();
                if (maximum != null) {
                    this.maxConnectionMap.put(connectorId, maximum);
                } else {
                    maximum = this.maxConnectionMap.get(connectorId);
                }
                AtomicInteger count = this.connectorCountMap.get(connectorId);
                if (count == null) {
                    count = new AtomicInteger();
                    this.connectorCountMap.put(connectorId, count);
                }
                if (increment != null) {
                    if (increment.booleanValue()) {
                        count.incrementAndGet();
                    } else {
                        count.decrementAndGet();
                    }
                }
                eventType = (connectorCount = Integer.valueOf(count.get())) == 0 ? ConnectionStatusEventType.IDLE : ConnectionStatusEventType.CONNECTED;
            }
            Object stateString = null;
            if (eventType.isState()) {
                Color color = this.getColor(eventType);
                stateString = eventType.toString();
                if (connectorCount != null) {
                    if (maximum != null && connectorCount.equals(maximum)) {
                        stateString = (String)stateString + " <font color='red'>(" + connectorCount + ")</font>";
                    } else if (connectorCount > 0) {
                        stateString = (String)stateString + " (" + connectorCount + ")";
                    }
                }
                this.connectorStateMap.put(connectorId, new Object[]{color, stateString});
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String channelName = "";
            Object connectorType = "";
            LinkedList<Object> channelLog = null;
            Channel channel = ControllerFactory.getFactory().createChannelController().getDeployedChannelById(channelId);
            if (channel != null) {
                channelName = channel.getName();
                channelLog = this.connectorInfoLogs.containsKey(channelId) ? this.connectorInfoLogs.get(channelId) : new LinkedList();
                if (metaDataId == 0) {
                    connectorType = "Source: " + channel.getSourceConnector().getTransportName() + "  (" + channel.getSourceConnector().getTransformer().getInboundDataType().toString() + " -> " + channel.getSourceConnector().getTransformer().getOutboundDataType().toString() + ")";
                } else {
                    Connector connector = this.getConnectorFromMetaDataId(channel.getDestinationConnectors(), metaDataId);
                    connectorType = "Destination: " + connector.getTransportName() + " - " + connector.getName();
                }
            }
            if (channelLog != null) {
                DefaultConnectionLogController defaultConnectionLogController = this;
                synchronized (defaultConnectionLogController) {
                    if (channelLog.size() == 1000) {
                        channelLog.removeLast();
                    }
                    ConnectionLogItem connectionLogItem = new ConnectionLogItem(Long.valueOf(logId), null, channelId, Long.valueOf(metaDataId.longValue()), dateFormat.format(timestamp), channelName, (String)connectorType, ((ConnectionStatusEvent)event).getState().toString(), information);
                    channelLog.addFirst(connectionLogItem);
                    if (this.entireConnectorInfoLogs.size() == 1000) {
                        this.entireConnectorInfoLogs.removeLast();
                    }
                    this.entireConnectorInfoLogs.addFirst(connectionLogItem);
                    ++logId;
                    this.connectorInfoLogs.put(channelId, channelLog);
                }
            }
            if (eventType.isState()) {
                this.connectorStateTypeMap.put(connectorId, eventType);
            }
        }
    }

    @Override
    public synchronized LinkedList<ConnectionLogItem> getChannelLog(String serverId, String channelId, int fetchSize, Long lastLogId) {
        LinkedList<Object> channelLog;
        if (channelId == null) {
            channelId = "No Channel Selected";
            channelLog = this.entireConnectorInfoLogs;
        } else {
            channelLog = this.connectorInfoLogs.get(channelId);
            if (channelLog == null) {
                channelLog = new LinkedList();
                this.connectorInfoLogs.put(channelId, channelLog);
            }
        }
        if (lastLogId != null) {
            LinkedList<ConnectionLogItem> newChannelLogEntries = new LinkedList<ConnectionLogItem>();
            for (ConnectionLogItem connectionLogItem : channelLog) {
                if (lastLogId >= connectionLogItem.getLogId()) continue;
                newChannelLogEntries.addLast(connectionLogItem);
            }
            try {
                return (LinkedList)SerializationUtils.clone(newChannelLogEntries);
            }
            catch (SerializationException e) {
                this.logger.error((Object)e);
            }
        } else {
            try {
                return (LinkedList)SerializationUtils.clone(channelLog);
            }
            catch (SerializationException e) {
                this.logger.error((Object)e);
            }
        }
        return null;
    }

    @Override
    public Map<String, Object[]> getConnectorStateMap(String serverId) {
        return new HashMap<String, Object[]>(this.connectorStateMap);
    }

    @Override
    public Map<String, Map<String, List<ConnectionStateItem>>> getConnectionStatesForServer(String serverId) {
        String thisServerId = ConfigurationController.getInstance().getServerId();
        HashMap buildMap = new HashMap();
        for (String connectorId : this.connectorStateMap.keySet()) {
            String channelId = connectorId.substring(0, connectorId.lastIndexOf(95));
            String metadataId = connectorId.substring(connectorId.lastIndexOf(95) + 1);
            int connectorCount = this.connectorCountMap.get(connectorId).get();
            ConnectionStateItem stateItem = new ConnectionStateItem(thisServerId, channelId, metadataId, this.connectorStateTypeMap.get(connectorId), connectorCount, this.maxConnectionMap.get(connectorId));
            if (buildMap.containsKey(channelId)) {
                ((List)buildMap.get(channelId)).add(stateItem);
                continue;
            }
            ArrayList<ConnectionStateItem> list = new ArrayList<ConnectionStateItem>();
            list.add(stateItem);
            buildMap.put(channelId, list);
        }
        HashMap<String, Map<String, List<ConnectionStateItem>>> toReturn = new HashMap<String, Map<String, List<ConnectionStateItem>>>();
        toReturn.put(thisServerId, buildMap);
        return toReturn;
    }
}

