/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.ChannelGroup;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/channelgroups")
@Tag(name="Channel Groups")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface ChannelGroupServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/")
    @Operation(summary="Retrieve a list of all channel groups, or multiple channel groups by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_group_list", ref="../apiexamples/channel_group_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_group_list", ref="../apiexamples/channel_group_list_json")})})
    @MirthOperation(name="getChannelGroups", display="Get channel groups", permission="viewChannelGroups", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<ChannelGroup> getChannelGroups(@Param(value="channelGroupIds") @Parameter(description="The IDs of the channel groups to retrieve. If absent, all groups will be retrieved.") @QueryParam(value="channelGroupId") Set<String> var1) throws ClientException;

    @POST
    @Path(value="/_getChannelGroups")
    @Operation(summary="Retrieve a list of all channel groups, or multiple channel groups by ID. This is a POST request alternative to GET /channelgroups that may be used when there are too many channel group IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_group_list", ref="../apiexamples/channel_group_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_group_list", ref="../apiexamples/channel_group_list_json")})})
    @MirthOperation(name="getChannelGroups", display="Get channel groups", permission="viewChannelGroups", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<ChannelGroup> getChannelGroupsPost(@Param(value="channelGroupIds") @RequestBody(description="The IDs of the channel groups to retrieve. If absent, all groups will be retrieved.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="group_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="group_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1) throws ClientException;

    @POST
    @Path(value="/_bulkUpdate")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "text/plain"})
    @Operation(summary="Updates all channel groups in one request. (\"Try it out\" doesn't work for this endpoint, but the descriptions are valid. Please use another tool for testing.)")
    @MirthOperation(name="updateChannelGroups", display="Update channel groups", permission="manageChannels")
    public boolean updateChannelGroups(@Param(value="channelGroups") @Parameter(description="The channel group object to update or create.") @Schema(description="The channel group object to update or create.", type="object") @FormDataParam(value="channelGroups") Set<ChannelGroup> var1, @Param(value="removedChannelGroupIds") @Parameter(description="All channel group IDs known to be removed.") @Schema(description="All channel group IDs known to be removed.", type="object") @FormDataParam(value="removedChannelGroupIds") Set<String> var2, @Param(value="override") @Parameter(description="If true, the channel groups will be updated even if different revisions exist on the server.", schema=@Schema(defaultValue="false")) @QueryParam(value="override") boolean var3) throws ClientException;
}

