/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.DashboardChannelInfo;
import com.mirth.connect.model.DashboardStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/channels")
@Tag(name="Channel Status Operations")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface ChannelStatusServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/{channelId}/status")
    @Operation(summary="Returns the dashboard status for a single channel ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dashboard_status", ref="../apiexamples/dashboard_status_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dashboard_status", ref="../apiexamples/dashboard_status_json")})})
    @MirthOperation(name="getChannelStatus", display="Get status for single channel", permission="viewDashboard", type=Operation.ExecuteType.ASYNC, auditable=false)
    public DashboardStatus getChannelStatus(@Param(value="channelId") @Parameter(description="The channel ID to return a dashboard status for.") @PathParam(value="channelId") String var1) throws ClientException;

    @GET
    @Path(value="/statuses")
    @Operation(summary="Returns all channel dashboard statuses, or multiple statuses by channel ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dashboard_status_list", ref="../apiexamples/dashboard_status_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dashboard_status_list", ref="../apiexamples/dashboard_status_list_json")})})
    @MirthOperation(name="getChannelStatusList", display="Get status list for specific channels", permission="viewDashboard", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<DashboardStatus> getChannelStatusList(@Param(value="channelIds") @Parameter(description="The channel IDs to return dashboard statuses for. If absent, all statuses will be returned.") @QueryParam(value="channelId") Set<String> var1, @Param(value="filter") @Parameter(description="The filter string to limit dashboard statuses with.") @QueryParam(value="filter") String var2, @Param(value="includeUndeployed") @Parameter(description="If true, statuses for undeployed channels will also be included.") @QueryParam(value="includeUndeployed") boolean var3) throws ClientException;

    @POST
    @Path(value="/statuses/_getChannelStatusList")
    @Operation(summary="Returns all channel dashboard statuses, or multiple statuses by channel ID. This is a POST request alternative to GET /statuses that may be used when there are too many channel IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dashboard_status_list", ref="../apiexamples/dashboard_status_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dashboard_status_list", ref="../apiexamples/dashboard_status_list_json")})})
    @MirthOperation(name="getChannelStatusList", display="Get status list for specific channels", permission="viewDashboard", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<DashboardStatus> getChannelStatusListPost(@Param(value="channelIds") @RequestBody(description="The channel IDs to return dashboard statuses for. If absent, all statuses will be returned.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="filter") @Parameter(description="The filter string to limit dashboard statuses with.") @QueryParam(value="filter") String var2, @Param(value="includeUndeployed") @Parameter(description="If true, statuses for undeployed channels will also be included.") @QueryParam(value="includeUndeployed") boolean var3) throws ClientException;

    @GET
    @Path(value="/statuses/initial")
    @Operation(summary="Returns a DashboardChannelInfo object containing a partial channel status list and a set of remaining channel IDs.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dashboard_channel_info", ref="../apiexamples/dashboard_channel_info_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dashboard_channel_info", ref="../apiexamples/dashboard_channel_info_json")})})
    @MirthOperation(name="getChannelStatusListInitial", display="Get initial channel status list", permission="viewDashboard", type=Operation.ExecuteType.ASYNC, auditable=false)
    public DashboardChannelInfo getDashboardChannelInfo(@Param(value="fetchSize") @Parameter(description="Specifies the maximum number of statuses to return.", required=true, schema=@Schema(defaultValue="100")) @QueryParam(value="fetchSize") int var1, @Param(value="filter") @Parameter(description="The filter string to limit dashboard statuses with.") @QueryParam(value="filter") String var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/_start")
    @Operation(summary="Starts the channel with the specified ID.")
    @MirthOperation(name="startChannels", display="Start channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void startChannel(@Param(value="channelId") @Parameter(description="The channel ID to start.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/_start")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Starts the channels with the specified IDs. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="startChannels", display="Start channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void startChannels(@Param(value="channelIds") @Parameter(description="The channel IDs to start.", required=true) @FormParam(value="channelId") Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/_stop")
    @Operation(summary="Stops the channel with the specified ID.")
    @MirthOperation(name="stopChannels", display="Stop channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void stopChannel(@Param(value="channelId") @Parameter(description="The channel ID to stop.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/_stop")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Stops the channels with the specified IDs. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="stopChannels", display="Stop channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void stopChannels(@Param(value="channelIds") @Parameter(description="The channel IDs to stop.", required=true) @FormParam(value="channelId") Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/_halt")
    @Operation(summary="Halts the channel with the specified ID.")
    @MirthOperation(name="haltChannels", display="Halt channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void haltChannel(@Param(value="channelId") @Parameter(description="The channel ID to halt.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/_halt")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Halts the channels with the specified IDs. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="haltChannels", display="Halt channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void haltChannels(@Param(value="channelIds") @Parameter(description="The channel IDs to halt.", required=true) @FormParam(value="channelId") Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/_pause")
    @Operation(summary="Pauses the channel with the specified ID.")
    @MirthOperation(name="pauseChannels", display="Pause channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void pauseChannel(@Param(value="channelId") @Parameter(description="The channel ID to pause.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/_pause")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Pauses the channels with the specified IDs. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="pauseChannels", display="Pause channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void pauseChannels(@Param(value="channelIds") @Parameter(description="The channel IDs to pause.", required=true) @FormParam(value="channelId") Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/_resume")
    @Operation(summary="Resumes the channel with the specified ID.")
    @MirthOperation(name="resumeChannels", display="Resume channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void resumeChannel(@Param(value="channelId") @Parameter(description="The channel ID to resume.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/_resume")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Resume the channels with the specified IDs. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="resumeChannels", display="Resume channels", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void resumeChannels(@Param(value="channelIds") @Parameter(description="The channel IDs to resume.", required=true) @FormParam(value="channelId") Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/connector/{metaDataId}/_start")
    @Operation(summary="Starts the connector with the specified channel and metadata ID.")
    @MirthOperation(name="startConnectors", display="Start connectors", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void startConnector(@Param(value="channelId") @Parameter(description="The channel ID to start a connector for.", required=true) @PathParam(value="channelId") String var1, @Param(value="metaDataId") @Parameter(description="The connector metadata ID to start.", required=true) @PathParam(value="metaDataId") Integer var2, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var3) throws ClientException;

    @POST
    @Path(value="/_startConnectors")
    @Operation(summary="Starts the connectors with the specified channel and metadata IDs.")
    @MirthOperation(name="startConnectors", display="Start connectors", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void startConnectors(@Param(value="connectorInfo") @RequestBody(description="A map of channel and metadata IDs to start connectors for.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="start_connector_map", ref="../apiexamples/start_connector_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="start_connector_map", ref="../apiexamples/start_connector_map_json")})}) Map<String, List<Integer>> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/connector/{metaDataId}/_stop")
    @Operation(summary="Stops the connector with the specified channel and metadata ID.")
    @MirthOperation(name="stopConnectors", display="Stop connectors", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void stopConnector(@Param(value="channelId") @Parameter(description="The channel ID to stop a connector for.", required=true) @PathParam(value="channelId") String var1, @Param(value="metaDataId") @Parameter(description="The connector metadata ID to stop.", required=true) @PathParam(value="metaDataId") Integer var2, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var3) throws ClientException;

    @POST
    @Path(value="/_stopConnectors")
    @Operation(summary="Stops the connectors with the specified channel and metadata IDs.")
    @MirthOperation(name="stopConnectors", display="Stop connectors", permission="startStopChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void stopConnectors(@Param(value="connectorInfo") @RequestBody(description="A map of channel and metadata IDs to stop connectors for.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="start_connector_map", ref="../apiexamples/start_connector_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="start_connector_map", ref="../apiexamples/start_connector_map_json")})}) Map<String, List<Integer>> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;
}

