/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.CalendarToStringStyle;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XStreamAlias(value="channelTag")
public class ChannelTag
implements Serializable,
Purgable {
    public static final int MAX_NAME_LENGTH = 24;
    public static final Pattern INVALID_NAME_PATTERN = Pattern.compile("[^a-zA-Z_0-9\\-\\s]");
    private String id;
    private String name;
    private Set<String> channelIds;
    private Color backgroundColor;

    public ChannelTag(String name) {
        this(UUID.randomUUID().toString(), name);
    }

    public ChannelTag(String id, String name) {
        this(id, name, new HashSet<String>());
    }

    public ChannelTag(String id, String name, Set<String> channelIds) {
        this(id, name, channelIds, Color.lightGray);
    }

    public ChannelTag(String id, String name, Set<String> channelIds, Color backgroundColor) {
        this.id = id;
        this.name = ChannelTag.fixName(name);
        this.channelIds = channelIds;
        this.backgroundColor = backgroundColor;
    }

    public ChannelTag(ChannelTag tag) {
        this.id = tag.getId();
        this.name = ChannelTag.fixName(tag.getName());
        this.channelIds = new HashSet<String>(tag.getChannelIds());
        this.backgroundColor = tag.getBackgroundColor();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = ChannelTag.fixName(name);
    }

    public Set<String> getChannelIds() {
        return this.channelIds;
    }

    public void setChannelIds(Set<String> channelIds) {
        this.channelIds = channelIds;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static String fixName(String name) {
        if (StringUtils.isBlank((CharSequence)(name = StringUtils.substring((String)INVALID_NAME_PATTERN.matcher(name).replaceAll(""), (int)0, (int)24)))) {
            name = "_";
        }
        return name;
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("id", this.getId());
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.getName()));
        purgedProperties.put("channelCount", this.channelIds.size());
        purgedProperties.put("backgroundColor", this.getBackgroundColor());
        return purgedProperties;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)CalendarToStringStyle.instance()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChannelTag) {
            ChannelTag tag = (ChannelTag)obj;
            return Objects.equals(this.id, tag.getId()) && Objects.equals(this.name, tag.getName()) && Objects.equals(this.channelIds, tag.getChannelIds()) && Objects.equals(this.backgroundColor, tag.getBackgroundColor());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.channelIds, this.backgroundColor);
    }
}

