/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.codetemplates;

import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class BasicCodeTemplateProperties
extends CodeTemplateProperties {
    private String code;

    public BasicCodeTemplateProperties(CodeTemplateProperties.CodeTemplateType type, String code, String description) {
        this(type, BasicCodeTemplateProperties.addComment(code, description));
    }

    public BasicCodeTemplateProperties(CodeTemplateProperties.CodeTemplateType type, String code) {
        super(type);
        this.setCode(code);
    }

    @Override
    public String getPluginPointName() {
        return this.getType().toString();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.updateDocumentation();
    }

    private static String addComment(String code, String description) {
        if (StringUtils.isNotBlank((CharSequence)description)) {
            return "/**\n\t" + WordUtils.wrap((String)description, (int)80, (String)"\n\t", (boolean)false) + "\n*/\n" + code;
        }
        return code;
    }

    @Override
    public CodeTemplateProperties clone() {
        return new BasicCodeTemplateProperties(this.getType(), this.code);
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("type", (Object)this.getType());
        purgedProperties.put("codeLines", PurgeUtil.countLines((String)this.code));
        return purgedProperties;
    }
}

