/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.model.message.MapContent;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.MapUtil;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.w3c.dom.Element;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class MapContentConverter
extends ReflectionConverter {
    private HierarchicalStreamCopier copier = new HierarchicalStreamCopier();

    public MapContentConverter(Mapper mapper) {
        super(mapper, JVM.newReflectionProvider());
    }

    public boolean canConvert(Class type) {
        return type == MapContent.class;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        MapContent mapContent = (MapContent)value;
        if (!mapContent.isEncrypted() && MapUtil.hasInvalidValues((Map)mapContent.getMap())) {
            String serializedMap = MapUtil.serializeMap((Serializer)ObjectXMLSerializer.getInstance(), (Map)mapContent.getMap());
            try {
                DonkeyElement mapElement = new DonkeyElement(serializedMap);
                mapElement.setNodeName("content");
                mapElement.setAttribute("class", "tree-map");
                this.copier.copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(mapElement.toXml()), (XmlPullParser)new MXParser()), writer);
            }
            catch (DonkeyElement.DonkeyElementException e) {
                throw new SerializerException((Throwable)e);
            }
            writer.startNode("encrypted");
            context.convertAnother((Object)mapContent.isEncrypted());
            writer.endNode();
        } else {
            super.marshal(value, writer, context);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.underlyingReader() instanceof DocumentReader) {
            DonkeyElement mapContentElement = new DonkeyElement((Element)((DocumentReader)reader.underlyingReader()).getCurrent());
            try {
                return super.unmarshal(reader, context);
            }
            catch (Exception e) {
                while (((DocumentReader)reader.underlyingReader()).getCurrent() instanceof Element && !((DocumentReader)reader.underlyingReader()).getCurrent().equals(mapContentElement.getElement())) {
                    reader.moveUp();
                }
                MapContent mapContent = new MapContent();
                mapContent.setContent((Object)MapUtil.deserializeMapWithInvalidValues((Serializer)ObjectXMLSerializer.getInstance(), (DonkeyElement)mapContentElement.getChildElement("content")));
                mapContent.setEncrypted(Boolean.parseBoolean(mapContentElement.getChildElement("encrypted").getTextContent()));
                return mapContent;
            }
        }
        return super.unmarshal(reader, context);
    }
}

