/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.util.FilenameUtils;
import com.mirth.connect.util.PaginatedList;
import com.mirth.connect.util.messagewriter.AttachmentSource;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MessageExporter {
    private int numExported;
    private int numProcessed;

    public int getNumExported() {
        return this.numExported;
    }

    public int getNumProcessed() {
        return this.numProcessed;
    }

    public synchronized int exportMessages(PaginatedList<Message> messageList, MessageWriter messageWriter, AttachmentSource attachmentSource, MessageWriterOptions options) throws InterruptedException, MessageExportException {
        int pageNumber = 0;
        this.numExported = 0;
        do {
            ThreadUtils.checkInterruptedStatus();
            try {
                messageList.loadPageNumber(++pageNumber);
            }
            catch (Exception e) {
                throw new MessageExportException(e);
            }
            for (Message message : messageList) {
                ThreadUtils.checkInterruptedStatus();
                try {
                    List<Attachment> attachments;
                    if (attachmentSource != null && CollectionUtils.isNotEmpty(attachments = attachmentSource.getMessageAttachments(message))) {
                        message.setAttachments(attachments);
                    }
                    if (messageWriter.write(message)) {
                        ++this.numExported;
                    }
                    ++this.numProcessed;
                }
                catch (Exception e) {
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                    throw new MessageExportException("Failed to export message: " + cause.getMessage(), cause);
                }
            }
        } while (messageList.hasNextPage());
        if (this.numExported > 0) {
            this.writeExportReadMe(options);
        }
        return this.numExported;
    }

    public synchronized void writeExportReadMe(MessageWriterOptions options) throws InterruptedException, MessageExportException {
        String baseFolder = StringUtils.defaultString((String)options.getBaseFolder(), (String)System.getProperty("user.dir"));
        String rootFolder = FilenameUtils.getAbsolutePath(new File(baseFolder), options.getRootFolder());
        InputStream input = this.getClass().getResourceAsStream("EXPORTREADME.txt");
        File exportReadMeFile = new File(rootFolder + File.separator + "EXPORTREADME.txt");
        try {
            FileUtils.copyInputStreamToFile((InputStream)input, (File)exportReadMeFile);
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            throw new MessageExportException("Failed to export the EXPORTREADME.txt file: " + cause.getMessage(), cause);
        }
    }

    public static class MessageExportException
    extends Exception {
        public MessageExportException(String message) {
            super(message);
        }

        public MessageExportException(Throwable cause) {
            super(cause);
        }

        public MessageExportException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

