/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MirthXmlUtil {
    private static Templates normalizerTemplates = null;
    private static TransformerFactory serializerTransformerFactory = null;
    private static final Hashtable<String, String> decoder = new Hashtable(300);
    private static final Hashtable<String, String> decoderXml = new Hashtable(10);
    private static final String[] encoder = new String[256];
    private static final String[] encoderXml = new String[256];
    private static Logger logger = LogManager.getLogger(MirthXmlUtil.class);
    private static final String prettyPrintingXslt = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:output indent=\"no\" method=\"xml\" omit-xml-declaration=\"yes\"/><xsl:strip-space elements=\"*\"/><xsl:template match=\"/\"><xsl:copy-of select=\".\"/></xsl:template></xsl:stylesheet>";

    public static String prettyPrint(String input) {
        Transformer normalizerTransformer = null;
        Transformer serializerTransformer = null;
        try {
            normalizerTransformer = normalizerTemplates.newTransformer();
            normalizerTransformer.setOutputProperty("indent", "no");
            serializerTransformer = serializerTransformerFactory.newTransformer();
            try {
                serializerTransformer.setOutputProperty("indent", "yes");
                serializerTransformer.setOutputProperty("omit-xml-declaration", "yes");
                serializerTransformer.setOutputProperty("method", "xml");
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Could not set serializer attribute", (Throwable)ex);
            }
        }
        catch (TransformerConfigurationException e) {
            logger.error("Error setting pretty printer transformer.", (Throwable)e);
        }
        if (normalizerTransformer != null && serializerTransformer != null) {
            try {
                Source source = new StreamSource(new StringReader(input));
                StringWriter writer = new StringWriter();
                DOMResult result = new DOMResult();
                normalizerTransformer.transform(source, result);
                source = new DOMSource(result.getNode());
                serializerTransformer.transform(source, new StreamResult(writer));
                return ((Object)writer).toString();
            }
            catch (TransformerException e) {
                logger.error("Error pretty printing xml.", (Throwable)e);
            }
        }
        return input;
    }

    public static String decode(String entity) {
        if (entity.charAt(entity.length() - 1) == ';') {
            entity = entity.substring(0, entity.length() - 1);
        }
        if (entity.charAt(1) == '#') {
            int start = 2;
            int radix = 10;
            if (entity.charAt(2) == 'X' || entity.charAt(2) == 'x') {
                ++start;
                radix = 16;
            }
            Character c = new Character((char)Integer.parseInt(entity.substring(start), radix));
            return c.toString();
        }
        String s = decoder.get(entity);
        if (s != null) {
            return s;
        }
        return "";
    }

    public static String encode(char s) {
        StringBuffer buffer = new StringBuffer(4);
        char c = s;
        char j = c;
        if (j < '\u0100' && encoderXml[j] != null) {
            buffer.append(encoderXml[j]);
            buffer.append(';');
        } else if (j < '\u0080') {
            buffer.append(c);
        } else {
            buffer.append("&#");
            buffer.append((int)c);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public static String encode(String s) {
        int length = s.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            buffer.append(MirthXmlUtil.encode(c));
        }
        return buffer.toString();
    }

    public static String encode(char[] text, int start, int length) {
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = start; i < length + start; ++i) {
            char c = text[i];
            char j = c;
            if (j < '\u0100' && encoderXml[j] != null) {
                buffer.append(encoderXml[j]);
                buffer.append(';');
                continue;
            }
            if (j < '\u0080') {
                buffer.append(c);
                continue;
            }
            buffer.append("&#");
            buffer.append((int)c);
            buffer.append(';');
        }
        return buffer.toString();
    }

    private static void addEntity(String entity, int value) {
        decoder.put(entity, new Character((char)value).toString());
        if (value < 256) {
            MirthXmlUtil.encoder[value] = entity;
        }
    }

    private static void addXmlEntity(String entity, int value) {
        decoderXml.put(entity, new Character((char)value).toString());
        if (value < 256) {
            MirthXmlUtil.encoderXml[value] = entity;
        }
    }

    private static void addEntities() {
        MirthXmlUtil.addEntity("&nbsp", 160);
        MirthXmlUtil.addEntity("&iexcl", 161);
        MirthXmlUtil.addEntity("&cent", 162);
        MirthXmlUtil.addEntity("&pound", 163);
        MirthXmlUtil.addEntity("&curren", 164);
        MirthXmlUtil.addEntity("&yen", 165);
        MirthXmlUtil.addEntity("&brvbar", 166);
        MirthXmlUtil.addEntity("&sect", 167);
        MirthXmlUtil.addEntity("&uml", 168);
        MirthXmlUtil.addEntity("&copy", 169);
        MirthXmlUtil.addEntity("&ordf", 170);
        MirthXmlUtil.addEntity("&laquo", 171);
        MirthXmlUtil.addEntity("&not", 172);
        MirthXmlUtil.addEntity("&shy", 173);
        MirthXmlUtil.addEntity("&reg", 174);
        MirthXmlUtil.addEntity("&macr", 175);
        MirthXmlUtil.addEntity("&deg", 176);
        MirthXmlUtil.addEntity("&plusmn", 177);
        MirthXmlUtil.addEntity("&sup2", 178);
        MirthXmlUtil.addEntity("&sup3", 179);
        MirthXmlUtil.addEntity("&acute", 180);
        MirthXmlUtil.addEntity("&micro", 181);
        MirthXmlUtil.addEntity("&para", 182);
        MirthXmlUtil.addEntity("&middot", 183);
        MirthXmlUtil.addEntity("&cedil", 184);
        MirthXmlUtil.addEntity("&sup1", 185);
        MirthXmlUtil.addEntity("&ordm", 186);
        MirthXmlUtil.addEntity("&raquo", 187);
        MirthXmlUtil.addEntity("&frac14", 188);
        MirthXmlUtil.addEntity("&frac12", 189);
        MirthXmlUtil.addEntity("&frac34", 190);
        MirthXmlUtil.addEntity("&iquest", 191);
        MirthXmlUtil.addEntity("&Agrave", 192);
        MirthXmlUtil.addEntity("&Aacute", 193);
        MirthXmlUtil.addEntity("&Acirc", 194);
        MirthXmlUtil.addEntity("&Atilde", 195);
        MirthXmlUtil.addEntity("&Auml", 196);
        MirthXmlUtil.addEntity("&Aring", 197);
        MirthXmlUtil.addEntity("&AElig", 198);
        MirthXmlUtil.addEntity("&Ccedil", 199);
        MirthXmlUtil.addEntity("&Egrave", 200);
        MirthXmlUtil.addEntity("&Eacute", 201);
        MirthXmlUtil.addEntity("&Ecirc", 202);
        MirthXmlUtil.addEntity("&Euml", 203);
        MirthXmlUtil.addEntity("&Igrave", 204);
        MirthXmlUtil.addEntity("&Iacute", 205);
        MirthXmlUtil.addEntity("&Icirc", 206);
        MirthXmlUtil.addEntity("&Iuml", 207);
        MirthXmlUtil.addEntity("&ETH", 208);
        MirthXmlUtil.addEntity("&Ntilde", 209);
        MirthXmlUtil.addEntity("&Ograve", 210);
        MirthXmlUtil.addEntity("&Oacute", 211);
        MirthXmlUtil.addEntity("&Ocirc", 212);
        MirthXmlUtil.addEntity("&Otilde", 213);
        MirthXmlUtil.addEntity("&Ouml", 214);
        MirthXmlUtil.addEntity("&times", 215);
        MirthXmlUtil.addEntity("&Oslash", 216);
        MirthXmlUtil.addEntity("&Ugrave", 217);
        MirthXmlUtil.addEntity("&Uacute", 218);
        MirthXmlUtil.addEntity("&Ucirc", 219);
        MirthXmlUtil.addEntity("&Uuml", 220);
        MirthXmlUtil.addEntity("&Yacute", 221);
        MirthXmlUtil.addEntity("&THORN", 222);
        MirthXmlUtil.addEntity("&szlig", 223);
        MirthXmlUtil.addEntity("&agrave", 224);
        MirthXmlUtil.addEntity("&aacute", 225);
        MirthXmlUtil.addEntity("&acirc", 226);
        MirthXmlUtil.addEntity("&atilde", 227);
        MirthXmlUtil.addEntity("&auml", 228);
        MirthXmlUtil.addEntity("&aring", 229);
        MirthXmlUtil.addEntity("&aelig", 230);
        MirthXmlUtil.addEntity("&ccedil", 231);
        MirthXmlUtil.addEntity("&egrave", 232);
        MirthXmlUtil.addEntity("&eacute", 233);
        MirthXmlUtil.addEntity("&ecirc", 234);
        MirthXmlUtil.addEntity("&euml", 235);
        MirthXmlUtil.addEntity("&igrave", 236);
        MirthXmlUtil.addEntity("&iacute", 237);
        MirthXmlUtil.addEntity("&icirc", 238);
        MirthXmlUtil.addEntity("&iuml", 239);
        MirthXmlUtil.addEntity("&eth", 240);
        MirthXmlUtil.addEntity("&ntilde", 241);
        MirthXmlUtil.addEntity("&ograve", 242);
        MirthXmlUtil.addEntity("&oacute", 243);
        MirthXmlUtil.addEntity("&ocirc", 244);
        MirthXmlUtil.addEntity("&otilde", 245);
        MirthXmlUtil.addEntity("&ouml", 246);
        MirthXmlUtil.addEntity("&divide", 247);
        MirthXmlUtil.addEntity("&oslash", 248);
        MirthXmlUtil.addEntity("&ugrave", 249);
        MirthXmlUtil.addEntity("&uacute", 250);
        MirthXmlUtil.addEntity("&ucirc", 251);
        MirthXmlUtil.addEntity("&uuml", 252);
        MirthXmlUtil.addEntity("&yacute", 253);
        MirthXmlUtil.addEntity("&thorn", 254);
        MirthXmlUtil.addEntity("&yuml", 255);
        MirthXmlUtil.addEntity("&fnof", 402);
        MirthXmlUtil.addEntity("&Alpha", 913);
        MirthXmlUtil.addEntity("&Beta", 914);
        MirthXmlUtil.addEntity("&Gamma", 915);
        MirthXmlUtil.addEntity("&Delta", 916);
        MirthXmlUtil.addEntity("&Epsilon", 917);
        MirthXmlUtil.addEntity("&Zeta", 918);
        MirthXmlUtil.addEntity("&Eta", 919);
        MirthXmlUtil.addEntity("&Theta", 920);
        MirthXmlUtil.addEntity("&Iota", 921);
        MirthXmlUtil.addEntity("&Kappa", 922);
        MirthXmlUtil.addEntity("&Lambda", 923);
        MirthXmlUtil.addEntity("&Mu", 924);
        MirthXmlUtil.addEntity("&Nu", 925);
        MirthXmlUtil.addEntity("&Xi", 926);
        MirthXmlUtil.addEntity("&Omicron", 927);
        MirthXmlUtil.addEntity("&Pi", 928);
        MirthXmlUtil.addEntity("&Rho", 929);
        MirthXmlUtil.addEntity("&Sigma", 931);
        MirthXmlUtil.addEntity("&Tau", 932);
        MirthXmlUtil.addEntity("&Upsilon", 933);
        MirthXmlUtil.addEntity("&Phi", 934);
        MirthXmlUtil.addEntity("&Chi", 935);
        MirthXmlUtil.addEntity("&Psi", 936);
        MirthXmlUtil.addEntity("&Omega", 937);
        MirthXmlUtil.addEntity("&alpha", 945);
        MirthXmlUtil.addEntity("&beta", 946);
        MirthXmlUtil.addEntity("&gamma", 947);
        MirthXmlUtil.addEntity("&delta", 948);
        MirthXmlUtil.addEntity("&epsilon", 949);
        MirthXmlUtil.addEntity("&zeta", 950);
        MirthXmlUtil.addEntity("&eta", 951);
        MirthXmlUtil.addEntity("&theta", 952);
        MirthXmlUtil.addEntity("&iota", 953);
        MirthXmlUtil.addEntity("&kappa", 954);
        MirthXmlUtil.addEntity("&lambda", 955);
        MirthXmlUtil.addEntity("&mu", 956);
        MirthXmlUtil.addEntity("&nu", 957);
        MirthXmlUtil.addEntity("&xi", 958);
        MirthXmlUtil.addEntity("&omicron", 959);
        MirthXmlUtil.addEntity("&pi", 960);
        MirthXmlUtil.addEntity("&rho", 961);
        MirthXmlUtil.addEntity("&sigmaf", 962);
        MirthXmlUtil.addEntity("&sigma", 963);
        MirthXmlUtil.addEntity("&tau", 964);
        MirthXmlUtil.addEntity("&upsilon", 965);
        MirthXmlUtil.addEntity("&phi", 966);
        MirthXmlUtil.addEntity("&chi", 967);
        MirthXmlUtil.addEntity("&psi", 968);
        MirthXmlUtil.addEntity("&omega", 969);
        MirthXmlUtil.addEntity("&thetasym", 977);
        MirthXmlUtil.addEntity("&upsih", 978);
        MirthXmlUtil.addEntity("&piv", 982);
        MirthXmlUtil.addEntity("&bull", 8226);
        MirthXmlUtil.addEntity("&hellip", 8230);
        MirthXmlUtil.addEntity("&prime", 8242);
        MirthXmlUtil.addEntity("&Prime", 8243);
        MirthXmlUtil.addEntity("&oline", 8254);
        MirthXmlUtil.addEntity("&frasl", 8260);
        MirthXmlUtil.addEntity("&weierp", 8472);
        MirthXmlUtil.addEntity("&image", 8465);
        MirthXmlUtil.addEntity("&real", 8476);
        MirthXmlUtil.addEntity("&trade", 8482);
        MirthXmlUtil.addEntity("&alefsym", 8501);
        MirthXmlUtil.addEntity("&larr", 8592);
        MirthXmlUtil.addEntity("&uarr", 8593);
        MirthXmlUtil.addEntity("&rarr", 8594);
        MirthXmlUtil.addEntity("&darr", 8595);
        MirthXmlUtil.addEntity("&harr", 8596);
        MirthXmlUtil.addEntity("&crarr", 8629);
        MirthXmlUtil.addEntity("&lArr", 8656);
        MirthXmlUtil.addEntity("&uArr", 8657);
        MirthXmlUtil.addEntity("&rArr", 8658);
        MirthXmlUtil.addEntity("&dArr", 8659);
        MirthXmlUtil.addEntity("&hArr", 8660);
        MirthXmlUtil.addEntity("&forall", 8704);
        MirthXmlUtil.addEntity("&part", 8706);
        MirthXmlUtil.addEntity("&exist", 8707);
        MirthXmlUtil.addEntity("&empty", 8709);
        MirthXmlUtil.addEntity("&nabla", 8711);
        MirthXmlUtil.addEntity("&isin", 8712);
        MirthXmlUtil.addEntity("&notin", 8713);
        MirthXmlUtil.addEntity("&ni", 8715);
        MirthXmlUtil.addEntity("&prod", 8719);
        MirthXmlUtil.addEntity("&sum", 8721);
        MirthXmlUtil.addEntity("&minus", 8722);
        MirthXmlUtil.addEntity("&lowast", 8727);
        MirthXmlUtil.addEntity("&radic", 8730);
        MirthXmlUtil.addEntity("&prop", 8733);
        MirthXmlUtil.addEntity("&infin", 8734);
        MirthXmlUtil.addEntity("&ang", 8736);
        MirthXmlUtil.addEntity("&and", 8743);
        MirthXmlUtil.addEntity("&or", 8744);
        MirthXmlUtil.addEntity("&cap", 8745);
        MirthXmlUtil.addEntity("&cup", 8746);
        MirthXmlUtil.addEntity("&int", 8747);
        MirthXmlUtil.addEntity("&there4", 8756);
        MirthXmlUtil.addEntity("&sim", 8764);
        MirthXmlUtil.addEntity("&cong", 8773);
        MirthXmlUtil.addEntity("&asymp", 8776);
        MirthXmlUtil.addEntity("&ne", 8800);
        MirthXmlUtil.addEntity("&equiv", 8801);
        MirthXmlUtil.addEntity("&le", 8804);
        MirthXmlUtil.addEntity("&ge", 8805);
        MirthXmlUtil.addEntity("&sub", 8834);
        MirthXmlUtil.addEntity("&sup", 8835);
        MirthXmlUtil.addEntity("&nsub", 8836);
        MirthXmlUtil.addEntity("&sube", 8838);
        MirthXmlUtil.addEntity("&supe", 8839);
        MirthXmlUtil.addEntity("&oplus", 8853);
        MirthXmlUtil.addEntity("&otimes", 8855);
        MirthXmlUtil.addEntity("&perp", 8869);
        MirthXmlUtil.addEntity("&sdot", 8901);
        MirthXmlUtil.addEntity("&lceil", 8968);
        MirthXmlUtil.addEntity("&rceil", 8969);
        MirthXmlUtil.addEntity("&lfloor", 8970);
        MirthXmlUtil.addEntity("&rfloor", 8971);
        MirthXmlUtil.addEntity("&lang", 9001);
        MirthXmlUtil.addEntity("&rang", 9002);
        MirthXmlUtil.addEntity("&loz", 9674);
        MirthXmlUtil.addEntity("&spades", 9824);
        MirthXmlUtil.addEntity("&clubs", 9827);
        MirthXmlUtil.addEntity("&hearts", 9829);
        MirthXmlUtil.addEntity("&diams", 9830);
        MirthXmlUtil.addEntity("&quot", 34);
        MirthXmlUtil.addEntity("&amp", 38);
        MirthXmlUtil.addEntity("&lt", 60);
        MirthXmlUtil.addEntity("&gt", 62);
        MirthXmlUtil.addEntity("&OElig", 338);
        MirthXmlUtil.addEntity("&oelig", 339);
        MirthXmlUtil.addEntity("&Scaron", 352);
        MirthXmlUtil.addEntity("&scaron", 353);
        MirthXmlUtil.addEntity("&Yuml", 376);
        MirthXmlUtil.addEntity("&circ", 710);
        MirthXmlUtil.addEntity("&tilde", 732);
        MirthXmlUtil.addEntity("&ensp", 8194);
        MirthXmlUtil.addEntity("&emsp", 8195);
        MirthXmlUtil.addEntity("&thinsp", 8201);
        MirthXmlUtil.addEntity("&zwnj", 8204);
        MirthXmlUtil.addEntity("&zwj", 8205);
        MirthXmlUtil.addEntity("&lrm", 8206);
        MirthXmlUtil.addEntity("&rlm", 8207);
        MirthXmlUtil.addEntity("&ndash", 8211);
        MirthXmlUtil.addEntity("&mdash", 8212);
        MirthXmlUtil.addEntity("&lsquo", 8216);
        MirthXmlUtil.addEntity("&rsquo", 8217);
        MirthXmlUtil.addEntity("&sbquo", 8218);
        MirthXmlUtil.addEntity("&ldquo", 8220);
        MirthXmlUtil.addEntity("&rdquo", 8221);
        MirthXmlUtil.addEntity("&bdquo", 8222);
        MirthXmlUtil.addEntity("&dagger", 8224);
        MirthXmlUtil.addEntity("&Dagger", 8225);
        MirthXmlUtil.addEntity("&permil", 8240);
        MirthXmlUtil.addEntity("&lsaquo", 8249);
        MirthXmlUtil.addEntity("&rsaquo", 8250);
        MirthXmlUtil.addEntity("&euro", 8364);
        MirthXmlUtil.addXmlEntity("&lt", 60);
        MirthXmlUtil.addXmlEntity("&gt", 62);
        MirthXmlUtil.addXmlEntity("&apos", 39);
        MirthXmlUtil.addXmlEntity("&amp", 38);
        MirthXmlUtil.addXmlEntity("&quot", 34);
        MirthXmlUtil.addXmlEntity("&#10", 10);
        MirthXmlUtil.addXmlEntity("&#13", 13);
    }

    private static TransformerFactory getTransformerFactory() {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return tf;
    }

    static {
        MirthXmlUtil.addEntities();
        try {
            TransformerFactory normalizerTransformerFactory = MirthXmlUtil.getTransformerFactory();
            normalizerTemplates = normalizerTransformerFactory.newTemplates(new StreamSource(new StringReader(prettyPrintingXslt)));
            serializerTransformerFactory = MirthXmlUtil.getTransformerFactory();
            try {
                serializerTransformerFactory.setAttribute("indent-number", new Integer(4));
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Could not set serializer attribute: indent-number", (Throwable)ex);
            }
        }
        catch (TransformerConfigurationException e) {
            logger.error("Error setting pretty printer transformer.", (Throwable)e);
        }
    }
}

