/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.util.Arrays;

public abstract class GenericNumericArray {
    public static GenericNumericArray create(byte[] array) {
        if (array == null) {
            throw new NullPointerException("Array is NULL");
        }
        return new ByteNumericArray(array);
    }

    public static GenericNumericArray create(short[] array) {
        if (array == null) {
            throw new NullPointerException("Array is NULL");
        }
        return new ShortNumericArray(array);
    }

    public static GenericNumericArray getByteArray(int size) {
        return GenericNumericArray.create(new byte[size]);
    }

    public static GenericNumericArray getShortArray(int size) {
        return GenericNumericArray.create(new short[size]);
    }

    public abstract Object getArray();

    public abstract Number getArrayItem(int var1);

    public abstract void setArrayItem(int var1, Number var2);

    public abstract void fillRange(int var1, int var2, Number var3);

    public abstract int length();

    private static class ShortNumericArray
    extends GenericNumericArray {
        private short[] arr = null;

        public ShortNumericArray(short[] arr) {
            this.arr = arr;
        }

        @Override
        public Object getArray() {
            return this.arr;
        }

        @Override
        public Number getArrayItem(int index) {
            return this.arr[index];
        }

        @Override
        public void setArrayItem(int index, Number value) {
            this.arr[index] = value.shortValue();
        }

        @Override
        public void fillRange(int fromIndex, int toIndex, Number val) {
            Arrays.fill(this.arr, fromIndex, toIndex, val.shortValue());
        }

        @Override
        public int length() {
            return this.arr.length;
        }
    }

    private static class ByteNumericArray
    extends GenericNumericArray {
        private byte[] arr = null;

        public ByteNumericArray(byte[] arr) {
            this.arr = arr;
        }

        @Override
        public Object getArray() {
            return this.arr;
        }

        @Override
        public Number getArrayItem(int index) {
            return this.arr[index];
        }

        @Override
        public void setArrayItem(int index, Number value) {
            this.arr[index] = value.byteValue();
        }

        @Override
        public void fillRange(int fromIndex, int toIndex, Number val) {
            Arrays.fill(this.arr, fromIndex, toIndex, val.byteValue());
        }

        @Override
        public int length() {
            return this.arr.length;
        }
    }
}

