/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.RDE_O11_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.RDE_O11_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v28.group.RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER;
import ca.uhn.hl7v2.model.v28.group.RDE_O11_TIMING;
import ca.uhn.hl7v2.model.v28.group.RDE_O11_TIMING_ENCODED;
import ca.uhn.hl7v2.model.v28.segment.BLG;
import ca.uhn.hl7v2.model.v28.segment.CDO;
import ca.uhn.hl7v2.model.v28.segment.CTI;
import ca.uhn.hl7v2.model.v28.segment.FT1;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.model.v28.segment.RXC;
import ca.uhn.hl7v2.model.v28.segment.RXE;
import ca.uhn.hl7v2.model.v28.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RDE_O11_ORDER
extends AbstractGroup {
    public RDE_O11_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(RDE_O11_TIMING.class, false, true, false);
            this.add(RDE_O11_ORDER_DETAIL.class, false, false, false);
            this.add(RXE.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(RDE_O11_TIMING_ENCODED.class, true, true, false);
            this.add(RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER.class, false, true, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
            this.add(CDO.class, false, true, false);
            this.add(RDE_O11_OBSERVATION.class, false, true, false);
            this.add(FT1.class, false, true, false);
            this.add(BLG.class, false, false, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDE_O11_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public RDE_O11_TIMING getTIMING() {
        RDE_O11_TIMING retVal = (RDE_O11_TIMING)this.getTyped("TIMING", RDE_O11_TIMING.class);
        return retVal;
    }

    public RDE_O11_TIMING getTIMING(int rep) {
        RDE_O11_TIMING retVal = (RDE_O11_TIMING)this.getTyped("TIMING", rep, RDE_O11_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RDE_O11_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RDE_O11_TIMING.class);
    }

    public void insertTIMING(RDE_O11_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RDE_O11_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RDE_O11_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RDE_O11_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RDE_O11_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RDE_O11_ORDER_DETAIL getORDER_DETAIL() {
        RDE_O11_ORDER_DETAIL retVal = (RDE_O11_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RDE_O11_ORDER_DETAIL.class);
        return retVal;
    }

    public RXE getRXE() {
        RXE retVal = (RXE)this.getTyped("RXE", RXE.class);
        return retVal;
    }

    public PRT getPRT2() {
        PRT retVal = (PRT)this.getTyped("PRT2", PRT.class);
        return retVal;
    }

    public PRT getPRT2(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT2", rep, PRT.class);
        return retVal;
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", (Structure)structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RDE_O11_TIMING_ENCODED getTIMING_ENCODED() {
        RDE_O11_TIMING_ENCODED retVal = (RDE_O11_TIMING_ENCODED)this.getTyped("TIMING_ENCODED", RDE_O11_TIMING_ENCODED.class);
        return retVal;
    }

    public RDE_O11_TIMING_ENCODED getTIMING_ENCODED(int rep) {
        RDE_O11_TIMING_ENCODED retVal = (RDE_O11_TIMING_ENCODED)this.getTyped("TIMING_ENCODED", rep, RDE_O11_TIMING_ENCODED.class);
        return retVal;
    }

    public int getTIMING_ENCODEDReps() {
        return this.getReps("TIMING_ENCODED");
    }

    public List<RDE_O11_TIMING_ENCODED> getTIMING_ENCODEDAll() throws HL7Exception {
        return this.getAllAsList("TIMING_ENCODED", RDE_O11_TIMING_ENCODED.class);
    }

    public void insertTIMING_ENCODED(RDE_O11_TIMING_ENCODED structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_ENCODED", (Structure)structure, rep);
    }

    public RDE_O11_TIMING_ENCODED insertTIMING_ENCODED(int rep) throws HL7Exception {
        return (RDE_O11_TIMING_ENCODED)super.insertRepetition("TIMING_ENCODED", rep);
    }

    public RDE_O11_TIMING_ENCODED removeTIMING_ENCODED(int rep) throws HL7Exception {
        return (RDE_O11_TIMING_ENCODED)super.removeRepetition("TIMING_ENCODED", rep);
    }

    public RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER getPHARMACY_TREATMENT_INFUSION_ORDER() {
        RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER retVal = (RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER)this.getTyped("PHARMACY_TREATMENT_INFUSION_ORDER", RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER.class);
        return retVal;
    }

    public RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER getPHARMACY_TREATMENT_INFUSION_ORDER(int rep) {
        RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER retVal = (RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER)this.getTyped("PHARMACY_TREATMENT_INFUSION_ORDER", rep, RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER.class);
        return retVal;
    }

    public int getPHARMACY_TREATMENT_INFUSION_ORDERReps() {
        return this.getReps("PHARMACY_TREATMENT_INFUSION_ORDER");
    }

    public List<RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER> getPHARMACY_TREATMENT_INFUSION_ORDERAll() throws HL7Exception {
        return this.getAllAsList("PHARMACY_TREATMENT_INFUSION_ORDER", RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER.class);
    }

    public void insertPHARMACY_TREATMENT_INFUSION_ORDER(RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PHARMACY_TREATMENT_INFUSION_ORDER", (Structure)structure, rep);
    }

    public RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER insertPHARMACY_TREATMENT_INFUSION_ORDER(int rep) throws HL7Exception {
        return (RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER)super.insertRepetition("PHARMACY_TREATMENT_INFUSION_ORDER", rep);
    }

    public RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER removePHARMACY_TREATMENT_INFUSION_ORDER(int rep) throws HL7Exception {
        return (RDE_O11_PHARMACY_TREATMENT_INFUSION_ORDER)super.removeRepetition("PHARMACY_TREATMENT_INFUSION_ORDER", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public CDO getCDO() {
        CDO retVal = (CDO)this.getTyped("CDO", CDO.class);
        return retVal;
    }

    public CDO getCDO(int rep) {
        CDO retVal = (CDO)this.getTyped("CDO", rep, CDO.class);
        return retVal;
    }

    public int getCDOReps() {
        return this.getReps("CDO");
    }

    public List<CDO> getCDOAll() throws HL7Exception {
        return this.getAllAsList("CDO", CDO.class);
    }

    public void insertCDO(CDO structure, int rep) throws HL7Exception {
        super.insertRepetition("CDO", (Structure)structure, rep);
    }

    public CDO insertCDO(int rep) throws HL7Exception {
        return (CDO)super.insertRepetition("CDO", rep);
    }

    public CDO removeCDO(int rep) throws HL7Exception {
        return (CDO)super.removeRepetition("CDO", rep);
    }

    public RDE_O11_OBSERVATION getOBSERVATION() {
        RDE_O11_OBSERVATION retVal = (RDE_O11_OBSERVATION)this.getTyped("OBSERVATION", RDE_O11_OBSERVATION.class);
        return retVal;
    }

    public RDE_O11_OBSERVATION getOBSERVATION(int rep) {
        RDE_O11_OBSERVATION retVal = (RDE_O11_OBSERVATION)this.getTyped("OBSERVATION", rep, RDE_O11_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RDE_O11_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RDE_O11_OBSERVATION.class);
    }

    public void insertOBSERVATION(RDE_O11_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RDE_O11_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RDE_O11_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RDE_O11_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RDE_O11_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public FT1 getFT1() {
        FT1 retVal = (FT1)this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public FT1 getFT1(int rep) {
        FT1 retVal = (FT1)this.getTyped("FT1", rep, FT1.class);
        return retVal;
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public BLG getBLG() {
        BLG retVal = (BLG)this.getTyped("BLG", BLG.class);
        return retVal;
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

