/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net.pdu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.dcm4che2.data.Implementation;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.net.pdu.CommonExtendedNegotiation;
import org.dcm4che2.net.pdu.ExtendedNegotiation;
import org.dcm4che2.net.pdu.PresentationContext;
import org.dcm4che2.net.pdu.RoleSelection;
import org.dcm4che2.util.IntHashtable;
import org.dcm4che2.util.StringUtils;

public abstract class AAssociateRQAC {
    public static final int DEF_MAX_PDU_LENGTH = 16384;
    private static final String DEF_CALLED_AET = "ANONYMOUS";
    private static final String DEF_CALLING_AET = "ANONYMOUS";
    protected byte[] reservedBytes = new byte[32];
    protected int protocolVersion = 1;
    protected int maxPDULength = 16384;
    protected int maxOpsInvoked = 1;
    protected int maxOpsPerformed = 1;
    protected String calledAET = "ANONYMOUS";
    protected String callingAET = "ANONYMOUS";
    protected String applicationContext = "1.2.840.10008.3.1.1.1";
    protected String implClassUID = Implementation.classUID();
    protected String implVersionName = Implementation.versionName();
    protected final ArrayList<PresentationContext> pcs = new ArrayList();
    protected final IntHashtable<PresentationContext> pcidMap = new IntHashtable();
    protected final LinkedHashMap<String, RoleSelection> roleSelMap = new LinkedHashMap();
    protected final LinkedHashMap<String, ExtendedNegotiation> extNegMap = new LinkedHashMap();
    protected final LinkedHashMap<String, CommonExtendedNegotiation> commonExtNegMap = new LinkedHashMap();

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public final byte[] getReservedBytes() {
        return (byte[])this.reservedBytes.clone();
    }

    public final void setReservedBytes(byte[] reservedBytes) {
        if (reservedBytes.length != 32) {
            throw new IllegalArgumentException("reservedBytes.length: " + reservedBytes.length);
        }
        System.arraycopy(reservedBytes, 0, this.reservedBytes, 0, 32);
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String calledAET) {
        if (calledAET.length() > 16) {
            throw new IllegalArgumentException("calledAET: " + calledAET);
        }
        this.calledAET = calledAET;
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final void setCallingAET(String callingAET) {
        if (callingAET.length() > 16) {
            throw new IllegalArgumentException("callingAET: " + callingAET);
        }
        this.callingAET = callingAET;
    }

    public final String getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(String applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException();
        }
        this.applicationContext = applicationContext;
    }

    public final int getMaxPDULength() {
        return this.maxPDULength;
    }

    public final void setMaxPDULength(int maxPDULength) {
        this.maxPDULength = maxPDULength;
    }

    public final int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public final void setMaxOpsInvoked(int maxOpsInvoked) {
        this.maxOpsInvoked = maxOpsInvoked;
    }

    public final int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public final void setMaxOpsPerformed(int maxOpsPerformed) {
        this.maxOpsPerformed = maxOpsPerformed;
    }

    public final boolean isAsyncOps() {
        return this.maxOpsInvoked != 1 || this.maxOpsPerformed != 1;
    }

    public final String getImplClassUID() {
        return this.implClassUID;
    }

    public final void setImplClassUID(String implClassUID) {
        if (implClassUID == null) {
            throw new NullPointerException();
        }
        this.implClassUID = implClassUID;
    }

    public final String getImplVersionName() {
        return this.implVersionName;
    }

    public final void setImplVersionName(String implVersionName) {
        this.implVersionName = implVersionName;
    }

    public Collection<PresentationContext> getPresentationContexts() {
        return Collections.unmodifiableCollection(this.pcs);
    }

    public int getNumberOfPresentationContexts() {
        return this.pcs.size();
    }

    public PresentationContext getPresentationContext(int pcid) {
        return (PresentationContext)this.pcidMap.get(pcid);
    }

    public synchronized void addPresentationContext(PresentationContext pc) {
        int pcid = pc.getPCID();
        PresentationContext prev = (PresentationContext)this.pcidMap.remove(pcid);
        if (prev != null) {
            this.pcs.remove(prev);
        }
        this.pcidMap.put(pcid, (Object)pc);
        this.pcs.add(pc);
    }

    public synchronized boolean removePresentationContext(PresentationContext pc) {
        if (!this.pcs.remove(pc)) {
            return false;
        }
        this.pcidMap.remove(pc.getPCID());
        return true;
    }

    public Collection<RoleSelection> getRoleSelections() {
        return Collections.unmodifiableCollection(this.roleSelMap.values());
    }

    public RoleSelection getRoleSelectionFor(String cuid) {
        return this.roleSelMap.get(cuid);
    }

    public RoleSelection addRoleSelection(RoleSelection rs) {
        return this.roleSelMap.put(rs.getSOPClassUID(), rs);
    }

    public RoleSelection removeRoleSelectionFor(String cuid) {
        return (RoleSelection)this.roleSelMap.remove(cuid);
    }

    public Collection<ExtendedNegotiation> getExtendedNegotiations() {
        return Collections.unmodifiableCollection(this.extNegMap.values());
    }

    public ExtendedNegotiation getExtendedNegotiationFor(String cuid) {
        return this.extNegMap.get(cuid);
    }

    public ExtendedNegotiation addExtendedNegotiation(ExtendedNegotiation extNeg) {
        return this.extNegMap.put(extNeg.getSOPClassUID(), extNeg);
    }

    public ExtendedNegotiation removeExtendedNegotiationFor(String cuid) {
        return (ExtendedNegotiation)this.extNegMap.remove(cuid);
    }

    public Collection<CommonExtendedNegotiation> getCommonExtendedNegotiations() {
        return Collections.unmodifiableCollection(this.commonExtNegMap.values());
    }

    public CommonExtendedNegotiation getCommonExtendedNegotiationFor(String cuid) {
        return this.commonExtNegMap.get(cuid);
    }

    public CommonExtendedNegotiation addCommonExtendedNegotiation(CommonExtendedNegotiation extNeg) {
        return this.commonExtNegMap.put(extNeg.getSOPClassUID(), extNeg);
    }

    public CommonExtendedNegotiation removeCommonExtendedNegotiationFor(String cuid) {
        return (CommonExtendedNegotiation)this.commonExtNegMap.remove(cuid);
    }

    public int length() {
        int len = 68;
        len += 4 + this.applicationContext.length();
        for (PresentationContext pc : this.pcs) {
            len += 4 + pc.length();
        }
        return len += 4 + this.userInfoLength();
    }

    public int userInfoLength() {
        int len = 8;
        len += 4 + this.implClassUID.length();
        if (this.isAsyncOps()) {
            len += 8;
        }
        for (RoleSelection rs : this.roleSelMap.values()) {
            len += 4 + rs.length();
        }
        if (this.implVersionName != null) {
            len += 4 + this.implVersionName.length();
        }
        for (ExtendedNegotiation en : this.extNegMap.values()) {
            len += 4 + en.length();
        }
        for (CommonExtendedNegotiation cen : this.commonExtNegMap.values()) {
            len += 4 + cen.length();
        }
        return len;
    }

    private static StringBuffer promptUID(String uid, StringBuffer sb) {
        return sb.append(uid).append(" - ").append(UIDDictionary.getDictionary().nameOf(uid));
    }

    protected String toString(String type) {
        StringBuffer sb = new StringBuffer(512);
        sb.append(type);
        sb.append("[\n  calledAET = ").append(this.calledAET);
        sb.append("\n  callingAET = ").append(this.callingAET);
        sb.append("\n  applicationContext = ");
        AAssociateRQAC.promptUID(this.applicationContext, sb);
        sb.append("\n  implClassUID = ").append(this.implClassUID);
        sb.append("\n  implVersionName = ").append(this.implVersionName);
        sb.append("\n  maxPDULength = ").append(this.maxPDULength);
        sb.append("\n  maxOpsInvoked/maxOpsPerformed = ").append(this.maxOpsInvoked).append("/").append(this.maxOpsPerformed);
        this.appendUserIdentity(sb);
        this.promptPresentationContext(sb);
        this.promptRoleSelection(sb);
        this.promptExtendedNegotiation(sb);
        this.promptCommonExtendedNegotiation(sb);
        sb.append("\n]");
        return sb.toString();
    }

    protected abstract void appendUserIdentity(StringBuffer var1);

    private void promptPresentationContext(StringBuffer sb) {
        ArrayList<PresentationContext> tmp = new ArrayList<PresentationContext>(this.pcs);
        int n = tmp.size();
        for (int i = 0; i < n; ++i) {
            sb.append("\n  ");
            tmp.get(i).toStringBuffer(sb);
        }
    }

    private void promptRoleSelection(StringBuffer sb) {
        ArrayList<RoleSelection> tmp = new ArrayList<RoleSelection>(this.roleSelMap.values());
        int n = tmp.size();
        sb.append("\n  Role Selection(").append(n).append("):");
        for (int i = 0; i < n; ++i) {
            RoleSelection rs = tmp.get(i);
            sb.append("\n    ");
            AAssociateRQAC.promptUID(rs.getSOPClassUID(), sb);
            sb.append("\n      SCU/SCP = ");
            sb.append(rs.isSCU()).append("/").append(rs.isSCP());
        }
    }

    private static void promptBytes(byte[] b, StringBuffer sb) {
        for (int i = 0; i < b.length; ++i) {
            StringUtils.byteToHex((int)b[i], (StringBuffer)sb);
            sb.append(' ');
        }
    }

    private void promptExtendedNegotiation(StringBuffer sb) {
        ArrayList<ExtendedNegotiation> tmp = new ArrayList<ExtendedNegotiation>(this.extNegMap.values());
        int n = tmp.size();
        sb.append("\n  Extended Negotiation(").append(n).append("):");
        for (int i = 0; i < n; ++i) {
            ExtendedNegotiation extNeg = tmp.get(i);
            sb.append("\n    ");
            AAssociateRQAC.promptUID(extNeg.getSOPClassUID(), sb);
            sb.append("\n      info = ");
            AAssociateRQAC.promptBytes(extNeg.getInformation(), sb);
        }
    }

    private void promptCommonExtendedNegotiation(StringBuffer sb) {
        ArrayList<CommonExtendedNegotiation> tmp = new ArrayList<CommonExtendedNegotiation>(this.commonExtNegMap.values());
        int n = tmp.size();
        sb.append("\n  Common Extended Negotiation(").append(n).append("):");
        for (int i = 0; i < n; ++i) {
            CommonExtendedNegotiation extNeg = tmp.get(i);
            sb.append("\n    ");
            AAssociateRQAC.promptUID(extNeg.getSOPClassUID(), sb);
            sb.append("\n      serviceClass = ");
            AAssociateRQAC.promptUID(extNeg.getServiceClassUID(), sb);
            ArrayList<String> uids = new ArrayList<String>(extNeg.getRelatedGeneralSOPClassUIDs());
            if (uids.isEmpty()) {
                return;
            }
            int m = uids.size();
            sb.append("\n      Related General SOP Classes(").append(m).append("):");
            for (int j = 0; j < m; ++j) {
                sb.append("\n      ");
                AAssociateRQAC.promptUID(uids.get(j), sb);
            }
        }
    }
}

