/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.rulebuilder;

import com.mirth.connect.model.Rule;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;

public class RuleBuilderRule
extends Rule {
    public static final String PLUGIN_POINT = "Rule Builder";
    private String field;
    private Condition condition;
    private List<String> values;

    public RuleBuilderRule() {
        this.field = "";
        this.condition = Condition.EXISTS;
        this.values = new ArrayList<String>();
    }

    public RuleBuilderRule(RuleBuilderRule props) {
        super((Rule)props);
        this.field = props.getField();
        this.condition = props.getCondition();
        this.values = new ArrayList<String>(props.getValues());
    }

    public String getScript(boolean loadFiles) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        String acceptReturn = "true";
        String finalReturn = "false";
        script.append("if(");
        if (this.condition == Condition.EXISTS) {
            script.append(this.field + ".length > 0) ");
        } else if (this.condition == Condition.NOT_EXIST) {
            script.append(this.field + ".length == 0) ");
        } else if (this.condition == Condition.CONTAINS || this.condition == Condition.NOT_CONTAIN) {
            String equalsOperator;
            String equals;
            if (this.condition == Condition.CONTAINS) {
                equals = "!=";
                equalsOperator = "||";
            } else {
                equals = "==";
                equalsOperator = "&&";
            }
            if (this.values.size() > 0) {
                for (int i = 0; i < this.values.size(); ++i) {
                    script.append("(" + this.field + ".indexOf(" + this.values.get(i) + ") " + equals + " -1)");
                    if (i + 1 == this.values.size()) {
                        script.append(") ");
                        continue;
                    }
                    script.append(" " + equalsOperator + " ");
                }
            } else {
                script.append(this.field + ".indexOf(\"\") " + equals + " -1) ");
            }
        } else {
            String equalsOperator;
            String equals;
            if (this.condition == Condition.EQUALS) {
                equals = "==";
                equalsOperator = "||";
            } else {
                equals = "!=";
                equalsOperator = "&&";
            }
            if (this.values.size() > 0) {
                for (int i = 0; i < this.values.size(); ++i) {
                    script.append(this.field + " " + equals + " " + this.values.get(i));
                    if (i + 1 == this.values.size()) {
                        script.append(") ");
                        continue;
                    }
                    script.append(" " + equalsOperator + " ");
                }
            } else {
                script.append(this.field + " " + equals + " \"\") ");
            }
        }
        script.append("{\n");
        script.append("\treturn " + acceptReturn + ";");
        script.append("\n}\n");
        script.append("return " + finalReturn + ";");
        return script.toString();
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public String getType() {
        return PLUGIN_POINT;
    }

    public Rule clone() {
        return new RuleBuilderRule(this);
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("condition", this.condition);
        if (this.values != null) {
            purgedProperties.put("valuesCount", this.values.size());
        }
        return purgedProperties;
    }

    public static enum Condition {
        EXISTS(false, "exists"),
        NOT_EXIST(false, "does not exist"),
        EQUALS(true, "equals"),
        NOT_EQUAL(true, "does not equal"),
        CONTAINS(true, "contains"),
        NOT_CONTAIN(true, "does not contain");

        private boolean valuesEnabled;
        private String presentTense;

        private Condition(boolean valuesEnabled, String presentTense) {
            this.valuesEnabled = valuesEnabled;
            this.presentTense = presentTense;
        }

        public boolean isValuesEnabled() {
            return this.valuesEnabled;
        }

        public String getPresentTense() {
            return this.presentTense;
        }

        public String toString() {
            return WordUtils.capitalizeFully((String)super.toString().replace('_', ' '));
        }
    }
}

