/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import ij.util.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class TiffDecoder {
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTO_INTERP = 262;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNT = 279;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int RESOLUTION_UNIT = 296;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int PREDICTOR = 317;
    public static final int COLOR_MAP = 320;
    public static final int SAMPLE_FORMAT = 339;
    public static final int JPEG_TABLES = 347;
    public static final int METAMORPH1 = 33628;
    public static final int METAMORPH2 = 33629;
    public static final int IPLAB = 34122;
    public static final int NIH_IMAGE_HDR = 43314;
    public static final int META_DATA_BYTE_COUNTS = 50838;
    public static final int META_DATA = 50839;
    static final int UNSIGNED = 1;
    static final int SIGNED = 2;
    static final int FLOATING_POINT = 3;
    static final int SHORT = 3;
    static final int LONG = 4;
    static final int MAGIC_NUMBER = 0x494A494A;
    static final int INFO = 1768842863;
    static final int LABELS = 1818321516;
    static final int RANGES = 1918987879;
    static final int LUTS = 1819636851;
    private String directory;
    private String name;
    private String url;
    protected RandomAccessStream in;
    protected boolean debugMode;
    private boolean littleEndian;
    private String dInfo;
    private int ifdCount;
    private int[] metaDataCounts;

    public TiffDecoder(String directory, String name) {
        this.directory = directory;
        this.name = name;
    }

    public TiffDecoder(InputStream in, String name) {
        this.directory = "";
        this.name = name;
        this.url = "";
        this.in = new RandomAccessStream(in);
    }

    final int getInt() throws IOException {
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        int b4 = this.in.read();
        if (this.littleEndian) {
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    final int getShort() throws IOException {
        int b1 = this.in.read();
        int b2 = this.in.read();
        if (this.littleEndian) {
            return (b2 << 8) + b1;
        }
        return (b1 << 8) + b2;
    }

    final long readLong() throws IOException {
        if (this.littleEndian) {
            return ((long)this.getInt() & 0xFFFFFFFFL) + ((long)this.getInt() << 32);
        }
        return ((long)this.getInt() << 32) + ((long)this.getInt() & 0xFFFFFFFFL);
    }

    final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    int OpenImageFileHeader() throws IOException {
        short byteOrder = this.in.readShort();
        if (byteOrder == 18761) {
            this.littleEndian = true;
        } else if (byteOrder == 19789) {
            this.littleEndian = false;
        } else {
            this.in.close();
            return -1;
        }
        int magicNumber = this.getShort();
        int offset = this.getInt();
        return offset;
    }

    int getValue(int fieldType, int count) throws IOException {
        int value = 0;
        if (fieldType == 3 && count == 1) {
            value = this.getShort();
            int unused = this.getShort();
        } else {
            value = this.getInt();
        }
        return value;
    }

    void getColorMap(int offset, FileInfo fi) throws IOException {
        byte[] colorTable16 = new byte[1536];
        long saveLoc = this.in.getLongFilePointer();
        this.in.seek(offset);
        this.in.readFully(colorTable16);
        this.in.seek(saveLoc);
        fi.lutSize = 256;
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        int j = 0;
        if (this.littleEndian) {
            ++j;
        }
        for (int i = 0; i < 256; ++i) {
            fi.reds[i] = colorTable16[j];
            fi.greens[i] = colorTable16[512 + j];
            fi.blues[i] = colorTable16[1024 + j];
            j += 2;
        }
        fi.fileType = 5;
    }

    byte[] getString(int count, int offset) throws IOException {
        if (--count <= 0) {
            return null;
        }
        byte[] bytes = new byte[count];
        long saveLoc = this.in.getLongFilePointer();
        this.in.seek(offset);
        this.in.readFully(bytes);
        this.in.seek(saveLoc);
        return bytes;
    }

    public void saveImageDescription(byte[] description, FileInfo fi) {
        String images;
        int n;
        int index2;
        String id;
        if (description.length < 7) {
            return;
        }
        fi.description = id = new String(description);
        int index1 = id.indexOf("images=");
        if (index1 > 0 && (index2 = id.indexOf("\n", index1)) > 0 && (n = (int)Tools.parseDouble(images = id.substring(index1 + 7, index2), 0.0)) > 1) {
            fi.nImages = n;
        }
    }

    void decodeNIHImageHeader(int offset, FileInfo fi) throws IOException {
        long saveLoc = this.in.getLongFilePointer();
        this.in.seek(offset + 12);
        short version = this.in.readShort();
        this.in.seek(offset + 160);
        double scale = this.in.readDouble();
        if (version > 106 && scale != 0.0) {
            fi.pixelHeight = fi.pixelWidth = 1.0 / scale;
        }
        this.in.seek(offset + 172);
        int units = this.in.readShort();
        if (version <= 153) {
            units += 5;
        }
        switch (units) {
            case 5: {
                fi.unit = "nanometer";
                break;
            }
            case 6: {
                fi.unit = "micrometer";
                break;
            }
            case 7: {
                fi.unit = "mm";
                break;
            }
            case 8: {
                fi.unit = "cm";
                break;
            }
            case 9: {
                fi.unit = "meter";
                break;
            }
            case 10: {
                fi.unit = "km";
                break;
            }
            case 11: {
                fi.unit = "inch";
                break;
            }
            case 12: {
                fi.unit = "ft";
                break;
            }
            case 13: {
                fi.unit = "mi";
            }
        }
        this.in.seek(offset + 182);
        int fitType = this.in.read();
        int unused = this.in.read();
        int nCoefficients = this.in.readShort();
        if (fitType == 11) {
            fi.calibrationFunction = 21;
            fi.valueUnit = "U. OD";
        } else if (fitType >= 0 && fitType <= 8 && nCoefficients >= 1 && nCoefficients <= 5) {
            switch (fitType) {
                case 0: {
                    fi.calibrationFunction = 0;
                    break;
                }
                case 1: {
                    fi.calibrationFunction = 1;
                    break;
                }
                case 2: {
                    fi.calibrationFunction = 2;
                    break;
                }
                case 3: {
                    fi.calibrationFunction = 3;
                    break;
                }
                case 5: {
                    fi.calibrationFunction = 4;
                    break;
                }
                case 6: {
                    fi.calibrationFunction = 5;
                    break;
                }
                case 7: {
                    fi.calibrationFunction = 6;
                    break;
                }
                case 8: {
                    fi.calibrationFunction = 10;
                }
            }
            fi.coefficients = new double[nCoefficients];
            for (int i = 0; i < nCoefficients; ++i) {
                fi.coefficients[i] = this.in.readDouble();
            }
            this.in.seek(offset + 234);
            int size = this.in.read();
            StringBuffer sb = new StringBuffer();
            if (size >= 1 && size <= 16) {
                for (int i = 0; i < size; ++i) {
                    sb.append((char)this.in.read());
                }
                fi.valueUnit = new String(sb);
            } else {
                fi.valueUnit = " ";
            }
        }
        this.in.seek(offset + 260);
        short nImages = this.in.readShort();
        if (nImages >= 2 && (fi.fileType == 0 || fi.fileType == 5)) {
            fi.nImages = nImages;
            fi.pixelDepth = this.in.readFloat();
            short skip = this.in.readShort();
            fi.frameInterval = this.in.readFloat();
        }
        this.in.seek(offset + 272);
        float aspectRatio = this.in.readFloat();
        if (version > 140 && (double)aspectRatio != 0.0) {
            fi.pixelHeight = fi.pixelWidth / (double)aspectRatio;
        }
        this.in.seek(saveLoc);
    }

    void dumpTag(int tag, int count, int value, FileInfo fi) {
        String name;
        switch (tag) {
            case 254: {
                name = "NewSubfileType";
                break;
            }
            case 256: {
                name = "ImageWidth";
                break;
            }
            case 257: {
                name = "ImageLength";
                break;
            }
            case 273: {
                name = "StripOffsets";
                break;
            }
            case 274: {
                name = "Orientation";
                break;
            }
            case 262: {
                name = "PhotoInterp";
                break;
            }
            case 270: {
                name = "ImageDescription";
                break;
            }
            case 258: {
                name = "BitsPerSample";
                break;
            }
            case 277: {
                name = "SamplesPerPixel";
                break;
            }
            case 278: {
                name = "RowsPerStrip";
                break;
            }
            case 279: {
                name = "StripByteCount";
                break;
            }
            case 282: {
                name = "XResolution";
                break;
            }
            case 283: {
                name = "YResolution";
                break;
            }
            case 296: {
                name = "ResolutionUnit";
                break;
            }
            case 305: {
                name = "Software";
                break;
            }
            case 306: {
                name = "DateTime";
                break;
            }
            case 284: {
                name = "PlanarConfiguration";
                break;
            }
            case 259: {
                name = "Compression";
                break;
            }
            case 317: {
                name = "Predictor";
                break;
            }
            case 320: {
                name = "ColorMap";
                break;
            }
            case 339: {
                name = "SampleFormat";
                break;
            }
            case 347: {
                name = "JPEGTables";
                break;
            }
            case 43314: {
                name = "NIHImageHeader";
                break;
            }
            case 50838: {
                name = "MetaDataByteCounts";
                break;
            }
            case 50839: {
                name = "MetaData";
                break;
            }
            default: {
                name = "???";
            }
        }
        String cs = count == 1 ? "" : ", count=" + count;
        this.dInfo = this.dInfo + "    " + tag + ", \"" + name + "\", value=" + value + cs + "\n";
    }

    double getRational(int loc) throws IOException {
        long saveLoc = this.in.getLongFilePointer();
        this.in.seek(loc);
        int numerator = this.getInt();
        int denominator = this.getInt();
        this.in.seek(saveLoc);
        if (denominator != 0) {
            return (double)numerator / (double)denominator;
        }
        return 0.0;
    }

    FileInfo OpenIFD() throws IOException {
        int nEntries = this.getShort();
        if (nEntries < 1 || nEntries > 1000) {
            return null;
        }
        ++this.ifdCount;
        FileInfo fi = new FileInfo();
        block26: for (int i = 0; i < nEntries; ++i) {
            int tag = this.getShort();
            int fieldType = this.getShort();
            int count = this.getInt();
            int value = this.getValue(fieldType, count);
            if (this.debugMode && this.ifdCount < 10) {
                this.dumpTag(tag, count, value, fi);
            }
            switch (tag) {
                case 256: {
                    fi.width = value;
                    fi.intelByteOrder = this.littleEndian;
                    continue block26;
                }
                case 257: {
                    fi.height = value;
                    continue block26;
                }
                case 273: {
                    if (count == 1) {
                        fi.stripOffsets = new int[]{value};
                    } else {
                        long saveLoc = this.in.getLongFilePointer();
                        this.in.seek(value);
                        fi.stripOffsets = new int[count];
                        for (int c = 0; c < count; ++c) {
                            fi.stripOffsets[c] = this.getInt();
                            if (c <= 0 || fi.stripOffsets[c] >= fi.stripOffsets[c - 1] || fi.stripOffsets[c] == 0) continue;
                            this.error("Strip offsets are not in order");
                        }
                        this.in.seek(saveLoc);
                    }
                    fi.offset = count > 0 ? fi.stripOffsets[0] : value;
                    continue block26;
                }
                case 279: {
                    if (count == 1) {
                        fi.stripLengths = new int[]{value};
                        continue block26;
                    }
                    long saveLoc = this.in.getLongFilePointer();
                    this.in.seek(value);
                    fi.stripLengths = new int[count];
                    for (int c = 0; c < count; ++c) {
                        fi.stripLengths[c] = this.getInt();
                    }
                    this.in.seek(saveLoc);
                    continue block26;
                }
                case 262: {
                    fi.whiteIsZero = value == 0;
                    continue block26;
                }
                case 258: {
                    if (count == 1) {
                        if (value == 8) {
                            fi.fileType = 0;
                            continue block26;
                        }
                        if (value == 16) {
                            fi.fileType = 2;
                            continue block26;
                        }
                        if (value == 32) {
                            fi.fileType = 3;
                            continue block26;
                        }
                        if (value == 12) {
                            fi.fileType = 13;
                            continue block26;
                        }
                        if (value == 1) {
                            fi.fileType = 8;
                            continue block26;
                        }
                        this.error("Unsupported BitsPerSample: " + value);
                        continue block26;
                    }
                    if (count != 3) continue block26;
                    long saveLoc = this.in.getLongFilePointer();
                    this.in.seek(value);
                    int bitDepth = this.getShort();
                    if (bitDepth != 8 && bitDepth != 16) {
                        this.error("ImageJ can only open 8 and 16 bit/channel RGB images (" + bitDepth + ")");
                    }
                    if (bitDepth == 16) {
                        fi.fileType = 12;
                    }
                    this.in.seek(saveLoc);
                    continue block26;
                }
                case 277: {
                    fi.samplesPerPixel = value;
                    if (value != 3 || fi.fileType == 12) continue block26;
                    fi.fileType = fi.fileType == 2 ? 12 : 6;
                    continue block26;
                }
                case 278: {
                    fi.rowsPerStrip = value;
                    continue block26;
                }
                case 282: {
                    double xScale = this.getRational(value);
                    if (xScale == 0.0) continue block26;
                    fi.pixelWidth = 1.0 / xScale;
                    continue block26;
                }
                case 283: {
                    double yScale = this.getRational(value);
                    if (yScale == 0.0) continue block26;
                    fi.pixelHeight = 1.0 / yScale;
                    continue block26;
                }
                case 296: {
                    if (value == 1 && fi.unit == null) {
                        fi.unit = " ";
                        continue block26;
                    }
                    if (value == 2) {
                        if (fi.pixelWidth == 0.013888888888888888) {
                            fi.pixelWidth = 1.0;
                            fi.pixelHeight = 1.0;
                            continue block26;
                        }
                        fi.unit = "inch";
                        continue block26;
                    }
                    if (value != 3) continue block26;
                    fi.unit = "cm";
                    continue block26;
                }
                case 284: {
                    if (value == 2 && fi.fileType == 12) {
                        fi.fileType = 2;
                        continue block26;
                    }
                    if (value == 2 && fi.fileType == 6) {
                        fi.fileType = 7;
                        continue block26;
                    }
                    if (value == 1 && fi.samplesPerPixel == 4) {
                        fi.fileType = 9;
                        continue block26;
                    }
                    if (value == 2 || fi.samplesPerPixel == 1 || fi.samplesPerPixel == 3) continue block26;
                    String msg = "Unsupported interleaved SamplesPerPixel: " + fi.samplesPerPixel;
                    this.error(msg);
                    continue block26;
                }
                case 259: {
                    if (value == 5) {
                        int bpp = fi.getBytesPerPixel();
                        if (bpp == 6) {
                            this.error("ImageJ cannot open 48-bit LZW compressed TIFFs");
                        }
                        fi.compression = 2;
                        continue block26;
                    }
                    if (value == 32773) {
                        fi.compression = 5;
                        continue block26;
                    }
                    if (value == 1 || value == 7 && fi.width < 500) continue block26;
                    fi.compression = 0;
                    this.error("ImageJ cannot open TIFF files compressed in this fashion (" + value + ")");
                    continue block26;
                }
                case 317: {
                    if (value != 2 || fi.compression != 2) continue block26;
                    fi.compression = 3;
                    continue block26;
                }
                case 320: {
                    if (count != 768) continue block26;
                    if (fi.fileType != 0) continue block26;
                    this.getColorMap(value, fi);
                    continue block26;
                }
                case 339: {
                    if (fi.fileType == 3 && value == 3) {
                        fi.fileType = 4;
                    }
                    if (fi.fileType != 2) continue block26;
                    if (value == 2) {
                        fi.fileType = 1;
                    }
                    if (value != 3) continue block26;
                    this.error("ImageJ cannot open16-bit float TIFFs");
                    continue block26;
                }
                case 347: {
                    if (fi.compression != 4) continue block26;
                    this.error("Cannot open JPEG-compressed TIFFs with separate tables");
                    continue block26;
                }
                case 270: {
                    byte[] s;
                    if (this.ifdCount != 1 || (s = this.getString(count, value)) == null) continue block26;
                    this.saveImageDescription(s, fi);
                    continue block26;
                }
                case 274: {
                    fi.nImages = 0;
                    continue block26;
                }
                case 33628: 
                case 33629: {
                    if (this.name.indexOf(".STK") <= 0 && this.name.indexOf(".stk") <= 0 || fi.compression != 1) continue block26;
                    if (tag == 33629) {
                        fi.nImages = count;
                        continue block26;
                    }
                    fi.nImages = 9999;
                    continue block26;
                }
                case 34122: {
                    fi.nImages = value;
                    continue block26;
                }
                case 43314: {
                    if (count != 256) continue block26;
                    this.decodeNIHImageHeader(value, fi);
                    continue block26;
                }
                case 50838: {
                    long saveLoc = this.in.getLongFilePointer();
                    this.in.seek(value);
                    this.metaDataCounts = new int[count];
                    for (int c = 0; c < count; ++c) {
                        this.metaDataCounts[c] = this.getInt();
                    }
                    this.in.seek(saveLoc);
                    continue block26;
                }
                case 50839: {
                    this.getMetaData(value, fi);
                    continue block26;
                }
                default: {
                    if (tag <= 10000 || tag >= 32768 || this.ifdCount <= 1) continue block26;
                    return null;
                }
            }
        }
        fi.fileFormat = 2;
        fi.fileName = this.name;
        fi.directory = this.directory;
        if (this.url != null) {
            fi.url = this.url;
        }
        return fi;
    }

    void getMetaData(int loc, FileInfo fi) throws IOException {
        if (this.metaDataCounts == null || this.metaDataCounts.length == 0) {
            return;
        }
        int maxTypes = 10;
        long saveLoc = this.in.getLongFilePointer();
        this.in.seek(loc);
        int n = this.metaDataCounts.length;
        int hdrSize = this.metaDataCounts[0];
        if (hdrSize < 12 || hdrSize > 804) {
            this.in.seek(saveLoc);
            return;
        }
        int magicNumber = this.getInt();
        if (magicNumber != 0x494A494A) {
            this.in.seek(saveLoc);
            return;
        }
        int nTypes = (hdrSize - 4) / 8;
        int[] types = new int[nTypes];
        int[] counts = new int[nTypes];
        if (this.debugMode) {
            this.dInfo = this.dInfo + "Metadata:\n";
        }
        int extraMetaDataEntries = 0;
        for (int i = 0; i < nTypes; ++i) {
            types[i] = this.getInt();
            counts[i] = this.getInt();
            if (types[i] < 0xFFFFFF) {
                extraMetaDataEntries += counts[i];
            }
            if (!this.debugMode) continue;
            String id = "";
            if (types[i] == 1768842863) {
                id = " (Info property)";
            }
            if (types[i] == 1818321516) {
                id = " (slice labels)";
            }
            if (types[i] == 1918987879) {
                id = " (display ranges)";
            }
            if (types[i] == 1819636851) {
                id = " (luts)";
            }
            this.dInfo = this.dInfo + "   " + i + " " + Integer.toHexString(types[i]) + " " + counts[i] + id + "\n";
        }
        fi.metaDataTypes = new int[extraMetaDataEntries];
        fi.metaData = new byte[extraMetaDataEntries][];
        int start = 1;
        int eMDindex = 0;
        for (int i = 0; i < nTypes; ++i) {
            if (types[i] == 1768842863) {
                this.getInfoProperty(start, fi);
            } else if (types[i] == 1818321516) {
                this.getSliceLabels(start, start + counts[i] - 1, fi);
            } else if (types[i] == 1918987879) {
                this.getDisplayRanges(start, fi);
            } else if (types[i] == 1819636851) {
                this.getLuts(start, start + counts[i] - 1, fi);
            } else if (types[i] < 0xFFFFFF) {
                for (int j = start; j < start + counts[i]; ++j) {
                    int len = this.metaDataCounts[j];
                    fi.metaData[eMDindex] = new byte[len];
                    this.in.readFully(fi.metaData[eMDindex], len);
                    fi.metaDataTypes[eMDindex] = types[i];
                    ++eMDindex;
                }
            } else {
                this.skipUnknownType(start, start + counts[i] - 1);
            }
            start += counts[i];
        }
        this.in.seek(saveLoc);
    }

    void getInfoProperty(int first, FileInfo fi) throws IOException {
        int len = this.metaDataCounts[first];
        byte[] buffer = new byte[len];
        this.in.readFully(buffer, len);
        char[] chars = new char[len /= 2];
        if (this.littleEndian) {
            int k = 0;
            for (int j = 0; j < len; ++j) {
                chars[j] = (char)(buffer[k++] & 255 + ((buffer[k++] & 0xFF) << 8));
            }
        } else {
            int k = 0;
            for (int j = 0; j < len; ++j) {
                chars[j] = (char)(((buffer[k++] & 0xFF) << 8) + buffer[k++] & 0xFF);
            }
        }
        fi.info = new String(chars);
    }

    void getSliceLabels(int first, int last, FileInfo fi) throws IOException {
        fi.sliceLabels = new String[last - first + 1];
        int index = 0;
        byte[] buffer = new byte[this.metaDataCounts[first]];
        for (int i = first; i <= last; ++i) {
            int len = this.metaDataCounts[i];
            if (len > 0) {
                int j;
                int k;
                if (len > buffer.length) {
                    buffer = new byte[len];
                }
                this.in.readFully(buffer, len);
                char[] chars = new char[len /= 2];
                if (this.littleEndian) {
                    k = 0;
                    for (j = 0; j < len; ++j) {
                        chars[j] = (char)(buffer[k++] & 255 + ((buffer[k++] & 0xFF) << 8));
                    }
                } else {
                    k = 0;
                    for (j = 0; j < len; ++j) {
                        chars[j] = (char)(((buffer[k++] & 0xFF) << 8) + buffer[k++] & 0xFF);
                    }
                }
                fi.sliceLabels[index++] = new String(chars);
                continue;
            }
            fi.sliceLabels[index++] = null;
        }
    }

    void getDisplayRanges(int first, FileInfo fi) throws IOException {
        int n = this.metaDataCounts[first] / 8;
        fi.displayRanges = new double[n];
        for (int i = 0; i < n; ++i) {
            fi.displayRanges[i] = this.readDouble();
        }
    }

    void getLuts(int first, int last, FileInfo fi) throws IOException {
        fi.channelLuts = new byte[last - first + 1][];
        int index = 0;
        for (int i = first; i <= last; ++i) {
            int len = this.metaDataCounts[i];
            fi.channelLuts[index] = new byte[len];
            this.in.readFully(fi.channelLuts[index], len);
            ++index;
        }
    }

    void error(String message) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        throw new IOException(message);
    }

    void skipUnknownType(int first, int last) throws IOException {
        byte[] buffer = new byte[this.metaDataCounts[first]];
        for (int i = first; i <= last; ++i) {
            int len = this.metaDataCounts[i];
            if (len > buffer.length) {
                buffer = new byte[len];
            }
            this.in.readFully(buffer, len);
        }
    }

    public void enableDebugging() {
        this.debugMode = true;
    }

    public FileInfo[] getTiffInfo() throws IOException {
        FileInfo[] fi;
        if (this.in == null) {
            this.in = new RandomAccessStream(new RandomAccessFile(this.directory + this.name, "r"));
        }
        Vector<FileInfo[]> info = new Vector<FileInfo[]>();
        int ifdOffset = this.OpenImageFileHeader();
        if (ifdOffset < 0) {
            this.in.close();
            return null;
        }
        if (this.debugMode) {
            this.dInfo = "\n  " + this.name + ": opening\n";
        }
        while (ifdOffset > 0) {
            this.in.seek(ifdOffset);
            fi = this.OpenIFD();
            if (fi != null) {
                info.addElement(fi);
                ifdOffset = this.getInt();
            } else {
                ifdOffset = 0;
            }
            if (this.debugMode && this.ifdCount < 10) {
                this.dInfo = this.dInfo + "  nextIFD=" + ifdOffset + "\n";
            }
            if (fi == null || fi.nImages <= 1) continue;
            ifdOffset = 0;
        }
        if (info.size() == 0) {
            this.in.close();
            return null;
        }
        fi = new FileInfo[info.size()];
        info.copyInto(fi);
        if (this.debugMode) {
            fi[0].debugInfo = this.dInfo;
        }
        if (this.url != null) {
            this.in.seek(0);
            fi[0].inputStream = this.in;
        } else {
            this.in.close();
        }
        return fi;
    }
}

