/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;

public class RGBStackMerge
implements PlugIn {
    private static boolean createComposite = true;
    private ImagePlus imp;
    private byte[] blank;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public void mergeStacks() {
        ImagePlus imp2;
        int i;
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        for (int i2 = 0; i2 < wList.length; ++i2) {
            ImagePlus imp = WindowManager.getImage(wList[i2]);
            titles[i2] = imp != null ? imp.getTitle() : "";
        }
        titles[wList.length] = none = "*None*";
        GenericDialog gd = new GenericDialog("Color Merge");
        gd.addChoice("Red:", titles, titles[0]);
        gd.addChoice("Green:", titles, titles[1]);
        String title3 = titles.length > 2 ? titles[2] : none;
        gd.addChoice("Blue:", titles, title3);
        String title4 = titles.length > 3 ? titles[3] : none;
        gd.addChoice("Gray:", titles, title4);
        gd.addCheckbox("Create Composite", createComposite);
        gd.addCheckbox("Keep Source Images", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex(), gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        createComposite = gd.getNextBoolean();
        boolean keep = gd.getNextBoolean();
        ImagePlus[] image = new ImagePlus[4];
        int stackSize = 0;
        int width = 0;
        int height = 0;
        int bitDepth = 0;
        for (i = 0; i < 4; ++i) {
            if (index[i] >= wList.length) continue;
            image[i] = WindowManager.getImage(wList[index[i]]);
            width = image[i].getWidth();
            height = image[i].getHeight();
            stackSize = image[i].getStackSize();
            bitDepth = image[i].getBitDepth();
        }
        if (width == 0) {
            IJ.error("Merge Channels", "There must be at least one source image or stack.");
            return;
        }
        for (i = 0; i < 4; ++i) {
            ImagePlus img = image[i];
            if (img == null) continue;
            if (img.getStackSize() != stackSize) {
                IJ.error("Merge Channels", "The source stacks must all have the same number of slices.");
                return;
            }
            if (img.isHyperStack()) {
                CompositeImage ci;
                if (img.isComposite() && (ci = (CompositeImage)img).getMode() != 1) {
                    ci.setMode(1);
                    img.updateAndDraw();
                    if (!IJ.isMacro()) {
                        IJ.run("Channels Tool...");
                    }
                    return;
                }
                IJ.error("Merge Channels", "Source stacks cannot be hyperstacks.");
                return;
            }
            if (img.getWidth() != width || image[i].getHeight() != height) {
                IJ.error("Merge Channels", "The source images or stacks must have the same width and height.");
                return;
            }
            if (createComposite) {
                for (int j = 0; j < 4; ++j) {
                    if (j == i || image[j] == null || img != image[j]) continue;
                    createComposite = false;
                }
            }
            if (!createComposite || img.getBitDepth() == bitDepth) continue;
            IJ.error("Merge Channels (Composite)", "The source images must all have the same bit depth.");
            return;
        }
        ImageStack red = image[0] != null ? image[0].getStack() : null;
        ImageStack green = image[1] != null ? image[1].getStack() : null;
        ImageStack blue = image[2] != null ? image[2].getStack() : null;
        ImageStack gray = image[3] != null ? image[3].getStack() : null;
        String options = Macro.getOptions();
        if (options != null && options.indexOf("gray=") == -1) {
            gray = null;
        }
        if (gray != null) {
            createComposite = true;
        }
        for (int i3 = 0; i3 < 4; ++i3) {
            if (image[i3] == null || image[i3].getBitDepth() != 24) continue;
            createComposite = false;
        }
        if (createComposite) {
            ImageStack[] stacks = new ImageStack[]{red, green, blue, gray};
            imp2 = this.createComposite(width, height, stackSize, stacks, keep);
            if (imp2 == null) {
                return;
            }
        } else {
            ImageStack rgb = this.mergeStacks(width, height, stackSize, red, green, blue, keep);
            imp2 = new ImagePlus("RGB", rgb);
        }
        if (image[0] != null) {
            imp2.setCalibration(image[0].getCalibration());
        }
        if (!keep) {
            for (int i4 = 0; i4 < 4; ++i4) {
                if (image[i4] == null) continue;
                image[i4].changes = false;
                image[i4].close();
            }
        }
        imp2.show();
    }

    public ImagePlus createComposite(int w, int h, int d, ImageStack[] stacks, boolean keep) {
        int i;
        ImageStack composite = new ImageStack(w, h);
        int n = stacks.length;
        int[] index = new int[n];
        int channels = 0;
        boolean customColors = false;
        for (i = 0; i < n; ++i) {
            index[i] = 1;
            if (stacks[i] == null) continue;
            ++channels;
            if (i <= 0 || stacks[i - 1] != null) continue;
            customColors = true;
        }
        if (channels < 2) {
            IJ.error("Merge Channels", "At least 2 channels required");
            return null;
        }
        for (i = 0; i < d; ++i) {
            for (int j = 0; j < n; ++j) {
                if (stacks[j] == null) continue;
                ImageProcessor ip = stacks[j].getProcessor(index[j]);
                if (keep) {
                    ip = ip.duplicate();
                }
                composite.addSlice(null, ip);
                if (keep) {
                    int n2 = j;
                    index[n2] = index[n2] + 1;
                    continue;
                }
                if (stacks[j] == null) continue;
                stacks[j].deleteSlice(1);
            }
        }
        ImagePlus imp2 = new ImagePlus("Composite", composite);
        imp2.setDimensions(channels, d, 1);
        imp2 = new CompositeImage(imp2, 1);
        if (customColors) {
            Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.white};
            CompositeImage ci = (CompositeImage)imp2;
            int color = 0;
            int c = 1;
            for (int i2 = 0; i2 < n; ++i2) {
                if (stacks[i2] != null && c <= n) {
                    ci.setPosition(c, 1, 1);
                    LUT lut = ci.createLutFromColor(colors[color]);
                    ci.setChannelLut(lut);
                    ++c;
                }
                ++color;
            }
            ci.setPosition(1, 1, 1);
        }
        if (d > 1) {
            imp2.setOpenAsHyperStack(true);
        }
        return imp2;
    }

    public ImageStack mergeStacks(int w, int h, int d, ImageStack red, ImageStack green, ImageStack blue, boolean keep) {
        ImageStack rgb = new ImageStack(w, h);
        int inc = d / 10;
        if (inc < 1) {
            inc = 1;
        }
        int slice = 1;
        this.blank = new byte[w * h];
        boolean invertedRed = red != null ? red.getProcessor(1).isInvertedLut() : false;
        boolean invertedGreen = green != null ? green.getProcessor(1).isInvertedLut() : false;
        boolean invertedBlue = blue != null ? blue.getProcessor(1).isInvertedLut() : false;
        try {
            for (int i = 1; i <= d; ++i) {
                ColorProcessor cp = new ColorProcessor(w, h);
                byte[] redPixels = this.getPixels(red, slice, 0);
                byte[] greenPixels = this.getPixels(green, slice, 1);
                byte[] bluePixels = this.getPixels(blue, slice, 2);
                if (invertedRed) {
                    redPixels = this.invert(redPixels);
                }
                if (invertedGreen) {
                    greenPixels = this.invert(greenPixels);
                }
                if (invertedBlue) {
                    bluePixels = this.invert(bluePixels);
                }
                cp.setRGB(redPixels, greenPixels, bluePixels);
                if (keep) {
                    ++slice;
                } else {
                    if (red != null) {
                        red.deleteSlice(1);
                    }
                    if (green != null && green != red) {
                        green.deleteSlice(1);
                    }
                    if (blue != null && blue != red && blue != green) {
                        blue.deleteSlice(1);
                    }
                }
                rgb.addSlice(null, cp);
                if (i % inc != 0) continue;
                IJ.showProgress((double)i / (double)d);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return rgb;
    }

    byte[] getPixels(ImageStack stack, int slice, int color) {
        if (stack == null) {
            return this.blank;
        }
        Object pixels = stack.getPixels(slice);
        if (!(pixels instanceof int[])) {
            if (pixels instanceof byte[]) {
                return (byte[])pixels;
            }
            ImageProcessor ip = stack.getProcessor(slice);
            ip = ip.convertToByte(true);
            return (byte[])ip.getPixels();
        }
        int size = stack.getWidth() * stack.getHeight();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ColorProcessor cp = (ColorProcessor)stack.getProcessor(slice);
        cp.getRGB(r, g, b);
        switch (color) {
            case 0: {
                return r;
            }
            case 1: {
                return g;
            }
            case 2: {
                return b;
            }
        }
        return null;
    }

    byte[] invert(byte[] pixels) {
        byte[] pixels2 = new byte[pixels.length];
        System.arraycopy(pixels, 0, pixels2, 0, pixels.length);
        for (int i = 0; i < pixels2.length; ++i) {
            pixels2[i] = (byte)(255 - pixels2[i] & 0xFF);
        }
        return pixels2;
    }
}

