/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.connectors.http.BinaryContentTypeResolver;
import com.mirth.connect.connectors.http.HttpRequestMessage;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.DonkeyElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class HttpMessageConverter {
    private static Logger logger = LogManager.getLogger(HttpMessageConverter.class);
    private static BinaryContentTypeResolver defaultResolver = new BinaryContentTypeResolver(){

        @Override
        public boolean isBinaryContentType(ContentType contentType) {
            return StringUtils.startsWithAny((CharSequence)contentType.getMimeType(), (CharSequence[])new String[]{"application/", "image/", "video/", "audio/"});
        }
    };

    public static String httpRequestToXml(HttpRequestMessage request, boolean parseMultipart, boolean includeMetadata, BinaryContentTypeResolver resolver) {
        try {
            Document document = HttpMessageConverter.getDocument();
            DonkeyElement requestElement = new DonkeyElement(document.createElement("HttpRequest"));
            if (includeMetadata) {
                requestElement.addChildElement("RemoteAddress", request.getRemoteAddress());
                requestElement.addChildElement("RequestUrl", request.getRequestUrl());
                requestElement.addChildElement("Method", request.getMethod());
                requestElement.addChildElement("RequestPath", request.getQueryString());
                requestElement.addChildElement("RequestContextPath", request.getContextPath());
                if (!request.getParameters().isEmpty()) {
                    DonkeyElement parametersElement = requestElement.addChildElement("Parameters");
                    for (Map.Entry<String, List<String>> entry : request.getParameters().entrySet()) {
                        for (String value : entry.getValue()) {
                            parametersElement.addChildElement(entry.getKey(), value);
                        }
                    }
                }
                DonkeyElement headerElement = requestElement.addChildElement("Header");
                for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
                    for (String value : entry.getValue()) {
                        headerElement.addChildElement(entry.getKey(), value);
                    }
                }
            }
            HttpMessageConverter.processContent(requestElement.addChildElement("Content"), request.getContent(), request.getContentType(), parseMultipart, resolver);
            return requestElement.toXml();
        }
        catch (Exception e) {
            logger.error("Error converting HTTP request.", (Throwable)e);
            return null;
        }
    }

    public static String contentToXml(Object content, ContentType contentType, boolean parseMultipart, BinaryContentTypeResolver resolver) throws DonkeyElement.DonkeyElementException, MessagingException, IOException, ParserConfigurationException {
        DonkeyElement contentElement = new DonkeyElement("<Content/>");
        HttpMessageConverter.processContent(contentElement, content, contentType, parseMultipart, resolver);
        return contentElement.toXml();
    }

    private static void processContent(DonkeyElement contentElement, Object content, ContentType contentType, boolean parseMultipart, BinaryContentTypeResolver resolver) throws DonkeyElement.DonkeyElementException, MessagingException, IOException {
        if (resolver == null) {
            resolver = defaultResolver;
        }
        if (parseMultipart && content instanceof MimeMultipart) {
            contentElement.setAttribute("multipart", "yes");
            MimeMultipart multipart = (MimeMultipart)content;
            String boundary = contentType.getParameter("boundary");
            if (StringUtils.isNotBlank((CharSequence)boundary)) {
                contentElement.setAttribute("boundary", boundary);
            }
            if (StringUtils.isNotEmpty((CharSequence)multipart.getPreamble())) {
                contentElement.addChildElement("Preamble", multipart.getPreamble());
            }
            for (int partIndex = 0; partIndex < multipart.getCount(); ++partIndex) {
                BodyPart part = multipart.getBodyPart(partIndex);
                DonkeyElement partElement = contentElement.addChildElement("Part");
                DonkeyElement headersElement = partElement.addChildElement("Headers");
                ContentType partContentType = contentType;
                Enumeration en = part.getAllHeaders();
                while (en.hasMoreElements()) {
                    Header header = (Header)en.nextElement();
                    headersElement.addChildElement(header.getName(), header.getValue());
                    if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                    try {
                        partContentType = ContentType.parse((String)header.getValue());
                    }
                    catch (RuntimeException runtimeException) {}
                }
                HttpMessageConverter.processContent(partElement.addChildElement("Content"), part.getContent(), partContentType, true, resolver);
            }
        } else {
            contentElement.setAttribute("multipart", "no");
            String charset = HttpMessageConverter.getDefaultHttpCharset(contentType.getCharset() != null ? contentType.getCharset().name() : null);
            if (resolver.isBinaryContentType(contentType)) {
                contentElement.setAttribute("encoding", "Base64");
                byte[] contentByteArray = null;
                if (content instanceof StreamSource) {
                    StreamSource streamSource = (StreamSource)content;
                    if (streamSource.getInputStream() != null) {
                        contentByteArray = IOUtils.toByteArray((InputStream)streamSource.getInputStream());
                    } else if (streamSource.getReader() != null) {
                        contentByteArray = IOUtils.toString((Reader)streamSource.getReader()).getBytes(charset);
                    }
                } else if (content instanceof InputStream) {
                    contentByteArray = IOUtils.toByteArray((InputStream)((InputStream)content));
                } else if (content instanceof byte[]) {
                    contentByteArray = (byte[])content;
                }
                if (contentByteArray == null) {
                    contentByteArray = (content != null ? content.toString() : "").getBytes(charset);
                }
                contentElement.setTextContent(new String(Base64Util.encodeBase64((byte[])contentByteArray), "US-ASCII"));
            } else {
                String contentText = null;
                if (content instanceof StreamSource) {
                    StreamSource streamSource = (StreamSource)content;
                    if (streamSource.getInputStream() != null) {
                        contentText = IOUtils.toString((InputStream)streamSource.getInputStream(), (String)charset);
                    } else if (streamSource.getReader() != null) {
                        contentText = IOUtils.toString((Reader)streamSource.getReader());
                    }
                } else if (content instanceof InputStream) {
                    contentText = IOUtils.toString((InputStream)((InputStream)content), (String)charset);
                } else if (content instanceof byte[]) {
                    contentText = new String((byte[])content, charset);
                }
                if (contentText == null) {
                    contentText = content != null ? content.toString() : "";
                }
                contentElement.setTextContent(contentText);
            }
        }
    }

    public static String httpResponseToXml(String status, Map<String, List<String>> headers, Object content, ContentType contentType, boolean parseMultipart, boolean includeMetadata, BinaryContentTypeResolver resolver) {
        try {
            Document document = HttpMessageConverter.getDocument();
            DonkeyElement requestElement = new DonkeyElement(document.createElement("HttpResponse"));
            if (includeMetadata) {
                requestElement.addChildElement("Status", status);
                DonkeyElement headerElement = requestElement.addChildElement("Header");
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    for (String value : entry.getValue()) {
                        DonkeyElement fieldElement = headerElement.addChildElement("Field");
                        fieldElement.addChildElement("Name", entry.getKey());
                        fieldElement.addChildElement("Value", value);
                    }
                }
            }
            HttpMessageConverter.processContent(requestElement.addChildElement("Body"), content, contentType, parseMultipart, resolver);
            return requestElement.toXml();
        }
        catch (Exception e) {
            logger.error("Error converting HTTP request.", (Throwable)e);
            return null;
        }
    }

    public static String getDefaultHttpCharset(String charset) {
        if (charset == null) {
            return "ISO-8859-1";
        }
        return charset;
    }

    public static Map<String, List<String>> convertFieldEnumerationToMap(HttpServletRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Enumeration headerNames = request.getHeaders(name);
            while (headerNames.hasMoreElements()) {
                ArrayList<String> list = (ArrayList<String>)headers.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    headers.put(name, list);
                }
                list.add((String)headerNames.nextElement());
            }
        }
        return headers;
    }

    public static ContentType setCharset(ContentType contentType, Charset charset) throws ParseException, UnsupportedCharsetException {
        String contentTypeString = contentType.toString();
        CharArrayBuffer buffer = new CharArrayBuffer(contentTypeString.length());
        buffer.append(contentTypeString);
        ParserCursor cursor = new ParserCursor(0, contentTypeString.length());
        Object[] elements = BasicHeaderValueParser.INSTANCE.parseElements(buffer, cursor);
        if (ArrayUtils.isNotEmpty((Object[])elements)) {
            String mimeType = elements[0].getName();
            Object[] params = elements[0].getParameters();
            ArrayList<Object> paramsList = new ArrayList<Object>();
            boolean charsetFound = false;
            if (ArrayUtils.isNotEmpty((Object[])params)) {
                for (Object nvp : params) {
                    if (nvp.getName().equalsIgnoreCase("charset")) {
                        charsetFound = true;
                        nvp = new BasicNameValuePair(nvp.getName(), charset.name());
                    }
                    paramsList.add(nvp);
                }
            }
            if (!charsetFound) {
                paramsList.add(new BasicNameValuePair("charset", charset.name()));
            }
            CharArrayBuffer newBuffer = new CharArrayBuffer(64);
            newBuffer.append(mimeType);
            newBuffer.append("; ");
            BasicHeaderValueFormatter.INSTANCE.formatParameters(newBuffer, paramsList.toArray(new NameValuePair[paramsList.size()]), false);
            return ContentType.parse((String)newBuffer.toString());
        }
        throw new ParseException("Invalid content type: " + contentTypeString);
    }

    private static Document getDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf.newDocumentBuilder().newDocument();
    }
}

