/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Box {
    private static Hashtable names = new Hashtable();
    private static Hashtable boxClasses;
    protected int length;
    protected long extraLength;
    protected int type;
    protected byte[] data;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$SignatureBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$FileTypeBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$Box;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$XMLBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$HeaderBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$BitsPerComponentBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$ColorSpecificationBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$PaletteBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$ComponentMappingBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$ChannelDefinitionBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDListBox;
    static /* synthetic */ Class class$com$sun$media$imageioimpl$plugins$jpeg2000$DataEntryURLBox;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    public static String getName(int type) {
        return (String)names.get(new Integer(type));
    }

    public static Class getBoxClass(int type) {
        if (type == 1785737832 || type == 1919251232) {
            return null;
        }
        return (Class)boxClasses.get(new Integer(type));
    }

    public static String getTypeByName(String name) {
        Enumeration keys = names.keys();
        while (keys.hasMoreElements()) {
            Integer i = (Integer)keys.nextElement();
            if (!name.equals(names.get(i))) continue;
            return Box.getTypeString(i);
        }
        return null;
    }

    public static Box createBox(int type, Node node) throws IIOInvalidTreeException {
        Class boxClass = (Class)boxClasses.get(new Integer(type));
        try {
            Constructor cons = boxClass.getConstructor(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = Box.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node);
            if (cons != null) {
                return (Box)cons.newInstance(node);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return new Box(node);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return new Box(node);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new Box(node);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return new Box(node);
        }
        return null;
    }

    public static Object getAttribute(Node node, String name) {
        NamedNodeMap map = node.getAttributes();
        return (node = map.getNamedItem(name)) != null ? node.getNodeValue() : null;
    }

    public static byte[] parseByteArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(value);
        int count = token.countTokens();
        byte[] buf = new byte[count];
        int i = 0;
        while (token.hasMoreElements()) {
            buf[i++] = new Byte(token.nextToken());
        }
        return buf;
    }

    protected static int[] parseIntArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(value);
        int count = token.countTokens();
        int[] buf = new int[count];
        int i = 0;
        while (token.hasMoreElements()) {
            buf[i++] = new Integer(token.nextToken());
        }
        return buf;
    }

    protected static String getStringElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof String) {
            return (String)obj;
        }
        return node.getNodeValue();
    }

    protected static byte getByteElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof Byte) {
            return (Byte)obj;
        }
        String value = node.getNodeValue();
        if (value != null) {
            return new Byte(value);
        }
        return 0;
    }

    protected static int getIntElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof Integer) {
            return (Integer)obj;
        }
        String value = node.getNodeValue();
        if (value != null) {
            return new Integer(value);
        }
        return 0;
    }

    protected static short getShortElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof Short) {
            return (Short)obj;
        }
        String value = node.getNodeValue();
        if (value != null) {
            return new Short(value);
        }
        return 0;
    }

    protected static byte[] getByteArrayElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof byte[]) {
            return (byte[])obj;
        }
        return Box.parseByteArray(node.getNodeValue());
    }

    protected static int[] getIntArrayElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof int[]) {
            return (int[])obj;
        }
        return Box.parseIntArray(node.getNodeValue());
    }

    public static void copyInt(byte[] data, int pos, int value) {
        data[pos++] = (byte)(value >> 24);
        data[pos++] = (byte)(value >> 16);
        data[pos++] = (byte)(value >> 8);
        data[pos++] = (byte)(value & 0xFF);
    }

    public static String getTypeString(int type) {
        byte[] buf = new byte[4];
        int i = 3;
        while (i >= 0) {
            buf[i] = (byte)(type & 0xFF);
            type >>>= 8;
            --i;
        }
        return new String(buf);
    }

    public static int getTypeInt(String s) {
        byte[] buf = s.getBytes();
        int t = buf[0];
        int i = 1;
        while (i < 4) {
            t = t << 8 | buf[i];
            ++i;
        }
        return t;
    }

    public Box(int length, int type, byte[] data) {
        this.type = type;
        this.setLength(length);
        this.setContent(data);
    }

    public Box(int length, int type, long extraLength, byte[] data) {
        this.type = type;
        this.setLength(length);
        if (length == 1) {
            this.setExtraLength(extraLength);
        }
        this.setContent(data);
    }

    public Box(ImageInputStream iis, int pos) throws IOException {
        this.read(iis, pos);
    }

    public Box(Node node) throws IIOInvalidTreeException {
        NodeList children = node.getChildNodes();
        String value = (String)Box.getAttribute(node, "Type");
        this.type = Box.getTypeInt(value);
        if (value == null || names.get(new Integer(this.type)) == null) {
            throw new IIOInvalidTreeException("Type is not defined", node);
        }
        value = (String)Box.getAttribute(node, "Length");
        if (value != null) {
            this.length = new Integer(value);
        }
        if ((value = (String)Box.getAttribute(node, "ExtraLength")) != null) {
            this.extraLength = new Long(value);
        }
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ("Content".equals(child.getNodeName())) {
                if (node instanceof IIOMetadataNode) {
                    IIOMetadataNode cnode = (IIOMetadataNode)node;
                    try {
                        this.data = (byte[])cnode.getUserObject();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.data == null && (value = node.getNodeValue()) != null) {
                    this.data = value.getBytes();
                }
            }
            ++i;
        }
    }

    public IIOMetadataNode getNativeNode() {
        String name = Box.getName(this.getType());
        if (name == null) {
            name = "unknown";
        }
        IIOMetadataNode node = new IIOMetadataNode(name);
        this.setDefaultAttributes(node);
        IIOMetadataNode child = new IIOMetadataNode("Content");
        child.setUserObject(this.data);
        child.setNodeValue(ImageUtil.convertObjectToString(this.data));
        node.appendChild(child);
        return node;
    }

    protected IIOMetadataNode getNativeNodeForSimpleBox() {
        try {
            Method m = this.getClass().getMethod("getElementNames", null);
            String[] elementNames = (String[])m.invoke(null, null);
            IIOMetadataNode node = new IIOMetadataNode(Box.getName(this.getType()));
            this.setDefaultAttributes(node);
            int i = 0;
            while (i < elementNames.length) {
                IIOMetadataNode child = new IIOMetadataNode(elementNames[i]);
                m = this.getClass().getMethod("get" + elementNames[i], null);
                Object obj = m.invoke((Object)this, null);
                child.setUserObject(obj);
                child.setNodeValue(ImageUtil.convertObjectToString(obj));
                node.appendChild(child);
                ++i;
            }
            return node;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18N.getString("Box0"));
        }
    }

    protected void setDefaultAttributes(IIOMetadataNode node) {
        node.setAttribute("Length", Integer.toString(this.length));
        node.setAttribute("Type", Box.getTypeString(this.type));
        if (this.length == 1) {
            node.setAttribute("ExtraLength", Long.toString(this.extraLength));
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public long getExtraLength() {
        return this.extraLength;
    }

    public byte[] getContent() {
        if (this.data == null) {
            this.compose();
        }
        return this.data;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setExtraLength(long extraLength) {
        if (this.length != 1) {
            throw new IllegalArgumentException(I18N.getString("Box1"));
        }
        this.extraLength = extraLength;
    }

    public void setContent(byte[] data) {
        if (data != null && (this.length == 1 && this.extraLength - 16L != (long)data.length || this.length != 1 && this.length - 8 != data.length)) {
            throw new IllegalArgumentException(I18N.getString("Box2"));
        }
        this.data = data;
        if (data != null) {
            this.parse(data);
        }
    }

    public void write(ImageOutputStream ios) throws IOException {
        ios.writeInt(this.length);
        ios.writeInt(this.type);
        if (this.length == 1) {
            ios.writeLong(this.extraLength);
            ios.write(this.data, 0, (int)this.extraLength);
        } else if (this.data != null) {
            ios.write(this.data, 0, this.length);
        }
    }

    public void read(ImageInputStream iis, int pos) throws IOException {
        iis.mark();
        iis.seek(pos);
        this.length = iis.readInt();
        this.type = iis.readInt();
        int dataLength = this.length - 8;
        if (this.length == 1) {
            this.extraLength = iis.readLong();
            dataLength = (int)(this.extraLength - 16L);
        }
        this.data = new byte[dataLength];
        iis.readFully(this.data);
        iis.reset();
    }

    protected void parse(byte[] data) {
    }

    protected void compose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        names.put(new Integer(1783636000), "JPEG2000SignatureBox");
        names.put(new Integer(1718909296), "JPEG2000FileTypeBox");
        names.put(new Integer(1785737833), "JPEG2000IntellectualPropertyRightsBox");
        names.put(new Integer(2020437024), "JPEG2000XMLBox");
        names.put(new Integer(1970628964), "JPEG2000UUIDBox");
        names.put(new Integer(1969843814), "JPEG2000UUIDInfoBox");
        names.put(new Integer(1785737832), "JPEG2000HeaderSuperBox");
        names.put(new Integer(1785737827), "JPEG2000CodeStreamBox");
        names.put(new Integer(1768449138), "JPEG2000HeaderBox");
        names.put(new Integer(1651532643), "JPEG2000BitsPerComponentBox");
        names.put(new Integer(1668246642), "JPEG2000ColorSpecificationBox");
        names.put(new Integer(1885564018), "JPEG2000PaletteBox");
        names.put(new Integer(1668112752), "JPEG2000ComponentMappingBox");
        names.put(new Integer(1667523942), "JPEG2000ChannelDefinitionBox");
        names.put(new Integer(1919251232), "JPEG2000ResolutionBox");
        names.put(new Integer(1919251299), "JPEG2000CaptureResolutionBox");
        names.put(new Integer(1919251300), "JPEG2000DefaultDisplayResolutionBox");
        names.put(new Integer(1969451892), "JPEG2000UUIDListBox");
        names.put(new Integer(1970433056), "JPEG2000DataEntryURLBox");
        boxClasses = new Hashtable();
        boxClasses.put(new Integer(1783636000), class$com$sun$media$imageioimpl$plugins$jpeg2000$SignatureBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$SignatureBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$SignatureBox);
        boxClasses.put(new Integer(1718909296), class$com$sun$media$imageioimpl$plugins$jpeg2000$FileTypeBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$FileTypeBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$FileTypeBox);
        boxClasses.put(new Integer(1785737833), class$com$sun$media$imageioimpl$plugins$jpeg2000$Box == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$Box = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.Box")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$Box);
        boxClasses.put(new Integer(2020437024), class$com$sun$media$imageioimpl$plugins$jpeg2000$XMLBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$XMLBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$XMLBox);
        boxClasses.put(new Integer(1970628964), class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.UUIDBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDBox);
        boxClasses.put(new Integer(1768449138), class$com$sun$media$imageioimpl$plugins$jpeg2000$HeaderBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$HeaderBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$HeaderBox);
        boxClasses.put(new Integer(1651532643), class$com$sun$media$imageioimpl$plugins$jpeg2000$BitsPerComponentBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$BitsPerComponentBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$BitsPerComponentBox);
        boxClasses.put(new Integer(1668246642), class$com$sun$media$imageioimpl$plugins$jpeg2000$ColorSpecificationBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$ColorSpecificationBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$ColorSpecificationBox);
        boxClasses.put(new Integer(1885564018), class$com$sun$media$imageioimpl$plugins$jpeg2000$PaletteBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$PaletteBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$PaletteBox);
        boxClasses.put(new Integer(1668112752), class$com$sun$media$imageioimpl$plugins$jpeg2000$ComponentMappingBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$ComponentMappingBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$ComponentMappingBox);
        boxClasses.put(new Integer(1667523942), class$com$sun$media$imageioimpl$plugins$jpeg2000$ChannelDefinitionBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$ChannelDefinitionBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$ChannelDefinitionBox);
        boxClasses.put(new Integer(1919251232), class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox);
        boxClasses.put(new Integer(1919251299), class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox);
        boxClasses.put(new Integer(1919251300), class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$ResolutionBox);
        boxClasses.put(new Integer(1969451892), class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDListBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDListBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.UUIDListBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$UUIDListBox);
        boxClasses.put(new Integer(1970433056), class$com$sun$media$imageioimpl$plugins$jpeg2000$DataEntryURLBox == null ? (class$com$sun$media$imageioimpl$plugins$jpeg2000$DataEntryURLBox = Box.class$("com.sun.media.imageioimpl.plugins.jpeg2000.DataEntryURLBox")) : class$com$sun$media$imageioimpl$plugins$jpeg2000$DataEntryURLBox);
    }
}

