/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import java.io.IOException;
import java.util.zip.Deflater;
import javax.imageio.ImageWriteParam;

public class TIFFDeflateCompressor
extends TIFFCompressor {
    Deflater deflater;

    public TIFFDeflateCompressor(ImageWriteParam param) {
        super("Deflate", 32946, true);
        int deflateLevel;
        if (param != null) {
            float quality = param.getCompressionQuality();
            deflateLevel = (int)(1.0f + 8.0f * quality);
        } else {
            deflateLevel = -1;
        }
        this.deflater = new Deflater(deflateLevel);
    }

    private static int deflate(Deflater deflater, byte[] inflated, byte[] deflated) {
        deflater.setInput(inflated);
        deflater.finish();
        int numCompressedBytes = deflater.deflate(deflated);
        deflater.reset();
        return numCompressedBytes;
    }

    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int inputSize = height * scanlineStride;
        int blocks = (inputSize + Short.MAX_VALUE) / 32768;
        byte[] compData = new byte[inputSize + 5 * blocks + 6];
        this.deflater.setInput(b, off, height * scanlineStride);
        this.deflater.finish();
        int numCompressedBytes = this.deflater.deflate(compData);
        this.deflater.reset();
        this.stream.write(compData, 0, numCompressedBytes);
        return numCompressedBytes;
    }
}

