/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.MFN_M10_MF_TEST_BATTERIES;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M10
extends AbstractMessage {
    public MFN_M10() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M10(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_M10_MF_TEST_BATTERIES.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M10 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M10_MF_TEST_BATTERIES getMF_TEST_BATTERIES() {
        return (MFN_M10_MF_TEST_BATTERIES)this.getTyped("MF_TEST_BATTERIES", MFN_M10_MF_TEST_BATTERIES.class);
    }

    public MFN_M10_MF_TEST_BATTERIES getMF_TEST_BATTERIES(int rep) {
        return (MFN_M10_MF_TEST_BATTERIES)this.getTyped("MF_TEST_BATTERIES", rep, MFN_M10_MF_TEST_BATTERIES.class);
    }

    public int getMF_TEST_BATTERIESReps() {
        return this.getReps("MF_TEST_BATTERIES");
    }

    public List<MFN_M10_MF_TEST_BATTERIES> getMF_TEST_BATTERIESAll() throws HL7Exception {
        return this.getAllAsList("MF_TEST_BATTERIES", MFN_M10_MF_TEST_BATTERIES.class);
    }

    public void insertMF_TEST_BATTERIES(MFN_M10_MF_TEST_BATTERIES structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST_BATTERIES", (Structure)structure, rep);
    }

    public MFN_M10_MF_TEST_BATTERIES insertMF_TEST_BATTERIES(int rep) throws HL7Exception {
        return (MFN_M10_MF_TEST_BATTERIES)super.insertRepetition("MF_TEST_BATTERIES", rep);
    }

    public MFN_M10_MF_TEST_BATTERIES removeMF_TEST_BATTERIES(int rep) throws HL7Exception {
        return (MFN_M10_MF_TEST_BATTERIES)super.removeRepetition("MF_TEST_BATTERIES", rep);
    }
}

