/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.connectors.jms.JmsReceiverProperties;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.StopException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.util.BeanUtil;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmsClient
implements ExceptionListener {
    private Connector connector;
    private JmsReceiverProperties connectorProperties;
    private String connectorName;
    private Connection connection;
    private Session session;
    private Context initialContext;
    private Destination destination;
    private String destinationName;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private Thread reconnectThread;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private AtomicBoolean attemptingReconnect = new AtomicBoolean(false);
    private int intervalMillis;
    private Logger logger = LogManager.getLogger(this.getClass());
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Set<String> resourceIds;

    public JmsClient(Connector connector, JmsReceiverProperties connectorProperties, String connectorName) {
        this.connector = connector;
        this.connectorProperties = connectorProperties;
        this.connectorName = connectorName;
        this.intervalMillis = NumberUtils.toInt((String)this.replacer.replaceValues(connectorProperties.getReconnectIntervalMillis(), connector.getChannelId(), connector.getChannel().getName()));
        if (connectorProperties instanceof SourceConnectorPropertiesInterface) {
            this.resourceIds = connectorProperties.getSourceConnectorProperties().getResourceIds().keySet();
        } else if (connectorProperties instanceof DestinationConnectorPropertiesInterface) {
            this.resourceIds = ((DestinationConnectorPropertiesInterface)connectorProperties).getDestinationConnectorProperties().getResourceIds().keySet();
        }
    }

    private ConnectionFactory lookupConnectionFactoryWithJndi() throws Exception {
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", this.replacer.replaceValues(this.connectorProperties.getJndiProviderUrl(), channelId, channelName));
        env.put("java.naming.factory.initial", this.replacer.replaceValues(this.connectorProperties.getJndiInitialContextFactory(), channelId, channelName));
        env.put("java.naming.security.principal", this.replacer.replaceValues(this.connectorProperties.getUsername(), channelId, channelName));
        env.put("java.naming.security.credentials", this.replacer.replaceValues(this.connectorProperties.getPassword(), channelId, channelName));
        this.initialContext = new InitialContext(env);
        String connectionFactoryName = this.replacer.replaceValues(this.connectorProperties.getJndiConnectionFactoryName(), channelId, channelName);
        return (ConnectionFactory)this.initialContext.lookup(connectionFactoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ConnectorTaskException {
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        Map connectionProperties = this.replacer.replaceValues(this.connectorProperties.getConnectionProperties(), channelId, channelName);
        ConnectionFactory connectionFactory = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            MirthContextFactory contextFactory = null;
            try {
                contextFactory = this.contextFactoryController.getContextFactory(this.resourceIds);
                Thread.currentThread().setContextClassLoader(contextFactory.getApplicationClassLoader());
            }
            catch (Exception e) {
                throw new ConnectorTaskException("Failed to set ContextClassLoader on thread", (Throwable)e);
            }
            if (this.connectorProperties.isUseJndi()) {
                try {
                    connectionFactory = this.lookupConnectionFactoryWithJndi();
                }
                catch (Exception e) {
                    throw new ConnectorTaskException("Failed to obtain the connection factory via JNDI", (Throwable)e);
                }
            }
            String className = this.replacer.replaceValues(this.connectorProperties.getConnectionFactoryClass(), channelId, channelName);
            try {
                connectionFactory = (ConnectionFactory)Class.forName(className, true, contextFactory.getApplicationClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new ConnectorTaskException("Failed to instantiate ConnectionFactory class: " + className, (Throwable)e);
            }
            BeanUtil.setProperties((Object)connectionFactory, (Map)connectionProperties);
            try {
                this.logger.debug("Creating JMS connection and session");
                this.connection = connectionFactory.createConnection(this.replacer.replaceValues(this.connectorProperties.getUsername(), channelId, channelName), this.replacer.replaceValues(this.connectorProperties.getPassword(), channelId, channelName));
                String clientId = this.replacer.replaceValues(this.connectorProperties.getClientId(), channelId, channelName);
                if (!clientId.isEmpty()) {
                    this.connection.setClientID(clientId);
                }
                this.connection.setExceptionListener((ExceptionListener)this);
                this.logger.debug("Starting JMS connection");
                this.connection.start();
                this.logger.debug("Creating JMS session");
                this.session = this.connection.createSession(false, 2);
                this.logger.debug("JMS session created");
            }
            catch (JMSException e) {
                try {
                    this.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ConnectorTaskException("Failed to establish a JMS connection", (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.connected.set(true);
    }

    public void stop() throws StopException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                throw new StopException("Failed to close the JMS connection", (Throwable)e);
            }
        }
        if (this.initialContext != null) {
            try {
                this.initialContext.close();
            }
            catch (NamingException e) {
                this.logger.error("Failed to close the initial context", (Throwable)e);
            }
            this.initialContext = null;
        }
        this.connected.set(false);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public synchronized Destination getDestination(String destinationName) throws JMSException, NamingException {
        if (destinationName.equals(this.destinationName)) {
            return this.destination;
        }
        this.destinationName = destinationName;
        if (this.connectorProperties.isUseJndi()) {
            this.destination = (Destination)this.initialContext.lookup(destinationName);
        } else if (this.connectorProperties.isTopic()) {
            this.destination = this.session.createTopic(destinationName);
            this.logger.debug("Connected to topic: " + destinationName);
        } else {
            this.destination = this.session.createQueue(destinationName);
            this.logger.debug("Connected to queue: " + destinationName);
        }
        return this.destination;
    }

    public void onException(JMSException e) {
        if (this.attemptingReconnect.get()) {
            return;
        }
        this.beginReconnect(false);
    }

    public synchronized boolean beginReconnect(boolean force) {
        if (this.connected.get()) {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.connector.getChannelId(), Integer.valueOf(this.connector.getMetaDataId()), this.connectorName, ConnectionStatusEventType.DISCONNECTED));
            this.connected.set(false);
        }
        if (this.intervalMillis == 0) {
            this.doReconnect();
            return this.connected.get();
        }
        if (this.reconnectThread == null || !this.reconnectThread.isAlive()) {
            this.reconnectThread = new ReconnectThread();
            this.reconnectThread.start();
        }
        if (force) {
            this.reconnectThread.interrupt();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return this.connected.get();
        }
        return false;
    }

    private synchronized void doReconnect() {
        try {
            this.attemptingReconnect.set(true);
            this.logger.debug("attempting to reconnect");
            try {
                this.stop();
            }
            catch (StopException stopException) {
                // empty catch block
            }
            this.connector.onStart();
            this.logger.debug("reconnect successful");
        }
        catch (ConnectorTaskException e) {
            this.reportError("Failed to reconnect", (Exception)((Object)e));
        }
        finally {
            this.attemptingReconnect.set(false);
            this.notify();
        }
    }

    private void reportError(String errorMessage, Exception e) {
        String channelId = this.connector.getChannelId();
        this.logger.error(errorMessage + " (channel: " + ChannelController.getInstance().getDeployedChannelById(channelId).getName() + ")", (Throwable)e);
        this.eventController.dispatchEvent((Event)new ErrorEvent(channelId, Integer.valueOf(this.connector.getMetaDataId()), null, ErrorEventType.DESTINATION_CONNECTOR, this.connectorName, this.connectorProperties.getName(), null, e.getCause()));
    }

    private class ReconnectThread
    extends Thread {
        private ReconnectThread() {
        }

        @Override
        public void run() {
            while (!JmsClient.this.connected.get() && JmsClient.this.connector.getCurrentState() == DeployedState.STARTED) {
                try {
                    if (!JmsClient.this.connected.get()) {
                        JmsClient.this.doReconnect();
                    }
                    Thread.sleep(JmsClient.this.intervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

