/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.connectors.jms.JmsConnectorException;
import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import com.mirth.connect.connectors.jms.JmsConnectorServletInterface;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ExtensionController;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmsConnectorServlet
extends MirthServlet
implements JmsConnectorServletInterface {
    private static final String PLUGIN_NAME = "JMS";
    private static final String TEMPLATES_PROPERTY = "templates";
    private static final Serializer serializer = ObjectXMLSerializer.getInstance();
    private static final Logger logger = LogManager.getLogger(JmsConnectorServlet.class);
    private static final Lock lock = new ReentrantLock(true);
    private static Properties properties = new Properties();
    private static LinkedHashMap<String, JmsConnectorProperties> templates = new LinkedHashMap();

    public JmsConnectorServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "JMS Connector Service");
    }

    public LinkedHashMap<String, JmsConnectorProperties> getTemplates() {
        lock.lock();
        try {
            this.load();
            LinkedHashMap<String, JmsConnectorProperties> linkedHashMap = new LinkedHashMap<String, JmsConnectorProperties>(templates);
            return linkedHashMap;
        }
        catch (JmsConnectorException e) {
            throw new MirthApiException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public JmsConnectorProperties getTemplate(String templateName) {
        lock.lock();
        try {
            this.load();
            JmsConnectorProperties jmsConnectorProperties = templates.get(templateName);
            return jmsConnectorProperties;
        }
        catch (JmsConnectorException e) {
            throw new MirthApiException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public Set<String> saveTemplate(String templateName, JmsConnectorProperties properties) {
        lock.lock();
        try {
            this.load();
            templates.put(templateName, properties);
            this.save();
            HashSet<String> hashSet = new HashSet<String>(templates.keySet());
            return hashSet;
        }
        catch (JmsConnectorException e) {
            throw new MirthApiException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public Set<String> deleteTemplate(String templateName) {
        lock.lock();
        try {
            this.load();
            templates.remove(templateName);
            this.save();
            HashSet<String> hashSet = new HashSet<String>(templates.keySet());
            return hashSet;
        }
        catch (JmsConnectorException e) {
            throw new MirthApiException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private void load() throws JmsConnectorException {
        Object deserialized;
        Object object;
        try {
            properties = ExtensionController.getInstance().getPluginProperties(PLUGIN_NAME);
            object = properties.get(TEMPLATES_PROPERTY);
        }
        catch (ControllerException e) {
            throw new JmsConnectorException("Failed to load the list of JMS provider classes from the extension properties for the JMS connector", e);
        }
        templates = null;
        if (object != null && !object.toString().isEmpty() && (deserialized = serializer.deserialize(object.toString(), Object.class)) instanceof LinkedHashMap) {
            templates = (LinkedHashMap)deserialized;
        }
        if (templates == null) {
            templates = new LinkedHashMap();
            this.save();
        }
    }

    private void save() {
        properties.put(TEMPLATES_PROPERTY, serializer.serialize(templates));
        try {
            ExtensionController.getInstance().setPluginProperties(PLUGIN_NAME, properties);
        }
        catch (ControllerException e) {
            logger.error("Failed to save list of JMS provider classes in the extension properties for the JMS connector");
        }
    }
}

