/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager;

import com.mirth.connect.manager.DisplayUtil;
import com.mirth.connect.manager.ManagerController;
import com.mirth.connect.manager.PlatformUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class HeapSizeDialog
extends JDialog {
    private String heapSize;
    private ManagerController managerController = ManagerController.getInstance();
    private List<String> heapSizeComboboxModel;
    private JComboBox heapSizeComboBox;
    private JLabel warningLabel;
    private JButton okButton;
    private JButton cancelButton;

    public HeapSizeDialog(String heapSize) {
        super((Dialog)PlatformUI.MANAGER_DIALOG, true);
        String property;
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapSizeDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        DisplayUtil.setResizable(this, false);
        this.setBackground(Color.white);
        this.setTitle("Web Start Settings");
        this.getContentPane().setBackground(Color.white);
        this.initComponents();
        this.heapSize = StringUtils.isEmpty((CharSequence)heapSize) ? "512m" : heapSize;
        String heapSizeOption = HeapSize.toDisplayName(heapSize);
        if (StringUtils.isBlank((CharSequence)heapSizeOption)) {
            heapSizeOption = this.heapSize;
        }
        if (!this.heapSizeComboboxModel.contains(property = (String)this.managerController.getServerProperties().getProperty("administrator.maxheapsize")) && !this.heapSizeComboboxModel.contains(HeapSize.toDisplayName(property))) {
            this.heapSizeComboboxModel.add(this.formatCustomProperty(property));
        }
        ArrayList<String> mbList = new ArrayList<String>();
        ArrayList<String> gbList = new ArrayList<String>();
        for (String size : this.heapSizeComboboxModel) {
            if (size.contains("M")) {
                mbList.add(size);
                continue;
            }
            gbList.add(size);
        }
        Collections.sort(mbList);
        Collections.sort(gbList);
        mbList.addAll(gbList);
        this.heapSizeComboBox = new JComboBox<Object>(mbList.toArray());
        this.heapSizeComboBox.getModel().setSelectedItem(this.formatCustomProperty(heapSizeOption));
        this.initLayout();
        this.pack();
        this.setLocationRelativeTo(PlatformUI.MANAGER_DIALOG);
        this.setVisible(true);
    }

    public String getHeapSize() {
        Object heapSize = HeapSize.fromDisplayName((String)this.heapSizeComboBox.getSelectedItem());
        if (StringUtils.isBlank((CharSequence)heapSize)) {
            heapSize = (String)this.heapSizeComboBox.getSelectedItem();
            String[] formattedHeapSize = ((String)heapSize).split(" ");
            heapSize = formattedHeapSize[0] + formattedHeapSize[1].toLowerCase().substring(0, 1);
        }
        return heapSize;
    }

    private void initComponents() {
        this.heapSizeComboboxModel = new ArrayList<String>();
        Object customComboboxProperties = this.managerController.getServerProperties().getProperty("administrator.maxheapsizeoptions");
        if (customComboboxProperties instanceof String) {
            this.heapSizeComboboxModel.add(this.formatCustomProperty((String)customComboboxProperties));
        } else if (customComboboxProperties instanceof List) {
            for (String property : (ArrayList)customComboboxProperties) {
                this.heapSizeComboboxModel.add(this.formatCustomProperty(property));
            }
        }
        if (this.heapSizeComboboxModel.isEmpty()) {
            this.heapSizeComboboxModel.add(HeapSize._256MB.getDisplayName());
            this.heapSizeComboboxModel.add(HeapSize._512MB.getDisplayName());
            this.heapSizeComboboxModel.add(HeapSize._1GB.getDisplayName());
            this.heapSizeComboboxModel.add(HeapSize._2GB.getDisplayName());
        }
        this.warningLabel = new JLabel("<html>Note: The Administrator may fail to start<br>if the max heap size is set too high.</html>");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapSizeDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapSizeDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 4, novisualpadding, hidemode 3, fill"));
        panel.setBackground(Color.white);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "Web Start Settings", 0, 0, new Font("Tahoma", 1, 11)));
        panel.add((Component)new JLabel("Max Heap Size:"), "split");
        panel.add((Component)this.heapSizeComboBox, "w 75!, left, wrap");
        panel.add((Component)this.warningLabel, "split");
        this.add(panel);
        this.add((Component)new JSeparator(), "newline, growx, sx");
        this.add((Component)this.okButton, "newline, h 22!, w 56!, sx, right, split");
        this.add((Component)this.cancelButton, "h 22!, w 56!");
    }

    private String formatCustomProperty(String property) {
        String[] prop = property.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
        String units = String.valueOf(prop[1]);
        if (StringUtils.isNotBlank((CharSequence)units)) {
            units = units.toLowerCase().contains("m") ? "MB" : "GB";
        }
        return String.valueOf(prop[0]) + " " + units;
    }

    private static enum HeapSize {
        _256MB("256 MB", "256m"),
        _512MB("512 MB", "512m"),
        _1GB("1 GB", "1g"),
        _2GB("2 GB", "2g");

        private String displayName;
        private String value;

        private HeapSize(String displayName, String value) {
            this.displayName = displayName;
            this.value = value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getValue() {
            return this.value;
        }

        public static String fromDisplayName(String displayName) {
            for (HeapSize type : HeapSize.values()) {
                if (!type.getDisplayName().equals(displayName)) continue;
                return type.value;
            }
            return null;
        }

        public static String toDisplayName(String value) {
            for (HeapSize type : HeapSize.values()) {
                if (!type.getValue().equals(value)) continue;
                return type.displayName;
            }
            return null;
        }
    }
}

