/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager;

import com.mirth.connect.manager.Manager;
import com.mirth.connect.manager.ManagerController;
import com.mirth.connect.manager.PlatformUI;
import com.mirth.connect.manager.ServiceControllerFactory;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class ManagerTray {
    private TrayIcon mirthTrayIcon;
    private PopupMenu menu;
    private MenuItem viewItem;
    private MenuItem startItem;
    private MenuItem stopItem;
    private MenuItem restartItem;
    private MenuItem administratorItem;
    private MenuItem quitItem;
    public static final int STARTED = 1;
    public static final int STOPPED = 0;
    public static final int BUSY = -1;

    public void setupTray() {
        this.menu = new PopupMenu("BridgeLink Server Manager");
        this.viewItem = new MenuItem("Show Manager");
        this.viewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlatformUI.MANAGER_DIALOG.open();
            }
        });
        this.menu.add(this.viewItem);
        this.menu.addSeparator();
        this.administratorItem = new MenuItem("Launch Administrator");
        this.administratorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerController.getInstance().launchAdministrator(null);
            }
        });
        this.menu.add(this.administratorItem);
        this.startItem = new MenuItem("Start BridgeLink");
        this.startItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerController.getInstance().startMirthWorker();
            }
        });
        this.menu.add(this.startItem);
        this.stopItem = new MenuItem("Stop BridgeLink");
        this.stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerController.getInstance().stopMirthWorker();
            }
        });
        this.menu.add(this.stopItem);
        this.restartItem = new MenuItem("Restart BridgeLink");
        this.restartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerController.getInstance().restartMirthWorker();
            }
        });
        this.menu.add(this.restartItem);
        this.menu.addSeparator();
        this.quitItem = new MenuItem("Close Manager");
        this.quitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformUI.MANAGER_DIALOG.close();
                Manager.shutdown();
            }
        });
        this.menu.add(this.quitItem);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("images/NG_MC_Icon_Grey_32x32.png"));
        this.mirthTrayIcon = new TrayIcon(icon.getImage(), "BridgeLink Server Manager", this.menu);
        this.mirthTrayIcon.setImageAutoSize(true);
        this.mirthTrayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlatformUI.MANAGER_DIALOG.open();
            }
        });
        try {
            if (ServiceControllerFactory.getServiceController().isShowTrayIcon()) {
                SystemTray tray = null;
                try {
                    tray = SystemTray.getSystemTray();
                    tray.add(this.mirthTrayIcon);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
            } else {
                PlatformUI.MANAGER_DIALOG.open();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStartButtonActive(boolean active) {
        this.startItem.setEnabled(active);
    }

    public void setStopButtonActive(boolean active) {
        this.stopItem.setEnabled(active);
    }

    public void setRestartButtonActive(boolean active) {
        this.restartItem.setEnabled(active);
    }

    public void setLaunchButtonActive(boolean active) {
        this.administratorItem.setEnabled(active);
    }

    public void alertError(String text) {
        this.mirthTrayIcon.displayMessage("Error", text, TrayIcon.MessageType.ERROR);
    }

    public void alertInfo(String text) {
        this.mirthTrayIcon.displayMessage("Information", text, TrayIcon.MessageType.INFO);
    }

    public void alertWarning(String text) {
        this.mirthTrayIcon.displayMessage("Warning", text, TrayIcon.MessageType.WARNING);
    }

    public void setTrayIcon(int icon) {
        ImageIcon imageIcon = icon == 1 ? new ImageIcon(this.getClass().getResource("images/NG_MC_Icon_32x32.png")) : (icon == 0 ? new ImageIcon(this.getClass().getResource("images/NG_MC_Icon_Grey_32x32.png")) : new ImageIcon(this.getClass().getResource("images/NG_MC_Icon_Grey_32x32.png")));
        this.mirthTrayIcon.setImage(imageIcon.getImage());
    }
}

