/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.chart;

import com.mirth.connect.plugins.messagetrends.client.chart.AbstractTrendsChart;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class StackedTrendsChart
extends AbstractTrendsChart {
    private TimeTableXYDataset dataset = new TimeTableXYDataset();
    private final StackedXYBarRenderer barRenderer;

    public StackedTrendsChart() {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)"Message Volume", (String)"Time", (String)"Count", (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        this.barRenderer = new StackedXYBarRenderer();
        this.barRenderer.setRenderAsPercentages(false);
        this.barRenderer.setDrawBarOutline(false);
        this.barRenderer.setShadowVisible(false);
        this.barRenderer.setMargin(0.1);
        this.barRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1} \u2192 {2})", (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"), NumberFormat.getIntegerInstance()));
        xYPlot.setRenderer((XYItemRenderer)this.barRenderer);
        ((DateAxis)xYPlot.getDomainAxis()).setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        this.initCommon(jFreeChart, xYPlot, chartPanel, (XYItemRenderer)this.barRenderer);
    }

    @Override
    protected void clearDataset() {
        this.dataset = new TimeTableXYDataset();
        this.plot.setDataset((XYDataset)this.dataset);
    }

    @Override
    protected void addPoint(RegularTimePeriod regularTimePeriod, MessageStatisticsTimeseries messageStatisticsTimeseries) {
        this.dataset.add((TimePeriod)regularTimePeriod, (double)messageStatisticsTimeseries.getReceived().intValue(), (Comparable)((Object)"Received"));
        this.dataset.add((TimePeriod)regularTimePeriod, (double)messageStatisticsTimeseries.getSent().intValue(), (Comparable)((Object)"Sent"));
        this.dataset.add((TimePeriod)regularTimePeriod, (double)messageStatisticsTimeseries.getFiltered().intValue(), (Comparable)((Object)"Filtered"));
        this.dataset.add((TimePeriod)regularTimePeriod, (double)messageStatisticsTimeseries.getQueued().intValue(), (Comparable)((Object)"Queued"));
        this.dataset.add((TimePeriod)regularTimePeriod, (double)messageStatisticsTimeseries.getError().intValue(), (Comparable)((Object)"Error"));
    }
}

