/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.service;

import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.EntityException;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.plugins.messagetrends.client.exception.MessageTrendsClientException;
import com.mirth.connect.plugins.messagetrends.shared.dto.response.ErrorResponse;
import com.mirth.connect.plugins.messagetrends.shared.interfaces.MessageTrendsServletInterface;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import com.mirth.connect.plugins.messagetrends.shared.util.JsonUtils;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsServiceClient {
    private static MessageTrendsServiceClient instance = null;
    private MessageTrendsServletInterface servlet;
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageTrendsServiceClient getInstance() {
        Class<MessageTrendsServiceClient> clazz = MessageTrendsServiceClient.class;
        synchronized (MessageTrendsServiceClient.class) {
            if (instance == null) {
                instance = new MessageTrendsServiceClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<MessageStatisticsTimeseries> getChannelStatistics(String string, Long l, Long l2, String string2) throws ClientException {
        try {
            if (l == null || l2 == null) {
                throw new IllegalArgumentException("startMillis and endMillis are required (epoch millis)");
            }
            if (l >= l2) {
                throw new IllegalArgumentException("startMillis must be < endMillis");
            }
            Long l3 = l / 1000L;
            Long l4 = l2 / 1000L;
            String string3 = this.getServlet().getChannelStatistics(string, l3, l4, string2);
            return JsonUtils.fromJsonList((String)string3, MessageStatisticsTimeseries.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException, false);
            throw clientException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error while fetching channel statistics", exception);
        }
    }

    public List<MessageStatisticsTimeseries> getConnectorStatistics(String string, String string2, Long l, Long l2, String string3) throws ClientException {
        try {
            if (l == null || l2 == null) {
                throw new IllegalArgumentException("startMillis and endMillis are required (epoch millis)");
            }
            if (l >= l2) {
                throw new IllegalArgumentException("startMillis must be < endMillis");
            }
            Long l3 = l / 1000L;
            Long l4 = l2 / 1000L;
            String string4 = this.getServlet().getConnectorStatistics(string, string2, l3, l4, string3);
            return JsonUtils.fromJsonList((String)string4, MessageStatisticsTimeseries.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException, false);
            throw clientException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error while fetching connector statistics", exception);
        }
    }

    public List<MessageStatisticsTimeseries> getServerStatistics(Long l, Long l2, String string) throws ClientException {
        try {
            if (l == null || l2 == null) {
                throw new IllegalArgumentException("startMillis and endMillis are required (epoch millis)");
            }
            if (l >= l2) {
                throw new IllegalArgumentException("startMillis must be < endMillis");
            }
            Long l3 = l / 1000L;
            Long l4 = l2 / 1000L;
            String string2 = this.getServlet().getServerStatistics(l3, l4, string);
            return JsonUtils.fromJsonList((String)string2, MessageStatisticsTimeseries.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException, false);
            throw clientException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error while fetching server statistics", exception);
        }
    }

    public String getAvailableIntervals() throws ClientException {
        return "";
    }

    private MessageTrendsServletInterface getServlet() {
        if (this.servlet == null) {
            Client client = PlatformUI.MIRTH_FRAME.mirthClient;
            this.servlet = (MessageTrendsServletInterface)client.getServlet(MessageTrendsServletInterface.class);
        }
        return this.servlet;
    }

    private void rethrowParsedClientError(ClientException clientException) throws ClientException {
        this.rethrowParsedClientError(clientException, true);
    }

    private void rethrowParsedClientError(ClientException clientException, boolean bl) throws ClientException {
        Throwable throwable = clientException.getCause();
        if (throwable instanceof EntityException) {
            ErrorResponse errorResponse;
            String string = (String)((EntityException)throwable).getEntity();
            try {
                errorResponse = (ErrorResponse)JsonUtils.fromJson((String)string, ErrorResponse.class);
                if (bl) {
                    this.logger.error("Parsed API error: {}", (Object)JsonUtils.toJson((Object)errorResponse));
                }
            }
            catch (Exception exception) {
                if (bl) {
                    this.logger.error("Failed to parse server error response: {}", (Object)string, (Object)exception);
                }
                errorResponse = new ErrorResponse("UNPARSEABLE_RESPONSE", "Failed to parse server error");
            }
            throw new MessageTrendsClientException(errorResponse, clientException);
        }
        throw clientException;
    }
}

