/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.summary;

import com.mirth.connect.plugins.messagetrends.client.panel.MessageTrendsDashboardPanel;
import com.mirth.connect.plugins.messagetrends.client.summary.SummaryView;
import com.mirth.connect.plugins.messagetrends.client.util.RangeTextFormatter;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.ToIntFunction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class SummaryMetricView
extends JPanel
implements SummaryView {
    private final JTable table;
    private final DefaultTableModel model;
    private MessageTrendsDashboardPanel.View view;
    private final TitledBorder border = new TitledBorder("Statistics Summary");
    protected Long winStartMs;
    protected Long winEndMs;

    public SummaryMetricView() {
        this.setBorder(this.border);
        this.setLayout(new BorderLayout(8, 8));
        Object[] objectArray = new String[]{"Total", "Average", "Minimum", "Maximum", "Peak Time", "Average Rate"};
        this.model = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.setFillsViewportHeight(true);
        this.table.setRowHeight(22);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(4);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        for (int i = 0; i < objectArray.length; ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(defaultTableCellRenderer);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(10, 32));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(10, 120));
        this.add((Component)jScrollPane, "Center");
        this.reset();
    }

    public void setStandardStatsRow(String string, String string2, String string3, String string4, String string5, String string6) {
        this.model.setRowCount(0);
        this.model.addRow(new Object[]{SummaryMetricView.safe(string), SummaryMetricView.safe(string2), SummaryMetricView.safe(string3), SummaryMetricView.safe(string4), SummaryMetricView.safe(string5), SummaryMetricView.safe(string6)});
    }

    public void setStats(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setStandardStatsRow(string, string2, string3, string4, string5, string6);
    }

    private void updateTitle(String string) {
        Object object = string;
        String string2 = RangeTextFormatter.formatRange(this.winStartMs, this.winEndMs);
        if (string2 != null && !string2.isEmpty()) {
            object = (String)object + " \u2014 " + string2;
        }
        this.border.setTitle((String)object);
        this.repaint();
    }

    @Override
    public void reset() {
        this.setStandardStatsRow("0", "0", "0", "0", "\u2014", "\u2014");
    }

    public void setQueuedHeader(boolean bl) {
        String string = bl ? "Last" : "Total";
        this.table.getColumnModel().getColumn(0).setHeaderValue(string);
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
    }

    private static String safe(String string) {
        return string == null ? "" : string;
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }

    @Override
    public void setView(MessageTrendsDashboardPanel.View view) {
        this.view = view;
    }

    @Override
    public void setWindowRange(long l, long l2) {
        this.winStartMs = l;
        this.winEndMs = l2;
    }

    @Override
    public void setData(List<MessageStatisticsTimeseries> list) {
        String string;
        Object object;
        Object object2;
        ToIntFunction<MessageStatisticsTimeseries> toIntFunction;
        String string2;
        MessageTrendsDashboardPanel.View view = this.view;
        if (view == null || view == MessageTrendsDashboardPanel.View.ALL) {
            return;
        }
        boolean bl = false;
        switch (view) {
            case RECEIVED: {
                string2 = "Received";
                toIntFunction = MessageStatisticsTimeseries::getReceived;
                break;
            }
            case SENT: {
                string2 = "Sent";
                toIntFunction = MessageStatisticsTimeseries::getSent;
                break;
            }
            case FILTERED: {
                string2 = "Filtered";
                toIntFunction = MessageStatisticsTimeseries::getFiltered;
                break;
            }
            case QUEUED: {
                string2 = "Queued";
                toIntFunction = MessageStatisticsTimeseries::getQueued;
                bl = true;
                break;
            }
            default: {
                string2 = "Errors";
                toIntFunction = MessageStatisticsTimeseries::getError;
            }
        }
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        Date date = null;
        for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
            int n = toIntFunction.applyAsInt(messageStatisticsTimeseries);
            l += (long)n;
            if ((long)n < l2) {
                l2 = n;
            }
            if ((long)n <= l3) continue;
            l3 = n;
            date = messageStatisticsTimeseries.getTs();
        }
        if (list.isEmpty()) {
            l3 = 0L;
            l2 = 0L;
        }
        double d = list.isEmpty() ? 0.0 : (double)l / (double)list.size();
        double d2 = 0.0;
        if (list.size() > 1) {
            double d3;
            object2 = list.get(0).getTs();
            object = list.get(list.size() - 1).getTs();
            if (object2 != null && object != null && ((Date)object).after((Date)object2) && (d3 = (double)(((Date)object).getTime() - ((Date)object2).getTime()) / 60000.0) > 0.0) {
                d2 = (double)l / d3;
            }
        }
        object2 = RangeTextFormatter.formatPoint(date);
        if (bl) {
            long l4 = list.isEmpty() ? 0L : (long)list.get(list.size() - 1).getQueued().intValue();
            object = this.formatNumber(l4);
            string = "\u2014";
        } else {
            object = this.formatNumber(l);
            string = String.format(Locale.US, "%.1f msg/min", d2);
        }
        this.setQueuedHeader(bl);
        this.setStats((String)object, String.format(Locale.US, "%.1f", d), this.formatNumber(l2), this.formatNumber(l3), (String)object2, string);
        this.updateTitle(string2 + " Statistics Summary");
    }

    @Override
    public void setSeriesColors(Color color, Color color2, Color color3, Color color4, Color color5) {
    }

    private String formatNumber(long l) {
        return String.format(Locale.US, "%,d", l);
    }
}

