/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.channel;

import com.mirth.connect.donkey.model.channel.CronProperty;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesAdvanced;
import com.mirth.connect.donkey.model.channel.PollingType;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.math.NumberUtils;

public class PollConnectorProperties
implements Serializable,
Migratable,
Purgable {
    private PollingType pollingType;
    private boolean pollOnStart;
    private int pollingFrequency;
    private int pollingHour;
    private int pollingMinute;
    private List<CronProperty> cronJobs;
    private PollConnectorPropertiesAdvanced pollConnectorPropertiesAdvanced;

    public PollConnectorProperties() {
        this.pollingType = PollingType.INTERVAL;
        this.pollOnStart = false;
        this.pollingFrequency = 5000;
        this.pollingHour = 0;
        this.pollingMinute = 0;
        this.cronJobs = new ArrayList<CronProperty>();
        this.pollConnectorPropertiesAdvanced = new PollConnectorPropertiesAdvanced();
    }

    public PollConnectorProperties(PollConnectorProperties properties) {
        this.pollingType = properties.getPollingType();
        this.pollOnStart = properties.isPollOnStart();
        this.pollingFrequency = properties.getPollingFrequency();
        this.pollingHour = properties.getPollingHour();
        this.pollingMinute = properties.getPollingMinute();
        ArrayList<CronProperty> cron = new ArrayList<CronProperty>();
        for (CronProperty property : properties.getCronJobs()) {
            cron.add(new CronProperty(property.getDescription(), property.getExpression()));
        }
        this.cronJobs = cron;
        this.pollConnectorPropertiesAdvanced = properties.getPollConnectorPropertiesAdvanced().clone();
    }

    public PollingType getPollingType() {
        return this.pollingType;
    }

    public void setPollingType(PollingType pollingType) {
        this.pollingType = pollingType;
    }

    public void setPollOnStart(boolean pollOnStart) {
        this.pollOnStart = pollOnStart;
    }

    public boolean isPollOnStart() {
        return this.pollOnStart;
    }

    public int getPollingHour() {
        return this.pollingHour;
    }

    public void setPollingHour(int pollingHour) {
        this.pollingHour = pollingHour;
    }

    public int getPollingMinute() {
        return this.pollingMinute;
    }

    public void setPollingMinute(int pollingMinute) {
        this.pollingMinute = pollingMinute;
    }

    public int getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(int pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public List<CronProperty> getCronJobs() {
        return this.cronJobs;
    }

    public void setCronJobs(List<CronProperty> cronJobs) {
        this.cronJobs = cronJobs;
    }

    public PollConnectorPropertiesAdvanced getPollConnectorPropertiesAdvanced() {
        return this.pollConnectorPropertiesAdvanced;
    }

    public void setPollConnectorPropertiesAdvanced(PollConnectorPropertiesAdvanced pollConnectorPropertiesAdvanced) {
        this.pollConnectorPropertiesAdvanced = pollConnectorPropertiesAdvanced;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public PollConnectorProperties clone() {
        return new PollConnectorProperties(this);
    }

    @Override
    public void migrate3_0_1(DonkeyElement element) {
    }

    @Override
    public void migrate3_0_2(DonkeyElement element) {
    }

    @Override
    public void migrate3_1_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_2_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_3_0(DonkeyElement element) {
        DonkeyElement pollingFrequencyElement = element.getChildElement("pollingFrequency");
        int pollingFrequency = NumberUtils.toInt((String)pollingFrequencyElement.getTextContent());
        if (pollingFrequency <= 0) {
            pollingFrequency = 5000;
        } else if (pollingFrequency >= 86400000) {
            pollingFrequency = 86399999;
        }
        pollingFrequencyElement.setTextContent(String.valueOf(pollingFrequency));
        DonkeyElement pollingType = element.getChildElement("pollingType");
        boolean isInterval = pollingType.getTextContent().equals("interval");
        pollingType.setTextContent(isInterval ? "INTERVAL" : "TIME");
        element.addChildElementIfNotExists("pollOnStart", isInterval ? "true" : "false");
        element.addChildElementIfNotExists("cronJobs");
        DonkeyElement advancedProperties = element.addChildElementIfNotExists("pollConnectorPropertiesAdvanced");
        if (advancedProperties != null) {
            advancedProperties.addChildElementIfNotExists("weekly", "true");
            DonkeyElement activeDays = advancedProperties.addChildElementIfNotExists("inactiveDays");
            if (activeDays != null) {
                for (int counter = 0; counter < 8; ++counter) {
                    activeDays.addChildElement("boolean", "false");
                }
            }
            advancedProperties.addChildElementIfNotExists("dayOfMonth", "1");
            advancedProperties.addChildElementIfNotExists("allDay", "true");
            advancedProperties.addChildElementIfNotExists("startingHour", "8");
            advancedProperties.addChildElementIfNotExists("startingMinute", "0");
            advancedProperties.addChildElementIfNotExists("endingHour", "17");
            advancedProperties.addChildElementIfNotExists("endingMinute", "0");
        }
    }

    @Override
    public void migrate3_4_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_5_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_6_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_7_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_9_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_11_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_11_1(DonkeyElement element) {
    }

    @Override
    public void migrate3_12_0(DonkeyElement element) {
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("pollingType", (Object)this.pollingType);
        purgedProperties.put("pollOnStart", this.pollOnStart);
        purgedProperties.put("pollingFrequency", this.pollingFrequency);
        purgedProperties.put("pollingHour", this.pollingHour);
        purgedProperties.put("pollingMinute", this.pollingMinute);
        purgedProperties.put("cronJobsCount", this.cronJobs.size());
        purgedProperties.put("advancedPurgedProperties", this.pollConnectorPropertiesAdvanced.getPurgedProperties());
        return purgedProperties;
    }
}

