/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.channel;

import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class SourceConnectorProperties
implements Serializable,
Migratable,
Purgable {
    public static final String RESPONSE_NONE = "None";
    public static final String RESPONSE_AUTO_BEFORE = "Auto-generate (Before processing)";
    public static final String RESPONSE_SOURCE_TRANSFORMED = "Auto-generate (After source transformer)";
    public static final String RESPONSE_DESTINATIONS_COMPLETED = "Auto-generate (Destinations completed)";
    public static final String RESPONSE_POST_PROCESSOR = "Postprocessor";
    public static final Status[] RESPONSE_STATUS_PRECEDENCE = new Status[]{Status.ERROR, Status.QUEUED, Status.SENT, Status.FILTERED};
    public static final String[] QUEUE_ON_RESPONSES = new String[]{"None", "Auto-generate (Before processing)"};
    public static final String[] QUEUE_OFF_RESPONSES = new String[]{"None", "Auto-generate (Before processing)", "Auto-generate (After source transformer)", "Auto-generate (Destinations completed)", "Postprocessor"};
    private String responseVariable;
    private boolean respondAfterProcessing;
    private boolean processBatch;
    private boolean firstResponse;
    private int processingThreads;
    private Map<String, String> resourceIds;
    private int queueBufferSize;

    public SourceConnectorProperties() {
        this(RESPONSE_NONE);
    }

    public SourceConnectorProperties(String defaultResponse) {
        this.responseVariable = defaultResponse;
        this.respondAfterProcessing = true;
        this.processBatch = false;
        this.firstResponse = false;
        this.processingThreads = 1;
        this.resourceIds = new LinkedHashMap<String, String>();
        this.resourceIds.put("Default Resource", "[Default Resource]");
        this.queueBufferSize = 0;
    }

    public String getResponseVariable() {
        return this.responseVariable;
    }

    public void setResponseVariable(String responseVariable) {
        this.responseVariable = responseVariable;
    }

    public boolean isRespondAfterProcessing() {
        return this.respondAfterProcessing;
    }

    public void setRespondAfterProcessing(boolean respondAfterProcessing) {
        this.respondAfterProcessing = respondAfterProcessing;
    }

    public boolean isProcessBatch() {
        return this.processBatch;
    }

    public void setProcessBatch(boolean processBatch) {
        this.processBatch = processBatch;
    }

    public boolean isFirstResponse() {
        return this.firstResponse;
    }

    public void setFirstResponse(boolean firstResponse) {
        this.firstResponse = firstResponse;
    }

    public int getProcessingThreads() {
        return this.processingThreads;
    }

    public void setProcessingThreads(int processingThreads) {
        this.processingThreads = processingThreads;
    }

    public Map<String, String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Map<String, String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public int getQueueBufferSize() {
        return this.queueBufferSize;
    }

    public void setQueueBufferSize(int queueBufferSize) {
        this.queueBufferSize = queueBufferSize;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public void migrate3_0_1(DonkeyElement element) {
    }

    @Override
    public void migrate3_0_2(DonkeyElement element) {
    }

    @Override
    public void migrate3_1_0(DonkeyElement element) {
        element.addChildElementIfNotExists("processBatch", "false");
        element.addChildElementIfNotExists("firstResponse", "false");
        element.removeChild("defaultQueueOffResponses");
        element.removeChild("defaultQueueOnResponses");
    }

    @Override
    public void migrate3_2_0(DonkeyElement element) {
        DonkeyElement resourceIdsElement = element.addChildElement("resourceIds");
        resourceIdsElement.setAttribute("class", "linked-hash-set");
        resourceIdsElement.addChildElement("string", "Default Resource");
    }

    @Override
    public void migrate3_3_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_4_0(DonkeyElement element) {
        element.addChildElementIfNotExists("processingThreads", "1");
        DonkeyElement resourceIdsElement = element.getChildElement("resourceIds");
        List<DonkeyElement> resourceIdsList = resourceIdsElement.getChildElements();
        resourceIdsElement.removeChildren();
        resourceIdsElement.setAttribute("class", "linked-hash-map");
        for (DonkeyElement resourceId : resourceIdsList) {
            DonkeyElement entry = resourceIdsElement.addChildElement("entry");
            String resourceIdText = resourceId.getTextContent();
            entry.addChildElement("string", resourceIdText);
            if (resourceIdText.equals("Default Resource")) {
                entry.addChildElement("string", "[Default Resource]");
                continue;
            }
            entry.addChildElement("string");
        }
    }

    @Override
    public void migrate3_5_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_6_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_7_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_9_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_11_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_11_1(DonkeyElement element) {
    }

    @Override
    public void migrate3_12_0(DonkeyElement element) {
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("respondAfterProcessing", this.respondAfterProcessing);
        purgedProperties.put("processBatch", this.processBatch);
        purgedProperties.put("firstResponse", this.firstResponse);
        purgedProperties.put("processingThreads", this.processingThreads);
        purgedProperties.put("resourceIdsCount", this.resourceIds.size());
        purgedProperties.put("queueBufferSize", this.queueBufferSize);
        return purgedProperties;
    }
}

