/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.plugins.dynamiclookup.client.panel.LookupTablePanel;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class DataStorePanel
extends JPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private JXTaskPane dataStoreTasks = new CustomTaskPane(this.parent);
    private LookupTablePanel lookupTablePanel;
    private boolean isReordering = false;

    public DataStorePanel() {
        this.dataStoreTasks.setTitle("Data Store");
        this.dataStoreTasks.setName("Data Store");
        this.dataStoreTasks.setFocusable(false);
        this.parent.addTask("doShowLookup", "Lookup Manager", "Contains information about Lookup Table.", "", new ImageIcon(Frame.class.getResource("images/table.png")), this.dataStoreTasks, null, (Object)this);
        this.parent.setNonFocusable(this.dataStoreTasks);
        this.dataStoreTasks.setVisible(true);
        this.keepComponentBefore(this.parent.taskPaneContainer, (Component)this.dataStoreTasks, (Component)this.parent.otherPane);
    }

    private void keepComponentBefore(final JXTaskPaneContainer jXTaskPaneContainer, final Component component, final Component component2) {
        jXTaskPaneContainer.addContainerListener((ContainerListener)new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                DataStorePanel.this.ensureOrder(jXTaskPaneContainer, component, component2);
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                DataStorePanel.this.ensureOrder(jXTaskPaneContainer, component, component2);
            }
        });
        this.ensureOrder(jXTaskPaneContainer, component, component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOrder(JXTaskPaneContainer jXTaskPaneContainer, Component component, Component component2) {
        if (this.isReordering) {
            return;
        }
        this.isReordering = true;
        try {
            Component[] componentArray = jXTaskPaneContainer.getComponents();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == component) {
                    n = i;
                    continue;
                }
                if (componentArray[i] != component2) continue;
                n2 = i;
            }
            if (n2 != -1 && (n == -1 || n != n2 - 1)) {
                jXTaskPaneContainer.remove(component);
                if (n != -1 && n < n2) {
                    --n2;
                }
                jXTaskPaneContainer.add(component, n2);
                jXTaskPaneContainer.revalidate();
                jXTaskPaneContainer.repaint();
            }
        }
        finally {
            this.isReordering = false;
        }
    }

    public void unBold() {
        this.parent.setBold(this.dataStoreTasks, -1);
    }

    public void doShowLookup() {
        if (this.lookupTablePanel == null) {
            this.lookupTablePanel = new LookupTablePanel(this);
        }
        if (!this.parent.confirmLeave()) {
            return;
        }
        this.parent.setBold(this.parent.viewPane, -1);
        this.parent.setBold(this.dataStoreTasks, 0);
        this.parent.setPanelName("Lookup Manager");
        this.parent.setCurrentContentPage((Component)this.lookupTablePanel);
        this.parent.setFocus(this.dataStoreTasks);
        this.lookupTablePanel.doRefresh();
    }

    private class CustomTaskPane
    extends JXTaskPane {
        private Frame parent;

        public CustomTaskPane(Frame frame) {
            this.parent = frame;
        }

        public void setVisible(boolean bl) {
            if (!(bl || this.parent.currentContentPage == null || this.parent.channelEditPanel == null || this.parent.channelEditPanel.transformerPane == null || this.parent.channelEditPanel.filterPane == null || this.parent.currentContentPage != this.parent.channelEditPanel.transformerPane && this.parent.currentContentPage != this.parent.channelEditPanel.filterPane)) {
                super.setVisible(false);
                return;
            }
            super.setVisible(true);
        }
    }
}

