/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.plugins.dynamiclookup.client.dialog.LookupSettingDialog;
import com.mirth.connect.plugins.dynamiclookup.client.panel.CacheStatusPanel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.DataStorePanel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.DetailsPanel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.GroupPanel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.HistoryPanel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.ValuePanel;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupTablePanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DataStorePanel taskPane;
    private final GroupPanel groupPanel;
    private final DetailsPanel detailsPanel;
    private final ValuePanel valuePanel;
    private final CacheStatusPanel cachePanel;
    private final HistoryPanel historyPanel;
    private final JTabbedPane tabbedPane;
    private JButton settingsButton;
    private final Frame parent = PlatformUI.MIRTH_FRAME;

    public LookupTablePanel(DataStorePanel dataStorePanel) {
        this.taskPane = dataStorePanel;
        this.groupPanel = new GroupPanel();
        this.detailsPanel = new DetailsPanel();
        this.valuePanel = new ValuePanel();
        this.cachePanel = new CacheStatusPanel();
        this.historyPanel = new HistoryPanel();
        this.tabbedPane = new JTabbedPane();
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.groupPanel.addGroupSelectionListener(listSelectionEvent -> {
            LookupGroup lookupGroup = this.groupPanel.getSelectedGroup();
            int n = this.tabbedPane.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.detailsPanel.updateDetails(lookupGroup);
                    break;
                }
                case 1: {
                    this.valuePanel.updateValues(lookupGroup);
                    break;
                }
                case 2: {
                    this.cachePanel.updateCaches(lookupGroup);
                    break;
                }
                case 3: {
                    this.historyPanel.updateHistory(lookupGroup);
                }
            }
        });
        this.tabbedPane.addChangeListener(changeEvent -> {
            LookupGroup lookupGroup = this.groupPanel.getSelectedGroup();
            int n = this.tabbedPane.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.detailsPanel.updateDetails(lookupGroup);
                    break;
                }
                case 1: {
                    this.valuePanel.updateValues(lookupGroup);
                    break;
                }
                case 2: {
                    this.cachePanel.updateCaches(lookupGroup);
                    break;
                }
                case 3: {
                    this.historyPanel.updateCachedUserMap();
                    this.historyPanel.updateHistory(lookupGroup);
                }
            }
        });
        this.settingsButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.settingsButton.addActionListener(actionEvent -> new LookupSettingDialog(this.parent));
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, wrap 1", "[grow]", "[][grow]"));
        this.add((Component)this.buildTopActionBar(), "growx");
        this.tabbedPane.addTab("Details", this.detailsPanel);
        this.tabbedPane.addTab("Values", this.valuePanel);
        this.tabbedPane.addTab("Cache Status", this.cachePanel);
        this.tabbedPane.addTab("History", this.historyPanel);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setLeftComponent(this.groupPanel);
        jSplitPane.setRightComponent(this.tabbedPane);
        this.add((Component)jSplitPane, "grow, push");
    }

    private JComponent buildTopActionBar() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 2 4 2 4, novisualpadding, fillx", "[grow][]", "[]"));
        jPanel.add(Box.createHorizontalStrut(0), "growx");
        jPanel.add((Component)this.settingsButton, "");
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(200, 200, 200)));
        return jPanel;
    }

    public void doRefresh() {
        final String string = this.parent.startWorking("Loading lookup groups...");
        SwingWorker<List<LookupGroup>, Void> swingWorker = new SwingWorker<List<LookupGroup>, Void>(){

            @Override
            public List<LookupGroup> doInBackground() throws ClientException {
                return LookupServiceClient.getInstance().getAllGroups();
            }

            @Override
            public void done() {
                try {
                    LookupTablePanel.this.groupPanel.updateGroupTable((List)this.get());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof ExecutionException) {
                        throwable2 = throwable.getCause();
                    }
                    LookupTablePanel.this.parent.alertThrowable((Component)LookupTablePanel.this.parent, throwable2, "Error loading groups: " + throwable2.toString());
                }
                finally {
                    LookupTablePanel.this.parent.stopWorking(string);
                }
            }
        };
        swingWorker.execute();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.taskPane.unBold();
    }
}

