/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.client.dialog.LookupValueDialog;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.model.LookupValueTableModel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.ButtonEditor;
import com.mirth.connect.plugins.dynamiclookup.client.panel.ButtonRenderer;
import com.mirth.connect.plugins.dynamiclookup.client.panel.NoGroupSelectedPanel;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.client.util.FileChooser;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ImportValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupAllValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import com.mirth.connect.plugins.dynamiclookup.shared.util.CsvLineParser;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValuePanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final com.mirth.connect.client.ui.Frame parent = PlatformUI.MIRTH_FRAME;
    private JPanel noGroupSelectedPanel;
    private JPanel contentPanel;
    private JTable valueTable;
    private LookupValueTableModel valueTableModel;
    private JTextField valueFilterField;
    private JButton searchButton;
    private JButton addValueButton;
    private JButton removeSelectedButton;
    private JButton importCsvButton;
    private JButton exportButton;
    private JButton prevPageButton;
    private JButton nextPageButton;
    private JButton goToPageButton;
    private JLabel pageInfoLabel;
    private JComboBox<Integer> pageSizeComboBox;
    private JLabel entriesInfoLabel;
    private LookupGroup selectedGroup;
    private int currentPage = 1;
    private int pageSize = 25;
    private int totalCount = 0;

    public ValuePanel() {
        this.initComponents();
        this.initLayout();
        this.updateValues(null);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.noGroupSelectedPanel = new NoGroupSelectedPanel();
        this.valueFilterField = new JTextField();
        this.valueFilterField.setToolTipText("Filter values by key or value");
        this.valueFilterField.addActionListener(actionEvent -> {
            this.currentPage = 1;
            this.loadPage(this.currentPage);
        });
        this.valueTableModel = new LookupValueTableModel();
        this.valueTable = new JTable(this.valueTableModel);
        this.valueTable.setRowHeight(26);
        this.valueTable.getColumnModel().getColumn(3).setCellRenderer(new ButtonRenderer());
        this.valueTable.getColumnModel().getColumn(3).setCellEditor(new ButtonEditor(this.valueTable, this.valueTableModel, actionEvent -> this.handleEditValue((Integer)actionEvent.getSource()), actionEvent -> this.handleRemoveValue((Integer)actionEvent.getSource())));
        this.valueTable.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.valueTable.getColumnModel().getColumn(3).setMinWidth(120);
        this.valueTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                boolean bl = this.valueTable.getSelectedRowCount() > 0;
                this.removeSelectedButton.setEnabled(bl);
            }
        });
        this.searchButton = new JButton("Search", UIManager.getIcon("FileView.fileIcon"));
        this.searchButton.setIcon(UIConstants.ICON_FILE_PICKER);
        this.searchButton.setToolTipText("Search");
        this.searchButton.setIconTextGap(5);
        this.searchButton.addActionListener(actionEvent -> {
            this.currentPage = 1;
            this.loadPage(this.currentPage);
        });
        this.addValueButton = new JButton("Add");
        this.addValueButton.addActionListener(actionEvent -> this.handleAddValue());
        this.removeSelectedButton = new JButton("Remove Selected");
        this.removeSelectedButton.addActionListener(actionEvent -> this.handleRemoveSeleted());
        this.removeSelectedButton.setEnabled(false);
        this.importCsvButton = new JButton("Import Csv");
        this.importCsvButton.addActionListener(actionEvent -> this.handleImportCsv());
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(actionEvent -> this.handleExport());
        this.prevPageButton = new JButton("Previous");
        this.prevPageButton.addActionListener(actionEvent -> this.goToPage(this.currentPage - 1));
        this.nextPageButton = new JButton("Next");
        this.nextPageButton.addActionListener(actionEvent -> this.goToPage(this.currentPage + 1));
        this.goToPageButton = new JButton("Go");
        this.goToPageButton.addActionListener(actionEvent -> this.showGoToPageDialog());
        this.pageInfoLabel = new JLabel("Page 1");
        this.entriesInfoLabel = new JLabel("Showing 0 to 0 of 0 entries");
        this.pageSizeComboBox = new JComboBox<Integer>(new Integer[]{10, 25, 50, 100, 200, 500, 1000});
        this.pageSizeComboBox.setSelectedItem(this.pageSize);
        this.pageSizeComboBox.addActionListener(actionEvent -> {
            int n = (Integer)this.pageSizeComboBox.getSelectedItem();
            if (n != this.pageSize) {
                this.currentPage = 1;
                this.pageSize = n;
                this.loadPage(this.currentPage);
            }
        });
    }

    private void initLayout() {
        this.setLayout(new CardLayout());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("insets 8, fill"));
        this.contentPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fill", "", ""));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.add((Component)this.valueFilterField, "w 150!, growx, split 2");
        jPanel.add(this.searchButton);
        jPanel.add((Component)this.addValueButton, "gapleft push, split 4");
        jPanel.add(this.removeSelectedButton);
        jPanel.add(this.importCsvButton);
        jPanel.add(this.exportButton);
        this.contentPanel.add((Component)jPanel, "growx, wrap");
        this.contentPanel.add((Component)new JScrollPane(this.valueTable), "grow, push, wrap");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel3.add(new JLabel("Page size:"));
        jPanel3.add(this.pageSizeComboBox);
        jPanel3.add(this.entriesInfoLabel);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel4.add(this.prevPageButton);
        jPanel4.add(this.pageInfoLabel);
        jPanel4.add(this.nextPageButton);
        jPanel4.add(this.goToPageButton);
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)jPanel4, "East");
        this.contentPanel.add((Component)jPanel2, "growx, wrap");
        this.add((Component)this.contentPanel, "content");
        this.add((Component)this.noGroupSelectedPanel, "noGroup");
    }

    public void updateValues(LookupGroup lookupGroup) {
        boolean bl = lookupGroup != null;
        this.contentPanel.setVisible(bl);
        this.noGroupSelectedPanel.setVisible(!bl);
        if (!Objects.equals(this.selectedGroup, lookupGroup)) {
            this.valueFilterField.setText("");
        }
        this.selectedGroup = lookupGroup;
        this.currentPage = 1;
        this.loadPage(this.currentPage);
    }

    private void loadPage(final int n) {
        this.valueTableModel.clear();
        if (this.selectedGroup == null) {
            return;
        }
        final int n2 = (n - 1) * this.pageSize;
        new SwingWorker<LookupAllValuesResponse, Void>(){

            @Override
            protected LookupAllValuesResponse doInBackground() throws Exception {
                String string = ValuePanel.this.valueFilterField.getText().trim();
                return LookupServiceClient.getInstance().getAllValues(ValuePanel.this.selectedGroup.getId(), n2, ValuePanel.this.pageSize, string);
            }

            @Override
            protected void done() {
                try {
                    LookupAllValuesResponse lookupAllValuesResponse = (LookupAllValuesResponse)this.get();
                    List list = lookupAllValuesResponse.getValues();
                    ValuePanel.this.totalCount = lookupAllValuesResponse.getTotalCount();
                    ValuePanel.this.valueTableModel.setValues(list);
                    ValuePanel.this.currentPage = n;
                    ValuePanel.this.updatePaginationControls();
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof LookupApiClientException) {
                        ValuePanel.this.showError("Failed to load values: " + throwable.getMessage());
                    } else {
                        ValuePanel.this.logger.error("Unexpected error while loading values", (Throwable)executionException);
                        ValuePanel.this.showError("An unexpected error occurred: " + throwable.getMessage());
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ValuePanel.this.showError("Operation was interrupted.");
                }
            }
        }.execute();
    }

    private void updatePaginationControls() {
        int n = (int)Math.ceil((double)this.totalCount / (double)this.pageSize);
        if (n == 0) {
            this.pageInfoLabel.setText("Page 0 of 0");
        } else {
            this.pageInfoLabel.setText("Page " + this.currentPage + " of " + n);
        }
        if (this.totalCount == 0) {
            this.entriesInfoLabel.setText("Showing 0 to 0 of 0 entries");
        } else {
            int n2 = (this.currentPage - 1) * this.pageSize + 1;
            int n3 = Math.min(this.currentPage * this.pageSize, this.totalCount);
            this.entriesInfoLabel.setText("Showing " + n2 + " to " + n3 + " of " + this.totalCount + " entries");
        }
        this.prevPageButton.setEnabled(this.currentPage > 1);
        this.nextPageButton.setEnabled(this.currentPage < n);
    }

    private void goToPage(int n) {
        if (n >= 1 && (n - 1) * this.pageSize < this.totalCount) {
            this.loadPage(n);
        }
    }

    private void showGoToPageDialog() {
        Integer n;
        int n2;
        if (this.totalCount == 0) {
            return;
        }
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        int n3 = (int)Math.ceil((double)this.totalCount / (double)this.pageSize);
        for (n2 = 1; n2 <= n3; ++n2) {
            jComboBox.addItem(n2);
        }
        n2 = JOptionPane.showConfirmDialog(this, jComboBox, "Select Page", 2);
        if (n2 == 0 && (n = (Integer)jComboBox.getSelectedItem()) != null) {
            this.loadPage(n);
        }
    }

    private void setPaginationControlsEnabled(boolean bl) {
        this.prevPageButton.setEnabled(bl);
        this.nextPageButton.setEnabled(bl);
        this.pageSizeComboBox.setEnabled(bl);
    }

    private void handleAddValue() {
        if (this.selectedGroup != null) {
            LookupValue lookupValue = new LookupValue();
            LookupValueDialog lookupValueDialog = new LookupValueDialog(this.parent, lookupValue, this.selectedGroup, false);
            if (lookupValueDialog.isSaved()) {
                this.currentPage = 1;
                this.loadPage(this.currentPage);
            }
        } else {
            this.showError("Please select a Group");
        }
    }

    private void handleRemoveSeleted() {
        Object object;
        if (this.selectedGroup == null) {
            return;
        }
        int[] nArray = this.valueTable.getSelectedRows();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected.", "Delete", 2);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Delete " + nArray.length + " selected values?", "Confirm Delete", 0);
        if (n != 0) {
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (int n2 : nArray) {
            int n3 = this.valueTable.convertRowIndexToModel(n2);
            object = this.valueTableModel.getValue(n3);
            arrayList.add(object.getKeyValue());
        }
        Object object2 = new JDialog((Frame)this.parent, "Deleting Values", true);
        final JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setStringPainted(true);
        final JLabel jLabel = new JLabel("Deleted 0 of " + arrayList.size());
        JButton jButton = new JButton("Cancel");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        ((JDialog)object2).setLayout(new BorderLayout(10, 10));
        ((Container)object2).add((Component)jLabel, "North");
        ((Container)object2).add((Component)jProgressBar, "Center");
        ((Container)object2).add((Component)jPanel, "South");
        ((Window)object2).setSize(350, 120);
        ((Window)object2).setLocationRelativeTo((Component)this.parent);
        ((JDialog)object2).setDefaultCloseOperation(0);
        object = new SwingWorker<Void, int[]>((JDialog)object2){
            private final List<String> failedKeys = new ArrayList<String>();
            private int processed = 0;
            final /* synthetic */ JDialog val$progressDialog;
            {
                this.val$progressDialog = jDialog;
            }

            @Override
            protected Void doInBackground() {
                for (String string : arrayList) {
                    if (this.isCancelled()) break;
                    try {
                        LookupServiceClient.getInstance().deleteValue(ValuePanel.this.selectedGroup.getId(), string);
                    }
                    catch (Exception exception) {
                        ValuePanel.this.logger.warn("Failed to delete key '{}' in group {}: {}", (Object)string, (Object)ValuePanel.this.selectedGroup.getId(), (Object)exception.getMessage());
                        this.failedKeys.add(string);
                    }
                    ++this.processed;
                    this.publishProgress(this.processed, arrayList.size());
                }
                return null;
            }

            private void publishProgress(int n, int n2) {
                int n3 = n2 > 0 ? (int)((double)n / (double)n2 * 100.0) : 0;
                n3 = Math.min(n3, 100);
                this.publish((V[])new int[][]{{n3, n, n2}});
            }

            @Override
            protected void process(List<int[]> list) {
                if (!list.isEmpty()) {
                    int[] nArray = list.get(list.size() - 1);
                    int n = nArray[0];
                    int n2 = nArray[1];
                    int n3 = nArray[2];
                    jProgressBar.setValue(n);
                    jLabel.setText("Deleted " + n2 + " of " + n3);
                }
            }

            @Override
            protected void done() {
                block8: {
                    try {
                        this.val$progressDialog.dispose();
                        this.get();
                        ValuePanel.this.updateValues(ValuePanel.this.selectedGroup);
                        if (this.isCancelled()) {
                            JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "Delete was cancelled. Completed " + this.processed + "/" + arrayList.size() + ".", "Delete Cancelled", 2);
                            break block8;
                        }
                        if (this.failedKeys.isEmpty()) {
                            JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "Deleted " + this.processed + " values.", "Delete Complete", 1);
                            break block8;
                        }
                        Object object = String.join((CharSequence)", ", this.failedKeys);
                        if (((String)object).length() > 200) {
                            object = ((String)object).substring(0, 200) + "...";
                        }
                        JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "Deleted " + (this.processed - this.failedKeys.size()) + "/" + arrayList.size() + ". Failed: " + this.failedKeys.size() + " (" + (String)object + ")", "Delete Completed with Errors", 2);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        ValuePanel.this.showError("Delete failed: " + (throwable != null && throwable.getMessage() != null ? throwable.getMessage() : executionException.getClass().getSimpleName()));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        ValuePanel.this.showError("Delete was interrupted.");
                    }
                }
            }
        };
        jButton.addActionListener(arg_0 -> ValuePanel.lambda$handleRemoveSeleted$13((SwingWorker)object, arg_0));
        ((Window)object2).addWindowListener(new WindowAdapter((JDialog)object2, (SwingWorker)object){
            final /* synthetic */ JDialog val$progressDialog;
            final /* synthetic */ SwingWorker val$worker;
            {
                this.val$progressDialog = jDialog;
                this.val$worker = swingWorker;
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n = JOptionPane.showConfirmDialog(this.val$progressDialog, "Delete is in progress. Do you want to cancel?", "Confirm Cancel", 0);
                if (n == 0) {
                    this.val$worker.cancel(true);
                }
            }
        });
        ((SwingWorker)object).execute();
        ((Dialog)object2).setVisible(true);
    }

    private void handleEditValue(int n) {
        if (n >= 0) {
            LookupValueDialog lookupValueDialog;
            LookupValue lookupValue = this.valueTableModel.getValue(n);
            LookupValue lookupValue2 = new LookupValue(lookupValue);
            if (this.selectedGroup != null && (lookupValueDialog = new LookupValueDialog(this.parent, lookupValue2, this.selectedGroup, true)).isSaved()) {
                this.loadPage(this.currentPage);
            }
        }
    }

    private void handleRemoveValue(int n) {
        int n2;
        LookupValue lookupValue = this.valueTableModel.getValue(n);
        if (n >= 0 && (n2 = JOptionPane.showConfirmDialog((Component)this.parent, "Are you sure you want to delete value with key: " + lookupValue.getKeyValue() + "?", "Confirm Delete", 0)) == 0 && this.selectedGroup != null) {
            try {
                LookupServiceClient.getInstance().deleteValue(this.selectedGroup.getId(), lookupValue.getKeyValue());
                this.loadPage(this.currentPage);
            }
            catch (LookupApiClientException lookupApiClientException) {
                this.showError(lookupApiClientException.getError().getMessage());
            }
            catch (Exception exception) {
                this.logger.error("Unexpected error while remove value", (Throwable)exception);
                this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
            }
        }
    }

    private void handleImportCsv() {
        File file;
        if (this.selectedGroup == null) {
            this.showError("Please select a Group");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileNameExtensionFilter("CSV files", "csv"));
        File file2 = new File(com.mirth.connect.client.ui.Frame.userPreferences.get("currentDirectory", ""));
        if (file2.exists()) {
            jFileChooser.setCurrentDirectory(file2);
        }
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (!this.checkCsvFile(file)) {
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "Do you want to clear existing values before import?", "Clear Existing Values?", 0);
            final boolean bl = n == 0;
            final JDialog jDialog = new JDialog((Frame)this.parent, "Importing CSV", true);
            final JProgressBar jProgressBar = new JProgressBar(0, 100);
            jProgressBar.setStringPainted(true);
            final JLabel jLabel = new JLabel("Imported 0 of ? entries");
            JButton jButton = new JButton("Cancel");
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(jButton);
            jDialog.setLayout(new BorderLayout(10, 10));
            jDialog.add((Component)jLabel, "North");
            jDialog.add((Component)jProgressBar, "Center");
            jDialog.add((Component)jPanel, "South");
            jDialog.setSize(350, 120);
            jDialog.setLocationRelativeTo((Component)this.parent);
            jDialog.setDefaultCloseOperation(0);
            final SwingWorker<Void, int[]> swingWorker = new SwingWorker<Void, int[]>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                        int n = -1;
                        while (bufferedReader.readLine() != null) {
                            ++n;
                        }
                        try (BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file));){
                            String string;
                            boolean bl3 = true;
                            boolean bl2 = true;
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = 100;
                            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                            HashSet<String> hashSet = new HashSet<String>();
                            while ((string = bufferedReader2.readLine()) != null && !this.isCancelled()) {
                                ++n2;
                                if (bl3) {
                                    bl3 = false;
                                    continue;
                                }
                                if (string.trim().isEmpty()) continue;
                                Map.Entry entry = CsvLineParser.parseLine((String)string, (int)n2);
                                if (entry == null) {
                                    ValuePanel.this.logger.error("Skipping malformed or empty entry at line " + n2 + ": " + string);
                                    continue;
                                }
                                String string2 = (String)entry.getKey();
                                if (!hashSet.add(string2) || linkedHashMap.containsKey(string2)) continue;
                                linkedHashMap.put((String)entry.getKey(), (String)entry.getValue());
                                this.publishProgress(++n3, n);
                                if (linkedHashMap.size() != n4) continue;
                                ValuePanel.this.importValues(ValuePanel.this.selectedGroup.getId(), linkedHashMap, bl && bl2);
                                linkedHashMap.clear();
                                bl2 = false;
                            }
                            if (!this.isCancelled() && !linkedHashMap.isEmpty()) {
                                ValuePanel.this.importValues(ValuePanel.this.selectedGroup.getId(), linkedHashMap, bl && bl2);
                            }
                            com.mirth.connect.client.ui.Frame.userPreferences.put("currentDirectory", file.getParent());
                        }
                    }
                    catch (Exception exception) {
                        ValuePanel.this.logger.error("Failed to import lookup values from CSV file", (Throwable)exception);
                        throw exception;
                    }
                    return null;
                }

                private void publishProgress(int n, int n2) {
                    int n3 = n2 > 0 ? (int)((double)n / (double)n2 * 100.0) : 0;
                    n3 = Math.min(n3, 100);
                    this.publish((V[])new int[][]{{n3, n, n2}});
                }

                @Override
                protected void process(List<int[]> list) {
                    if (!list.isEmpty()) {
                        int[] nArray = list.get(list.size() - 1);
                        int n = nArray[0];
                        int n2 = nArray[1];
                        int n3 = nArray[2];
                        jProgressBar.setValue(n);
                        jLabel.setText("Imported " + n2 + " of " + n3 + " entries");
                    }
                }

                @Override
                protected void done() {
                    jDialog.dispose();
                    ValuePanel.this.updateValues(ValuePanel.this.selectedGroup);
                    if (this.isCancelled()) {
                        JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "CSV import was cancelled.", "Import Cancelled", 2);
                        return;
                    }
                    try {
                        this.get();
                        JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "CSV import completed.", "Import Complete", 1);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        ValuePanel.this.showError("Import failed: " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getSimpleName()));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        ValuePanel.this.showError("Import was interrupted.");
                    }
                }
            };
            jButton.addActionListener(actionEvent -> swingWorker.cancel(true));
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    int n = JOptionPane.showConfirmDialog(jDialog, "Import is still in progress. Do you want to cancel?", "Confirm Cancel", 0);
                    if (n == 0) {
                        swingWorker.cancel(true);
                    }
                }
            });
            swingWorker.execute();
            jDialog.setVisible(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCsvFile(File file) {
        String string;
        Object object;
        if (!file.getName().toLowerCase().endsWith(".csv")) {
            this.showError("File does not have a .csv extension.");
            return false;
        }
        try {
            object = file.toPath();
            string = Files.probeContentType((Path)object);
            if (string == null || !string.equals("text/plain") && !string.equals("text/csv") && !string.equals("application/vnd.ms-excel") && !string.startsWith("text/")) {
                this.showError("File does not appear to be a valid CSV (detected type: " + string + ").");
                return false;
            }
        }
        catch (IOException iOException) {
            this.showError("Failed to detect file type: " + iOException.getMessage());
            return false;
        }
        try {
            object = new BufferedReader(new FileReader(file));
            try {
                string = ((BufferedReader)object).readLine();
                if (string != null) {
                    if (string.split(",", -1).length >= 2) return true;
                }
                this.showError("CSV file must contain at least two columns: key and value.");
                boolean bl = false;
                return bl;
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            this.showError("Failed to read file for content validation: " + iOException.getMessage());
            return false;
        }
    }

    private void importValues(Integer n, Map<String, String> map, boolean bl) {
        try {
            ImportValuesResponse importValuesResponse = LookupServiceClient.getInstance().importValues(n, bl, map);
        }
        catch (LookupApiClientException lookupApiClientException) {
            this.showError(lookupApiClientException.getError().getMessage());
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while importing values", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
    }

    private void handleExport() {
        if (this.selectedGroup == null) {
            this.showError("Please select a Group");
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm");
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        String string2 = "all_values_" + string + ".csv";
        final File file = new FileChooser().createFileForExport(this.parent, string2, "csv");
        if (file == null) {
            return;
        }
        final JDialog jDialog = new JDialog((Frame)this.parent, "Exporting CSV", true);
        final JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setStringPainted(true);
        final JLabel jLabel = new JLabel("Exported 0 of ? entries");
        JButton jButton = new JButton("Cancel");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jDialog.setLayout(new BorderLayout(10, 10));
        jDialog.add((Component)jLabel, "North");
        jDialog.add((Component)jProgressBar, "Center");
        jDialog.add((Component)jPanel, "South");
        jDialog.setSize(350, 120);
        jDialog.setLocationRelativeTo((Component)this.parent);
        jDialog.setDefaultCloseOperation(0);
        final SwingWorker<Void, int[]> swingWorker = new SwingWorker<Void, int[]>(){

            @Override
            protected Void doInBackground() throws Exception {
                int n = 0;
                int n2 = 1000;
                int n3 = 0;
                int n4 = -1;
                boolean bl = false;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                    LookupAllValuesResponse lookupAllValuesResponse;
                    List list;
                    while (!this.isCancelled() && (list = (lookupAllValuesResponse = LookupServiceClient.getInstance().getAllValues(ValuePanel.this.selectedGroup.getId(), n, n2, "")).getValues()) != null && !list.isEmpty()) {
                        if (!bl) {
                            bufferedWriter.write("key,value");
                            bufferedWriter.newLine();
                            bl = true;
                        }
                        for (LookupValue lookupValue : list) {
                            if (this.isCancelled()) break;
                            bufferedWriter.write(String.format("%s,%s", ValuePanel.this.escapeCsv(lookupValue.getKeyValue()), ValuePanel.this.escapeCsv(lookupValue.getValueData())));
                            bufferedWriter.newLine();
                            ++n3;
                            if (n4 < 0) {
                                n4 = lookupAllValuesResponse.getTotalCount();
                            }
                            this.publishProgress(n3, n4);
                        }
                        if (list.size() < n2 || this.isCancelled()) break;
                        n += n2;
                    }
                    com.mirth.connect.client.ui.Frame.userPreferences.put("currentDirectory", file.getParent());
                }
                catch (Exception exception) {
                    ValuePanel.this.logger.error("Failed to export values to CSV", (Throwable)exception);
                    throw exception;
                }
                return null;
            }

            private void publishProgress(int n, int n2) {
                int n3 = n2 > 0 ? (int)((double)n / (double)n2 * 100.0) : 0;
                n3 = Math.min(n3, 100);
                this.publish((V[])new int[][]{{n3, n, n2}});
            }

            @Override
            protected void process(List<int[]> list) {
                if (!list.isEmpty()) {
                    int[] nArray = list.get(list.size() - 1);
                    jProgressBar.setValue(nArray[0]);
                    jLabel.setText("Exported " + nArray[1] + " of " + nArray[2] + " entries");
                }
            }

            @Override
            protected void done() {
                jDialog.dispose();
                if (this.isCancelled()) {
                    JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "Export cancelled by user.", "Cancelled", 2);
                    return;
                }
                try {
                    this.get();
                    JOptionPane.showMessageDialog((Component)ValuePanel.this.parent, "CSV export completed.", "Export Complete", 1);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    ValuePanel.this.showError("Export failed: " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getSimpleName()));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ValuePanel.this.showError("Export was interrupted.");
                }
            }
        };
        jButton.addActionListener(actionEvent -> swingWorker.cancel(true));
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n = JOptionPane.showConfirmDialog(jDialog, "Export is still in progress. Do you want to cancel?", "Confirm Cancel", 0);
                if (n == 0) {
                    swingWorker.cancel(true);
                }
            }
        });
        swingWorker.execute();
        jDialog.setVisible(true);
    }

    private String escapeCsv(String string) {
        if (string == null) {
            return "";
        }
        if (string.contains(",") || string.contains("\"") || string.contains("\n")) {
            string = string.replace("\"", "\"\"");
            return "\"" + string + "\"";
        }
        return string;
    }

    private void showInformation(String string) {
        PlatformUI.MIRTH_FRAME.alertInformation((Component)this.parent, string);
    }

    private void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)this.parent, string);
    }
}

