/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthEditableComboBox;
import com.mirth.connect.client.ui.components.MirthIconTextField;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.ws.DefinitionServiceMap;
import com.mirth.connect.connectors.ws.SSLWarningPanel;
import com.mirth.connect.connectors.ws.WebServiceConnectorServletInterface;
import com.mirth.connect.connectors.ws.WebServiceDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.TokenMarker;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;

public class WebServiceSender
extends ConnectorSettingsPanel {
    protected static final ImageIcon ICON_LOCK_X = new ImageIcon(Frame.class.getResource("images/lock_x.png"));
    protected static final Color COLOR_SSL_NOT_CONFIGURED = new Color(0xFFF099);
    protected static final String SSL_TOOL_TIP = "<html>The default system certificate store will be used for this connection.<br/>As a result, certain security options are not available and mutual<br/>authentication (two-way authentication) is not supported.</html>";
    private final int ID_COLUMN_NUMBER = 0;
    private final int CONTENT_COLUMN_NUMBER = 1;
    private final int MIME_TYPE_COLUMN_NUMBER = 2;
    private final String ID_COLUMN_NAME = "ID";
    private final String CONTENT_COLUMN_NAME = "Content";
    private final String MIME_TYPE_COLUMN_NAME = "MIME Type";
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String NAME_COLUMN_NAME = "Name";
    private final String VALUE_COLUMN_NAME = "Value";
    private int headerLastIndex = -1;
    ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private DefinitionServiceMap currentServiceMap;
    protected JLabel wsdlUrlLabel;
    protected MirthIconTextField wsdlUrlField;
    protected JButton getOperationsButton;
    protected JButton wsdlUrlTestConnectionButton;
    protected JLabel serviceLabel;
    protected MirthEditableComboBox serviceComboBox;
    protected JLabel portLabel;
    protected MirthEditableComboBox portComboBox;
    protected JLabel locationURILabel;
    protected MirthEditableComboBox locationURIComboBox;
    protected JButton locationURITestConnectionButton;
    protected JLabel socketTimeoutLabel;
    protected MirthTextField socketTimeoutField;
    protected JLabel authenticationLabel;
    protected MirthRadioButton authenticationYesRadio;
    protected MirthRadioButton authenticationNoRadio;
    protected JLabel usernameLabel;
    protected MirthTextField usernameField;
    protected JLabel passwordLabel;
    protected MirthPasswordField passwordField;
    protected JLabel invocationTypeLabel;
    protected MirthRadioButton invocationOneWayRadio;
    protected MirthRadioButton invocationTwoWayRadio;
    protected JLabel operationLabel;
    protected MirthComboBox operationComboBox;
    protected JButton generateEnvelopeButton;
    protected JLabel soapActionLabel;
    protected MirthIconTextField soapActionField;
    protected JLabel soapEnvelopeLabel;
    protected MirthSyntaxTextArea soapEnvelopeTextArea;
    protected JLabel headersLabel;
    protected MirthTable headersTable;
    protected JScrollPane headersScrollPane;
    protected JButton headersNewButton;
    protected JButton headersDeleteButton;
    protected MirthTextField headersVariableField;
    protected MirthRadioButton useHeadersTableRadio;
    protected MirthRadioButton useHeadersVariableRadio;
    protected JLabel useMtomLabel;
    protected MirthRadioButton useMtomYesRadio;
    protected MirthRadioButton useMtomNoRadio;
    protected JLabel attachmentsLabel;
    protected MirthTable attachmentsTable;
    protected JScrollPane attachmentsScrollPane;
    protected JButton attachmentsNewButton;
    protected JButton attachmentsDeleteButton;
    protected MirthTextField attachmentsVariableField;
    protected MirthRadioButton useAttachmentsTableRadio;
    protected MirthRadioButton useAttachmentsVariableRadio;
    protected SSLWarningPanel sslWarningPanel;

    public WebServiceSender() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
    }

    public String getConnectorName() {
        return new WebServiceDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        WebServiceDispatcherProperties properties = new WebServiceDispatcherProperties();
        properties.setWsdlUrl(this.wsdlUrlField.getText());
        properties.setService(StringUtils.trimToEmpty((String)((String)this.serviceComboBox.getEditor().getItem())));
        properties.setPort(StringUtils.trimToEmpty((String)((String)this.portComboBox.getEditor().getItem())));
        properties.setLocationURI(StringUtils.trimToEmpty((String)((String)this.locationURIComboBox.getEditor().getItem())));
        properties.setSocketTimeout(this.socketTimeoutField.getText());
        properties.setSoapAction(this.soapActionField.getText());
        properties.setOneWay(this.invocationOneWayRadio.isSelected());
        if (this.operationComboBox.getSelectedIndex() != -1) {
            properties.setOperation((String)this.operationComboBox.getSelectedItem());
        }
        properties.setUseAuthentication(this.authenticationYesRadio.isSelected());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setEnvelope(this.soapEnvelopeTextArea.getText());
        ArrayList<String> operations = new ArrayList<String>();
        for (int i = 0; i < this.operationComboBox.getModel().getSize(); ++i) {
            operations.add((String)this.operationComboBox.getModel().getElementAt(i));
        }
        properties.setWsdlDefinitionMap(this.currentServiceMap);
        properties.setHeadersMap(this.getHeaderProperties());
        properties.setUseHeadersVariable(this.useHeadersVariableRadio.isSelected());
        properties.setHeadersVariable(this.headersVariableField.getText());
        properties.setUseMtom(this.useMtomYesRadio.isSelected());
        List<List<String>> attachments = this.getAttachments();
        properties.setAttachmentNames(attachments.get(0));
        properties.setAttachmentContents(attachments.get(1));
        properties.setAttachmentTypes(attachments.get(2));
        properties.setUseAttachmentsVariable(this.useAttachmentsVariableRadio.isSelected());
        properties.setAttachmentsVariable(this.attachmentsVariableField.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        WebServiceDispatcherProperties props = (WebServiceDispatcherProperties)properties;
        this.wsdlUrlField.setText(props.getWsdlUrl());
        this.soapEnvelopeTextArea.setText(props.getEnvelope());
        this.socketTimeoutField.setText(props.getSocketTimeout());
        if (props.isUseAuthentication()) {
            this.authenticationYesRadio.setSelected(true);
            this.authenticationYesRadioActionPerformed(null);
        } else {
            this.authenticationNoRadio.setSelected(true);
            this.authenticationNoRadioActionPerformed(null);
        }
        this.usernameField.setText(props.getUsername());
        this.passwordField.setText(props.getPassword());
        if (props.isOneWay()) {
            this.invocationOneWayRadio.setSelected(true);
        } else {
            this.invocationTwoWayRadio.setSelected(true);
        }
        boolean enabled = this.parent.isSaveEnabled();
        this.currentServiceMap = props.getWsdlDefinitionMap();
        this.loadServiceMap();
        this.serviceComboBox.setSelectedItem((Object)props.getService());
        this.portComboBox.setSelectedItem((Object)props.getPort());
        this.locationURIComboBox.setSelectedItem((Object)props.getLocationURI());
        this.operationComboBox.setSelectedItem((Object)props.getOperation());
        this.updateGenerateEnvelopeButtonEnabled();
        this.soapActionField.setText(props.getSoapAction());
        this.urlFieldChanged();
        this.parent.setSaveEnabled(enabled);
        if (props.getHeadersMap() != null) {
            this.setHeaderProperties(props.getHeadersMap());
        } else {
            this.setHeaderProperties(new LinkedHashMap<String, List<String>>());
        }
        if (props.isUseHeadersVariable()) {
            this.useHeadersVariableRadio.setSelected(true);
        } else {
            this.useHeadersTableRadio.setSelected(true);
        }
        this.headersVariableField.setText(props.getHeadersVariable());
        this.useHeadersVariableFieldsEnabled(props.isUseHeadersVariable());
        ArrayList<List<String>> attachments = new ArrayList<List<String>>();
        attachments.add(props.getAttachmentNames());
        attachments.add(props.getAttachmentContents());
        attachments.add(props.getAttachmentTypes());
        this.setAttachments(attachments);
        if (props.isUseMtom()) {
            this.useMtomYesRadio.setSelected(true);
            this.useMtomYesRadioActionPerformed(null);
        } else {
            this.useMtomNoRadio.setSelected(true);
            this.useMtomNoRadioActionPerformed(null);
        }
        if (props.isUseAttachmentsVariable()) {
            this.useAttachmentsVariableRadio.setSelected(true);
        } else {
            this.useAttachmentsTableRadio.setSelected(true);
        }
        this.attachmentsVariableField.setText(props.getAttachmentsVariable());
        this.useAttachmentVariableFieldsEnabled(props.isUseAttachmentsVariable());
    }

    public ConnectorProperties getDefaults() {
        return new WebServiceDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        WebServiceDispatcherProperties props = (WebServiceDispatcherProperties)properties;
        boolean valid = true;
        if (props.getWsdlUrl().length() == 0) {
            valid = false;
            if (highlight) {
                this.wsdlUrlField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getService().length() == 0) {
            valid = false;
            if (highlight) {
                this.serviceComboBox.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getPort().length() == 0) {
            valid = false;
            if (highlight) {
                this.portComboBox.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getSocketTimeout())) {
            valid = false;
            if (highlight) {
                this.socketTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getEnvelope().length() == 0) {
            valid = false;
            if (highlight) {
                this.soapEnvelopeTextArea.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isUseHeadersVariable() && StringUtils.isBlank((CharSequence)props.getHeadersVariable())) {
            valid = false;
            if (highlight) {
                this.headersVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isUseMtom() && props.isUseAttachmentsVariable() && StringUtils.isBlank((CharSequence)props.getAttachmentsVariable())) {
            valid = false;
            if (highlight) {
                this.attachmentsVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.wsdlUrlField.setBackground(null);
        this.urlFieldChanged();
        this.serviceComboBox.setBackground(new Color(0xDEDEDE));
        this.portComboBox.setBackground(new Color(0xDEDEDE));
        this.locationURIComboBox.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.socketTimeoutField.setBackground(null);
        this.soapEnvelopeTextArea.setBackground(null);
        this.headersVariableField.setBackground(null);
        this.attachmentsVariableField.setBackground(null);
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        if (this.isUsingHttps(this.wsdlUrlField.getText()) || this.isUsingHttps(String.valueOf(this.locationURIComboBox.getSelectedItem()))) {
            return new ConnectorTypeDecoration(Connector.Mode.DESTINATION, "(SSL Not Configured)", ICON_LOCK_X, SSL_TOOL_TIP, (Component)this.sslWarningPanel, COLOR_SSL_NOT_CONFIGURED);
        }
        return new ConnectorTypeDecoration(Connector.Mode.DESTINATION);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (connectorTypeDecoration != null) {
            this.wsdlUrlField.setIcon((Icon)connectorTypeDecoration.getIcon());
            this.wsdlUrlField.setAlternateToolTipText(connectorTypeDecoration.getIconToolTipText());
            this.wsdlUrlField.setIconPopupMenuComponent(connectorTypeDecoration.getIconPopupComponent());
            this.wsdlUrlField.setBackground(connectorTypeDecoration.getHighlightColor());
            this.locationURIComboBox.setBackground(connectorTypeDecoration.getHighlightColor() != null ? connectorTypeDecoration.getHighlightColor() : UIConstants.COMBO_BOX_BACKGROUND);
        }
    }

    protected DefinitionServiceMap getCurrentServiceMap() {
        return this.currentServiceMap;
    }

    protected void setCurrentServiceMap(DefinitionServiceMap serviceMap) {
        this.currentServiceMap = serviceMap;
    }

    protected boolean canSetLocationURI() {
        return true;
    }

    protected void loadServiceMap() {
        this.serviceComboBox.setModel(new DefaultComboBoxModel());
        this.portComboBox.setModel(new DefaultComboBoxModel());
        if (this.canSetLocationURI()) {
            this.locationURIComboBox.setModel(new DefaultComboBoxModel());
        }
        this.operationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Press Get Operations"}));
        if (this.currentServiceMap != null) {
            this.serviceComboBox.setModel(new DefaultComboBoxModel<Object>(this.currentServiceMap.getMap().keySet().toArray()));
            if (this.serviceComboBox.getModel().getSize() > 0) {
                this.serviceComboBox.setSelectedIndex(0);
            }
        }
    }

    protected boolean isUsingHttps(String url) {
        block4: {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                try {
                    URI hostURI = new URI(url);
                    String hostScheme = hostURI.getScheme();
                    if (hostScheme != null && hostScheme.toLowerCase().equals("https")) {
                        return true;
                    }
                }
                catch (URISyntaxException e) {
                    if (!url.toLowerCase().startsWith("https")) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    private void urlFieldChanged() {
        this.decorateConnectorType();
    }

    private boolean isDefaultOperations() {
        return this.operationComboBox.getItemCount() == 1 && this.operationComboBox.getItemAt(0).equals("Press Get Operations");
    }

    public void setHeaderProperties(Map<String, List<String>> properties) {
        int size = 0;
        for (List<String> list : properties.values()) {
            size += list.size();
        }
        Object[][] tableData = new Object[size][2];
        int j = 0;
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            for (String keyValue : entry.getValue()) {
                tableData[j][0] = entry.getKey();
                tableData[j][1] = keyValue;
                ++j;
            }
        }
        ((RefreshTableModel)this.headersTable.getModel()).refreshDataVector(tableData);
    }

    public Map<String, List<String>> getHeaderProperties() {
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        for (int i = 0; i < this.headersTable.getRowCount(); ++i) {
            String key = (String)this.headersTable.getValueAt(i, 0);
            ArrayList<String> headers = (ArrayList<String>)properties.get(key);
            if (headers == null) {
                headers = new ArrayList<String>();
                properties.put(key, headers);
            }
            headers.add((String)this.headersTable.getValueAt(i, 1));
        }
        return properties;
    }

    public void deselectRows(MirthTable table, JButton button) {
        table.clearSelection();
        button.setEnabled(false);
    }

    public int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    private String getNewPropertyName(MirthTable table) {
        String temp = "Property ";
        for (int i = 1; i <= table.getRowCount() + 1; ++i) {
            boolean exists = false;
            for (int j = 0; j < table.getRowCount(); ++j) {
                if (!((String)table.getValueAt(j, 0)).equalsIgnoreCase(temp + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return temp + i;
        }
        return "";
    }

    private void setAttachments(List<List<String>> attachments) {
        List<String> attachmentIds = attachments.get(0);
        List<String> attachmentContents = attachments.get(1);
        List<String> attachmentTypes = attachments.get(2);
        Object[][] tableData = new Object[attachmentIds.size()][3];
        for (int i = 0; i < attachmentIds.size(); ++i) {
            tableData[i][0] = attachmentIds.get(i);
            tableData[i][1] = attachmentContents.get(i);
            tableData[i][2] = attachmentTypes.get(i);
        }
        ((RefreshTableModel)this.attachmentsTable.getModel()).refreshDataVector(tableData);
    }

    private List<List<String>> getAttachments() {
        ArrayList<List<String>> attachments = new ArrayList<List<String>>();
        ArrayList<String> attachmentIds = new ArrayList<String>();
        ArrayList<String> attachmentContent = new ArrayList<String>();
        ArrayList<String> attachmentType = new ArrayList<String>();
        for (int i = 0; i < this.attachmentsTable.getModel().getRowCount(); ++i) {
            if (this.attachmentsTable.getModel().getValueAt(i, 0) == null || ((String)this.attachmentsTable.getModel().getValueAt(i, 0)).length() <= 0) continue;
            attachmentIds.add((String)this.attachmentsTable.getModel().getValueAt(i, 0));
            attachmentContent.add((String)this.attachmentsTable.getModel().getValueAt(i, 1));
            attachmentType.add((String)this.attachmentsTable.getModel().getValueAt(i, 2));
        }
        attachments.add(attachmentIds);
        attachments.add(attachmentContent);
        attachments.add(attachmentType);
        return attachments;
    }

    public void stopCellEditing() {
        if (this.attachmentsTable.isEditing()) {
            this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.convertColumnIndexToModel(this.attachmentsTable.getEditingColumn())).getCellEditor().stopCellEditing();
        }
    }

    private String getNewAttachmentId(int size) {
        String temp = "Attachment";
        for (int i = 1; i <= size; ++i) {
            boolean exists = false;
            for (int j = 0; j < size - 1; ++j) {
                if (!((String)this.attachmentsTable.getModel().getValueAt(j, this.attachmentsTable.getColumnModelIndex("ID"))).equalsIgnoreCase(temp + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return temp + i;
        }
        return "";
    }

    protected void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.wsdlUrlLabel = new JLabel("WSDL URL:");
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                WebServiceSender.this.urlFieldChanged();
            }
        };
        this.wsdlUrlField = new MirthIconTextField();
        this.wsdlUrlField.addKeyListener((KeyListener)keyListener);
        this.getOperationsButton = new JButton("Get Operations");
        this.getOperationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.getOperationsButtonActionPerformed(evt);
            }
        });
        this.wsdlUrlTestConnectionButton = new JButton("Test Connection");
        this.wsdlUrlTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.testConnectionButtonActionPerformed(true);
            }
        });
        this.serviceLabel = new JLabel("Service:");
        this.serviceComboBox = new MirthEditableComboBox();
        this.serviceComboBox.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.serviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.serviceComboBoxActionPerformed(evt);
            }
        });
        this.portLabel = new JLabel("Port / Endpoint:");
        this.portComboBox = new MirthEditableComboBox();
        this.portComboBox.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.portComboBoxActionPerformed(evt);
            }
        });
        this.locationURILabel = new JLabel("Location URI:");
        this.locationURIComboBox = new MirthEditableComboBox();
        this.locationURIComboBox.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.locationURITestConnectionButton = new JButton("Test Connection");
        this.locationURITestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.testConnectionButtonActionPerformed(false);
            }
        });
        this.socketTimeoutLabel = new JLabel("Socket Timeout (ms):");
        this.socketTimeoutField = new MirthTextField();
        this.authenticationLabel = new JLabel("Authentication:");
        ButtonGroup authenticationButtonGroup = new ButtonGroup();
        this.authenticationYesRadio = new MirthRadioButton("Yes");
        this.authenticationYesRadio.setBackground(this.getBackground());
        this.authenticationYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.authenticationYesRadioActionPerformed(evt);
            }
        });
        authenticationButtonGroup.add((AbstractButton)this.authenticationYesRadio);
        this.authenticationNoRadio = new MirthRadioButton("No");
        this.authenticationNoRadio.setBackground(this.getBackground());
        this.authenticationNoRadio.setText("No");
        this.authenticationNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.authenticationNoRadioActionPerformed(evt);
            }
        });
        authenticationButtonGroup.add((AbstractButton)this.authenticationNoRadio);
        this.usernameLabel = new JLabel("Username:");
        this.usernameField = new MirthTextField();
        this.passwordLabel = new JLabel("Password:");
        this.passwordField = new MirthPasswordField();
        this.invocationTypeLabel = new JLabel("Invocation Type:");
        ButtonGroup invocationButtonGroup = new ButtonGroup();
        this.invocationOneWayRadio = new MirthRadioButton("One-Way");
        this.invocationOneWayRadio.setBackground(this.getBackground());
        invocationButtonGroup.add((AbstractButton)this.invocationOneWayRadio);
        this.invocationTwoWayRadio = new MirthRadioButton("Two-Way");
        this.invocationTwoWayRadio.setBackground(this.getBackground());
        invocationButtonGroup.add((AbstractButton)this.invocationTwoWayRadio);
        this.operationLabel = new JLabel("Operation:");
        this.operationComboBox = new MirthComboBox();
        this.operationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String soapAction = "";
                if (!"Press Get Operations".equals(WebServiceSender.this.operationComboBox.getSelectedItem())) {
                    int index;
                    DefinitionServiceMap.PortInformation portInfo;
                    DefinitionServiceMap.DefinitionPortMap portMap;
                    String selectedOperation = (String)WebServiceSender.this.operationComboBox.getSelectedItem();
                    if (WebServiceSender.this.currentServiceMap != null && (portMap = (DefinitionServiceMap.DefinitionPortMap)WebServiceSender.this.currentServiceMap.getMap().get(WebServiceSender.this.serviceComboBox.getSelectedItem())) != null && (portInfo = (DefinitionServiceMap.PortInformation)portMap.getMap().get(WebServiceSender.this.portComboBox.getSelectedItem())) != null && CollectionUtils.isNotEmpty((Collection)portInfo.getOperations()) && CollectionUtils.isNotEmpty((Collection)portInfo.getActions()) && (index = portInfo.getOperations().indexOf(selectedOperation)) >= 0 && index < portInfo.getActions().size()) {
                        soapAction = (String)portInfo.getActions().get(index);
                    }
                }
                WebServiceSender.this.soapActionField.setText(soapAction);
            }
        });
        this.generateEnvelopeButton = new JButton("Generate Envelope");
        this.generateEnvelopeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.generateEnvelopeActionPerformed(evt);
            }
        });
        this.soapActionLabel = new JLabel("SOAP Action:");
        this.soapActionField = new MirthIconTextField();
        this.soapActionField.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.soapActionField.addKeyListener((KeyListener)keyListener);
        this.soapEnvelopeLabel = new JLabel("SOAP Envelope:");
        this.soapEnvelopeTextArea = new MirthSyntaxTextArea(true);
        this.soapEnvelopeTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.soapEnvelopeTextArea.setMinimumSize(new Dimension(26, 115));
        SyntaxDocument document = new SyntaxDocument();
        document.setTokenMarker((TokenMarker)new XMLTokenMarker());
        this.soapEnvelopeTextArea.setDocument(document);
        this.headersLabel = new JLabel("Headers:");
        this.headersTable = new MirthTable();
        this.headersTable.setModel((TableModel)new RefreshTableModel((Object[])new String[]{"Name", "Value"}, 0));
        this.headersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (WebServiceSender.this.getSelectedRow(WebServiceSender.this.headersTable) != -1) {
                    WebServiceSender.this.headerLastIndex = WebServiceSender.this.getSelectedRow(WebServiceSender.this.headersTable);
                    WebServiceSender.this.headersDeleteButton.setEnabled(true);
                } else {
                    WebServiceSender.this.headersDeleteButton.setEnabled(false);
                }
            }
        });
        class WebServiceTableCellEditor
        extends TextFieldCellEditor {
            boolean checkProperties;

            public WebServiceTableCellEditor(boolean checkProperties) {
                this.checkProperties = checkProperties;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    WebServiceSender.this.headersDeleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                WebServiceSender.this.headersDeleteButton.setEnabled(true);
                if (this.checkProperties && value.length() == 0) {
                    return false;
                }
                WebServiceSender.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.headersTable.getColumnModel().getColumn(this.headersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new WebServiceTableCellEditor(true)));
        this.headersTable.getColumnModel().getColumn(this.headersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new WebServiceTableCellEditor(false)));
        this.headersTable.setCustomEditorControls(true);
        this.headersTable.setSelectionMode(0);
        this.headersTable.setRowSelectionAllowed(true);
        this.headersTable.setRowHeight(20);
        this.headersTable.setDragEnabled(false);
        this.headersTable.setOpaque(true);
        this.headersTable.setSortable(false);
        this.headersTable.setEditable(true);
        this.headersTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.headersTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.headersScrollPane = new JScrollPane((Component)this.headersTable);
        this.headersScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WebServiceSender.this.deselectRows(WebServiceSender.this.headersTable, WebServiceSender.this.headersDeleteButton);
            }
        });
        this.headersNewButton = new JButton("New");
        this.headersNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.headersNewButtonActionPerformed(evt);
            }
        });
        this.headersDeleteButton = new JButton("Delete");
        this.headersDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.headersDeleteButtonActionPerformed(evt);
            }
        });
        this.useHeadersTableRadio = new MirthRadioButton("Use Table");
        this.useHeadersTableRadio.setBackground(this.getBackground());
        this.useHeadersTableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServiceSender.this.useHeadersVariableFieldsEnabled(false);
            }
        });
        this.useHeadersVariableRadio = new MirthRadioButton("Use Map:");
        this.useHeadersVariableRadio.setBackground(this.getBackground());
        this.useHeadersVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServiceSender.this.useHeadersVariableFieldsEnabled(true);
            }
        });
        ButtonGroup headersSourceButtonGroup = new ButtonGroup();
        headersSourceButtonGroup.add((AbstractButton)this.useHeadersVariableRadio);
        headersSourceButtonGroup.add((AbstractButton)this.useHeadersTableRadio);
        this.headersVariableField = new MirthTextField();
        this.useMtomLabel = new JLabel("Use MTOM:");
        ButtonGroup useMtomButtonGroup = new ButtonGroup();
        this.useMtomYesRadio = new MirthRadioButton("Yes");
        this.useMtomYesRadio.setBackground(this.getBackground());
        this.useMtomYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.useMtomYesRadioActionPerformed(evt);
            }
        });
        useMtomButtonGroup.add((AbstractButton)this.useMtomYesRadio);
        this.useMtomNoRadio = new MirthRadioButton("No");
        this.useMtomNoRadio.setBackground(this.getBackground());
        this.useMtomNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.useMtomNoRadioActionPerformed(evt);
            }
        });
        useMtomButtonGroup.add((AbstractButton)this.useMtomNoRadio);
        this.attachmentsLabel = new JLabel("Attachments:");
        this.attachmentsTable = new MirthTable();
        this.attachmentsTable.setModel((TableModel)new RefreshTableModel((Object[])new String[]{"ID", "Content", "MIME Type"}, 0));
        this.attachmentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (WebServiceSender.this.attachmentsTable.getSelectedModelIndex() != -1) {
                    WebServiceSender.this.attachmentsDeleteButton.setEnabled(true);
                } else {
                    WebServiceSender.this.attachmentsDeleteButton.setEnabled(false);
                }
            }
        });
        class AttachmentsTableCellEditor
        extends TextFieldCellEditor {
            boolean checkUnique;

            public AttachmentsTableCellEditor(boolean checkUnique) {
                this.checkUnique = checkUnique;
            }

            public boolean checkUnique(String value) {
                boolean exists = false;
                for (int i = 0; i < WebServiceSender.this.attachmentsTable.getModel().getRowCount(); ++i) {
                    if (!((String)WebServiceSender.this.attachmentsTable.getModel().getValueAt(i, 0)).equalsIgnoreCase(value)) continue;
                    exists = true;
                }
                return exists;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    WebServiceSender.this.attachmentsDeleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                WebServiceSender.this.attachmentsDeleteButton.setEnabled(true);
                if (this.checkUnique && (value.length() == 0 || this.checkUnique(value))) {
                    return false;
                }
                WebServiceSender.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.getColumnModelIndex("ID")).setCellEditor((TableCellEditor)((Object)new AttachmentsTableCellEditor(true)));
        this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.getColumnModelIndex("Content")).setCellEditor((TableCellEditor)((Object)new AttachmentsTableCellEditor(false)));
        this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.getColumnModelIndex("MIME Type")).setCellEditor((TableCellEditor)((Object)new AttachmentsTableCellEditor(false)));
        this.attachmentsTable.setCustomEditorControls(true);
        this.attachmentsTable.setSelectionMode(0);
        this.attachmentsTable.setRowSelectionAllowed(true);
        this.attachmentsTable.setRowHeight(20);
        this.attachmentsTable.setDragEnabled(true);
        this.attachmentsTable.setOpaque(true);
        this.attachmentsTable.setSortable(true);
        this.attachmentsTable.setEditable(true);
        this.attachmentsTable.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                try {
                    MirthTable table = (MirthTable)c;
                    if (table == null) {
                        return null;
                    }
                    int currRow = table.convertRowIndexToModel(table.getSelectedRow());
                    Object text = "";
                    if (currRow >= 0 && currRow < table.getModel().getRowCount()) {
                        text = (String)table.getModel().getValueAt(currRow, 0);
                    }
                    text = "<inc:Include href=\"cid:" + (String)text + "\" xmlns:inc=\"http://www.w3.org/2004/08/xop/include\"/>";
                    return new StringSelection((String)text);
                }
                catch (ClassCastException cce) {
                    return null;
                }
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] df) {
                return false;
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.attachmentsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.attachmentsScrollPane = new JScrollPane((Component)this.attachmentsTable);
        this.attachmentsNewButton = new JButton("New");
        this.attachmentsNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.newButtonActionPerformed(evt);
            }
        });
        this.attachmentsDeleteButton = new JButton("Delete");
        this.attachmentsDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceSender.this.deleteButtonActionPerformed(evt);
            }
        });
        this.sslWarningPanel = new SSLWarningPanel();
        this.useAttachmentsTableRadio = new MirthRadioButton("Use Table");
        this.useAttachmentsTableRadio.setBackground(this.getBackground());
        this.useAttachmentsTableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServiceSender.this.useAttachmentVariableFieldsEnabled(false);
            }
        });
        this.useAttachmentsVariableRadio = new MirthRadioButton("Use List:");
        this.useAttachmentsVariableRadio.setBackground(this.getBackground());
        this.useAttachmentsVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServiceSender.this.useAttachmentVariableFieldsEnabled(true);
            }
        });
        ButtonGroup attachmentSourceButtonGroup = new ButtonGroup();
        attachmentSourceButtonGroup.add((AbstractButton)this.useAttachmentsTableRadio);
        attachmentSourceButtonGroup.add((AbstractButton)this.useAttachmentsVariableRadio);
        this.attachmentsVariableField = new MirthTextField();
    }

    protected void initToolTips() {
        this.wsdlUrlField.setToolTipText("Enter the full URL to the WSDL describing the web service method to be called, and then click the Get Operations button.");
        this.getOperationsButton.setToolTipText("<html>Clicking this button fetches the WSDL from the specified URL<br> and parses it to obtain a description of the data types and methods used by the web service to be called.<br>It replaces the values of all of the controls below by values taken from the WSDL.</html>");
        this.serviceComboBox.setToolTipText("<html>The service name for the WSDL defined above. This field<br/>is filled in automatically when the Get Operations button<br/>is clicked and does not usually need to be changed,<br/>unless multiple services are defined in the WSDL.</html>");
        this.portComboBox.setToolTipText("<html>The port / endpoint name for the service defined above.<br/>This field is filled in automatically when the Get Operations<br/>button is clicked and does not usually need to be changed,<br/>unless multiple endpoints are defined for the currently<br/>selected service in the WSDL.</html>");
        this.locationURIComboBox.setToolTipText("<html>The dispatch location for the port / endpoint defined above.<br/>This field is filled in automatically when the Get Operations<br/>button is clicked and does not usually need to be changed.<br/>If left blank, the default URI defined in the WSDL will be used.</html>");
        this.socketTimeoutField.setToolTipText("<html>Sets the connection and socket timeout (SO_TIMEOUT) in<br/>milliseconds to be used when invoking the web service.<br/>A timeout value of zero is interpreted as an infinite timeout.</html>");
        this.authenticationYesRadio.setToolTipText("<html>Turning on authentication uses a username and password to get the WSDL, if necessary,<br>and uses the username and password binding provider properties when calling the web service.</html>");
        this.authenticationNoRadio.setToolTipText("<html>Turning on authentication uses a username and password to get the WSDL, if necessary,<br>and uses the username and password binding provider properties when calling the web service.</html>");
        this.usernameField.setToolTipText("The username used to get the WSDL and call the web service.");
        this.passwordField.setToolTipText("The password used to get the WSDL and call the web service.");
        this.invocationOneWayRadio.setToolTipText("<html>Invoke the operation using the one-way invocation function.<br>This will not wait for any response, and should only be used if the<br>operation is defined as a one-way operation.</html>");
        this.invocationTwoWayRadio.setToolTipText("<html>Invoke the operation using the standard two-way invocation function.<br>This will wait for some response or acknowledgement to be returned.</html>");
        this.operationComboBox.setToolTipText("<html>Select the web service operation to be called from this list.<br>This is only used for generating the envelope</html>");
        this.generateEnvelopeButton.setToolTipText("<html>Clicking this button regenerates the contents of the SOAP Envelope control based on the<br>schema defined in the WSDL, discarding any changes that may have been made.<br>It also populates the SOAP Action field, if available.</html>");
        this.soapActionField.setToolTipText("<html>The SOAPAction HTTP request header field can be used to indicate the intent of the SOAP HTTP request.<br>This field is optional for most web services, and will be auto-populated when you select an operation.</html>");
        this.useHeadersTableRadio.setToolTipText("<html>The table below will be used to populate headers.</html>");
        this.useHeadersVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.headersVariableField.setToolTipText("<html>The variable of a Java map to use to populate headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.headersTable.setToolTipText("Header parameters are encoded as HTTP headers in the HTTP request sent to the server.");
        this.useMtomYesRadio.setToolTipText("<html>Enables MTOM on the SOAP Binding. If MTOM is enabled,<br>attachments can be added to the table below and dropped into the envelope.</html>");
        this.useMtomNoRadio.setToolTipText("<html>Does not enable MTOM on the SOAP Binding. If MTOM is enabled,<br>attachments can be added to the table below and dropped into the envelope.</html>");
        this.useAttachmentsTableRadio.setToolTipText("<html>The table below will be used to populate attachments.</html>");
        this.useAttachmentsVariableRadio.setToolTipText("<html>The Java list specified by the following variable will be used to populate attachments.<br/>The list must contain AttachmentEntry values - anything else is ignored.</html>");
        this.attachmentsVariableField.setToolTipText("<html>The name of the Java list to use to populate attachments.<br/>The list must contain AttachmentEntry values.</html>");
        this.attachmentsTable.setToolTipText("<html>Attachments should be added with an ID, Base64 encoded content,<br>and a valid MIME type. Once an attachment is added<br>the row can be dropped into an argument in the envelope.</html>");
    }

    protected void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gapy 6", "[]12[grow][]"));
        this.add(this.wsdlUrlLabel, "right");
        this.add((Component)this.wsdlUrlField, "growx, sx, split 3");
        this.add(this.getOperationsButton);
        this.add(this.wsdlUrlTestConnectionButton);
        this.add(this.serviceLabel, "newline, right");
        this.add((Component)this.serviceComboBox, "growx, sx");
        this.add(this.portLabel, "newline, right");
        this.add((Component)this.portComboBox, "growx, sx");
        this.add(this.locationURILabel, "newline, right");
        this.add((Component)this.locationURIComboBox, "growx, sx, split 2");
        this.add(this.locationURITestConnectionButton);
        this.add(this.socketTimeoutLabel, "newline, right");
        this.add((Component)this.socketTimeoutField, "w 75!");
        this.add(this.authenticationLabel, "newline, right");
        this.add((Component)this.authenticationYesRadio, "split 2");
        this.add((Component)this.authenticationNoRadio);
        this.add(this.usernameLabel, "newline, right");
        this.add((Component)this.usernameField, "w 125!");
        this.add(this.passwordLabel, "newline, right");
        this.add((Component)this.passwordField, "w 125!");
        this.add(this.invocationTypeLabel, "newline, right");
        this.add((Component)this.invocationOneWayRadio, "split 2");
        this.add((Component)this.invocationTwoWayRadio);
        this.add(this.operationLabel, "newline, right");
        this.add((Component)this.operationComboBox, "split 2");
        this.add(this.generateEnvelopeButton);
        this.add(this.soapActionLabel, "newline, right");
        this.add((Component)this.soapActionField, "growx, sx");
        this.add(this.soapEnvelopeLabel, "newline, top, right");
        this.add((Component)this.soapEnvelopeTextArea, "grow, push, sx");
        this.add(this.headersLabel, "newline, right");
        this.add((Component)this.useHeadersTableRadio, "split 3");
        this.add((Component)this.useHeadersVariableRadio);
        this.add((Component)this.headersVariableField, "w 125");
        this.add(this.headersScrollPane, "newline, top, growx, pushx, skip 1, h 80!");
        this.add(this.headersNewButton, "top, flowy, split 2, w 50!");
        this.add(this.headersDeleteButton, "w 50!");
        this.add(this.useMtomLabel, "newline, right");
        this.add((Component)this.useMtomYesRadio, "split 2");
        this.add((Component)this.useMtomNoRadio);
        this.add(this.attachmentsLabel, "newline, right");
        this.add((Component)this.useAttachmentsTableRadio, "split 3");
        this.add((Component)this.useAttachmentsVariableRadio);
        this.add((Component)this.attachmentsVariableField, "w 125");
        this.add(this.attachmentsScrollPane, "newline, top, growx, pushx, skip 1, h 80!");
        this.add(this.attachmentsNewButton, "top, flowy, split 2, w 50!");
        this.add(this.attachmentsDeleteButton, "w 50!");
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.stopCellEditing();
        ((DefaultTableModel)this.attachmentsTable.getModel()).addRow(new Object[]{this.getNewAttachmentId(this.attachmentsTable.getModel().getRowCount() + 1), ""});
        int newViewIndex = this.attachmentsTable.convertRowIndexToView(this.attachmentsTable.getModel().getRowCount() - 1);
        this.attachmentsTable.setRowSelectionInterval(newViewIndex, newViewIndex);
        this.attachmentsScrollPane.getViewport().setViewPosition(new Point(0, this.attachmentsTable.getRowHeight() * this.attachmentsTable.getModel().getRowCount()));
        this.parent.setSaveEnabled(true);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.stopCellEditing();
        int selectedModelIndex = this.attachmentsTable.getSelectedModelIndex();
        int newViewIndex = this.attachmentsTable.convertRowIndexToView(selectedModelIndex);
        if (newViewIndex == this.attachmentsTable.getModel().getRowCount() - 1) {
            --newViewIndex;
        }
        ((DefaultTableModel)this.attachmentsTable.getModel()).removeRow(selectedModelIndex);
        this.parent.setSaveEnabled(true);
        if (this.attachmentsTable.getModel().getRowCount() == 0) {
            this.attachmentsTable.clearSelection();
            this.attachmentsDeleteButton.setEnabled(false);
        } else {
            this.attachmentsTable.setRowSelectionInterval(newViewIndex, newViewIndex);
        }
        this.parent.setSaveEnabled(true);
    }

    private void getOperationsButtonActionPerformed(ActionEvent evt) {
        if ((StringUtils.isNotBlank((CharSequence)((String)this.serviceComboBox.getEditor().getItem())) || StringUtils.isNotBlank((CharSequence)((String)this.portComboBox.getEditor().getItem())) || StringUtils.isNotBlank((CharSequence)((String)this.locationURIComboBox.getEditor().getItem())) || !this.isDefaultOperations()) && !this.parent.alertOkCancel((Component)this.parent, "This will replace your current service, port, location URI, and operation list. Press OK to continue.")) {
            return;
        }
        this.currentServiceMap = null;
        this.serviceComboBox.setModel(new DefaultComboBoxModel());
        this.portComboBox.setModel(new DefaultComboBoxModel());
        if (this.canSetLocationURI()) {
            this.locationURIComboBox.setModel(new DefaultComboBoxModel());
        }
        this.operationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Press Get Operations"}));
        this.operationComboBox.setSelectedIndex(0);
        this.generateEnvelopeButton.setEnabled(false);
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ResponseHandler handler = new ResponseHandler(){

                    public void handle(Object response) {
                        if (response != null) {
                            WebServiceSender.this.currentServiceMap = (DefinitionServiceMap)response;
                            WebServiceSender.this.loadServiceMap();
                            if (WebServiceSender.this.currentServiceMap != null) {
                                WebServiceSender.this.serviceComboBox.setSelectedItem(WebServiceSender.this.currentServiceMap.getMap().keySet().iterator().next());
                            }
                            WebServiceSender.this.parent.setSaveEnabled(true);
                        }
                    }
                };
                try {
                    WebServiceDispatcherProperties props = (WebServiceDispatcherProperties)WebServiceSender.this.getFilledProperties();
                    ((WebServiceConnectorServletInterface)WebServiceSender.this.getServlet(WebServiceConnectorServletInterface.class, "Retrieving cached WSDL definition map...", "There was an error retrieving the cached WSDL definition map.\n\n", handler)).getDefinition(WebServiceSender.this.getChannelId(), WebServiceSender.this.getChannelName(), props.getWsdlUrl(), props.getUsername(), props.getPassword());
                }
                catch (ClientException clientException) {
                    // empty catch block
                }
            }
        };
        try {
            ((WebServiceConnectorServletInterface)this.getServlet(WebServiceConnectorServletInterface.class, "Getting operations...", "Error caching WSDL. Please check the WSDL URL and authentication settings.\n\n", handler)).cacheWsdlFromUrl(this.getChannelId(), this.getChannelName(), (WebServiceDispatcherProperties)this.getFilledProperties());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    protected boolean canTestConnection(boolean wsdlUrl) {
        if (wsdlUrl) {
            if (StringUtils.isBlank((CharSequence)this.wsdlUrlField.getText())) {
                this.parent.alertError((Component)this.parent, "WSDL URL is blank.");
                return false;
            }
        } else if (StringUtils.isBlank((CharSequence)String.valueOf(this.locationURIComboBox.getSelectedItem()))) {
            this.parent.alertError((Component)this.parent, "Location URI is blank.");
            return false;
        }
        return true;
    }

    protected WebServiceDispatcherProperties getTestConnectionPropeties() {
        return (WebServiceDispatcherProperties)this.getFilledProperties();
    }

    private void testConnectionButtonActionPerformed(boolean wsdlUrl) {
        if (!this.canTestConnection(wsdlUrl)) {
            return;
        }
        WebServiceDispatcherProperties properties = this.getTestConnectionPropeties();
        if (wsdlUrl) {
            properties.setLocationURI("");
        } else {
            properties.setWsdlUrl("");
        }
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    WebServiceSender.this.parent.alertError((Component)WebServiceSender.this.parent, "Failed to invoke service.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    WebServiceSender.this.parent.alertInformation((Component)WebServiceSender.this.parent, connectionTestResponse.getMessage());
                } else {
                    WebServiceSender.this.parent.alertWarning((Component)WebServiceSender.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((WebServiceConnectorServletInterface)this.getServlet(WebServiceConnectorServletInterface.class, "Testing connection...", "Error testing Web Service connection: ", handler)).testConnection(this.getChannelId(), this.getChannelName(), properties);
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void authenticationYesRadioActionPerformed(ActionEvent evt) {
        this.usernameLabel.setEnabled(true);
        this.usernameField.setEnabled(true);
        this.passwordLabel.setEnabled(true);
        this.passwordField.setEnabled(true);
    }

    private void authenticationNoRadioActionPerformed(ActionEvent evt) {
        this.usernameLabel.setEnabled(false);
        this.usernameField.setEnabled(false);
        this.usernameField.setText("");
        this.passwordLabel.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.passwordField.setText("");
    }

    private void useHeadersVariableFieldsEnabled(boolean useVariable) {
        this.headersVariableField.setEnabled(useVariable);
        this.headersTable.setEnabled(!useVariable);
        this.headersNewButton.setEnabled(!useVariable);
        this.headersDeleteButton.setEnabled(!useVariable);
    }

    private void useAttachmentVariableFieldsEnabled(boolean useVariable) {
        this.attachmentsVariableField.setEnabled(useVariable && this.useMtomYesRadio.isSelected());
        this.attachmentsTable.setEnabled(!useVariable && this.useMtomYesRadio.isSelected());
        this.attachmentsNewButton.setEnabled(!useVariable && this.useMtomYesRadio.isSelected());
        this.attachmentsDeleteButton.setEnabled(!useVariable && this.useMtomYesRadio.isSelected() && this.attachmentsTable.getSelectedRow() > -1);
    }

    private void useMtomYesRadioActionPerformed(ActionEvent evt) {
        this.attachmentsLabel.setEnabled(true);
        this.attachmentsScrollPane.setEnabled(true);
        this.attachmentsTable.setEnabled(true);
        this.attachmentsNewButton.setEnabled(this.useAttachmentsTableRadio.isSelected());
        this.useAttachmentsTableRadio.setEnabled(true);
        this.useAttachmentsVariableRadio.setEnabled(true);
        this.attachmentsVariableField.setEnabled(this.useAttachmentsVariableRadio.isSelected());
        if (this.useAttachmentsTableRadio.isSelected()) {
            this.attachmentsTable.setEnabled(true);
            this.attachmentsTable.setRowSelectionAllowed(true);
            if (this.attachmentsTable.getModel().getRowCount() > 0) {
                this.attachmentsTable.setRowSelectionInterval(0, 0);
                this.attachmentsDeleteButton.setEnabled(true);
            }
        } else {
            this.stopCellEditing();
            this.attachmentsTable.setEnabled(false);
            this.attachmentsTable.setRowSelectionAllowed(false);
            this.attachmentsTable.clearSelection();
        }
    }

    private void useMtomNoRadioActionPerformed(ActionEvent evt) {
        this.attachmentsLabel.setEnabled(false);
        this.attachmentsScrollPane.setEnabled(false);
        this.attachmentsTable.setEnabled(false);
        this.attachmentsNewButton.setEnabled(false);
        this.attachmentsDeleteButton.setEnabled(false);
        this.useAttachmentsTableRadio.setEnabled(false);
        this.useAttachmentsVariableRadio.setEnabled(false);
        this.attachmentsVariableField.setEnabled(false);
        this.stopCellEditing();
        this.attachmentsTable.setRowSelectionAllowed(false);
        this.attachmentsTable.clearSelection();
    }

    private void generateEnvelopeActionPerformed(ActionEvent evt) {
        this.generateEnvelope();
    }

    protected void generateEnvelope() {
        this.generateEnvelope(((WebServiceDispatcherProperties)this.getFilledProperties()).getWsdlUrl(), this.getChannelId(), this.getChannelName(), true);
    }

    protected void generateEnvelope(String wsdlUrl, final String channelId, final String channelName, final boolean buildOptional) {
        if (!(this.soapEnvelopeTextArea.getText().length() <= 0 && this.soapActionField.getText().length() <= 0 || this.parent.alertOkCancel((Component)this.parent, "This will replace your current SOAP envelope and SOAP action. Press OK to continue."))) {
            return;
        }
        final WebServiceDispatcherProperties props = (WebServiceDispatcherProperties)this.getFilledProperties();
        props.setWsdlUrl(wsdlUrl);
        ResponseHandler isWsdlCachedHandler = new ResponseHandler(){

            public void handle(Object response) {
                if (response != null) {
                    if (((Boolean)response).booleanValue()) {
                        ResponseHandler generateEnvelopeHandler = new ResponseHandler(){

                            public void handle(Object response) {
                                WebServiceSender.this.setSoapEnvelopeText((String)response);
                                ResponseHandler getSoapActionHandler = new ResponseHandler(){

                                    public void handle(Object response) {
                                        String soapAction = (String)response;
                                        if (soapAction != null) {
                                            WebServiceSender.this.soapActionField.setText(soapAction);
                                            WebServiceSender.this.parent.setSaveEnabled(true);
                                            WebServiceSender.this.urlFieldChanged();
                                        }
                                    }
                                };
                                try {
                                    ((WebServiceConnectorServletInterface)WebServiceSender.this.getServlet(WebServiceConnectorServletInterface.class, "Retrieving SOAP action...", "There was an error retrieving the SOAP action.\n\n", getSoapActionHandler)).getSoapAction(channelId, channelName, props.getWsdlUrl(), props.getUsername(), props.getPassword(), props.getService(), props.getPort(), props.getOperation());
                                }
                                catch (ClientException clientException) {
                                    // empty catch block
                                }
                            }
                        };
                        try {
                            ((WebServiceConnectorServletInterface)WebServiceSender.this.getServlet(WebServiceConnectorServletInterface.class, "Generating envelope...", "There was an error generating the envelope.\n\n", generateEnvelopeHandler)).generateEnvelope(channelId, channelName, props.getWsdlUrl(), props.getUsername(), props.getPassword(), props.getService(), props.getPort(), props.getOperation(), buildOptional);
                        }
                        catch (ClientException clientException) {}
                    } else {
                        WebServiceSender.this.parent.alertInformation((Component)WebServiceSender.this.parent, "The WSDL is no longer cached on the server. Press \"Get Operations\" to fetch the latest WSDL.");
                    }
                }
            }
        };
        try {
            ((WebServiceConnectorServletInterface)this.getServlet(WebServiceConnectorServletInterface.class, "Checking if WSDL is cached...", "Error checking if the wsdl is cached: ", isWsdlCachedHandler)).isWsdlCached(channelId, channelName, props.getWsdlUrl(), props.getUsername(), props.getPassword());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    protected void setSoapEnvelopeText(String text) {
        if (text != null) {
            this.soapEnvelopeTextArea.setText(text);
            this.parent.setSaveEnabled(true);
        }
    }

    private void serviceComboBoxActionPerformed(ActionEvent evt) {
        String selectedPort = (String)this.portComboBox.getEditor().getItem();
        if (this.currentServiceMap != null) {
            DefinitionServiceMap.DefinitionPortMap portMap = (DefinitionServiceMap.DefinitionPortMap)this.currentServiceMap.getMap().get((String)this.serviceComboBox.getEditor().getItem());
            if (portMap != null) {
                this.portComboBox.setModel(new DefaultComboBoxModel<Object>(portMap.getMap().keySet().toArray()));
            } else {
                this.portComboBox.setModel(new DefaultComboBoxModel());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)selectedPort)) {
            this.portComboBox.setSelectedItem((Object)selectedPort);
        } else if (this.portComboBox.getModel().getSize() > 0) {
            this.portComboBox.setSelectedIndex(0);
        }
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        DefinitionServiceMap.DefinitionPortMap portMap;
        if (this.currentServiceMap != null && (portMap = (DefinitionServiceMap.DefinitionPortMap)this.currentServiceMap.getMap().get((String)this.serviceComboBox.getEditor().getItem())) != null) {
            DefinitionServiceMap.PortInformation portInformation = (DefinitionServiceMap.PortInformation)portMap.getMap().get((String)this.portComboBox.getEditor().getItem());
            String selectedLocationURI = (String)this.locationURIComboBox.getEditor().getItem();
            if (portInformation != null) {
                List operationList = portInformation.getOperations();
                if (CollectionUtils.isNotEmpty((Collection)operationList)) {
                    String selectedOperation = (String)this.operationComboBox.getSelectedItem();
                    this.operationComboBox.setModel(new DefaultComboBoxModel<Object>(operationList.toArray()));
                    if (operationList.contains(selectedOperation)) {
                        this.operationComboBox.setSelectedItem((Object)selectedOperation);
                    } else {
                        this.operationComboBox.setSelectedIndex(0);
                    }
                    this.updateGenerateEnvelopeButtonEnabled();
                } else {
                    this.operationComboBox.setModel(new DefaultComboBoxModel());
                }
                if (this.canSetLocationURI()) {
                    if (StringUtils.isNotBlank((CharSequence)portInformation.getLocationURI())) {
                        this.locationURIComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{portInformation.getLocationURI()}));
                    } else {
                        this.locationURIComboBox.setModel(new DefaultComboBoxModel());
                    }
                }
            } else {
                if (this.canSetLocationURI()) {
                    this.locationURIComboBox.setModel(new DefaultComboBoxModel());
                }
                this.operationComboBox.setModel(new DefaultComboBoxModel());
            }
            if (this.canSetLocationURI() && StringUtils.isNotBlank((CharSequence)selectedLocationURI)) {
                this.locationURIComboBox.setSelectedItem((Object)selectedLocationURI);
            }
        }
    }

    protected void updateGenerateEnvelopeButtonEnabled() {
        this.generateEnvelopeButton.setEnabled(!this.isDefaultOperations());
    }

    private void headersNewButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.headersTable.getModel()).addRow(new Object[]{this.getNewPropertyName(this.headersTable), ""});
        this.headersTable.setRowSelectionInterval(this.headersTable.getRowCount() - 1, this.headersTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void headersDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedRow(this.headersTable) != -1 && !this.headersTable.isEditing()) {
            ((DefaultTableModel)this.headersTable.getModel()).removeRow(this.getSelectedRow(this.headersTable));
            if (this.headersTable.getRowCount() != 0) {
                if (this.headerLastIndex == 0) {
                    this.headersTable.setRowSelectionInterval(0, 0);
                } else if (this.headerLastIndex == this.headersTable.getRowCount()) {
                    this.headersTable.setRowSelectionInterval(this.headerLastIndex - 1, this.headerLastIndex - 1);
                } else {
                    this.headersTable.setRowSelectionInterval(this.headerLastIndex, this.headerLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }
}

