/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.edi;

import com.mirth.connect.model.util.MessageVocabulary;
import com.mirth.connect.plugins.datatypes.edi.CompositeType;
import com.mirth.connect.plugins.datatypes.edi.EDIDataTypeDelegate;
import com.mirth.connect.plugins.datatypes.edi.ElementType;
import com.mirth.connect.plugins.datatypes.edi.LoopType;
import com.mirth.connect.plugins.datatypes.edi.SegmentType;
import com.mirth.connect.plugins.datatypes.edi.TransactionType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X12Vocabulary
extends MessageVocabulary {
    private Logger logger = LogManager.getLogger(X12Vocabulary.class);
    private Map<String, Object> vocab;
    private static final String JAXB_CONTEXT = "com.mirth.connect.plugins.datatypes.edi";
    private static final String XML_PATH = "xml";
    private String version = "";
    private String type = "";

    public X12Vocabulary(String version, String type) {
        super(version, type);
        this.version = version;
        this.type = type;
    }

    public String getDescription(String elementId) {
        Object element;
        if (this.vocab == null) {
            try {
                this.loadData();
            }
            catch (Exception e) {
                this.logger.error("Error loading xml data: " + e.getMessage());
                this.vocab = new LinkedHashMap<String, Object>();
                return new String();
            }
        }
        if ((element = this.vocab.get(elementId)) instanceof Queue) {
            String description = (String)((Queue)element).poll();
            if (description == null) {
                description = new String();
            } else {
                ((Queue)element).add(description);
            }
            return description;
        }
        return (String)element;
    }

    private void loadData() throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)JAXB_CONTEXT);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        String fileName = "xml/" + this.type + "." + this.version + ".xml";
        TransactionType collection = (TransactionType)((JAXBElement)unmarshaller.unmarshal(((Object)((Object)this)).getClass().getResourceAsStream(fileName))).getValue();
        this.vocab = new LinkedHashMap<String, Object>();
        this.vocab.put(collection.getId(), collection.getName());
        LoopType loop = collection.getLoop();
        this.processLoop(loop, this.vocab);
    }

    private void addEntry(String name, String description, Map<String, Object> mappings) {
        if (((String)(name = ((String)name).replaceAll("_LOOP", "").replaceAll("-", ""))).length() > 5) {
            name = ((String)name).substring(0, ((String)name).length() - 4) + "." + ((String)name).substring(((String)name).length() - 4, ((String)name).length() - 2) + "." + ((String)name).substring(((String)name).length() - 2);
        } else if (((String)name).length() > 3) {
            name = ((String)name).substring(0, ((String)name).length() - 2) + "." + ((String)name).substring(((String)name).length() - 2);
        }
        name = ((String)name).replace('-', '.');
        if (mappings.containsKey(name)) {
            Object mappingElement = mappings.get(name);
            if (mappingElement instanceof Queue) {
                ((Queue)mappingElement).add(description);
            } else {
                LinkedBlockingQueue<String> queue = new LinkedBlockingQueue<String>();
                queue.add((String)mappingElement);
                queue.add(description);
                mappings.put((String)name, queue);
            }
        } else {
            mappings.put((String)name, description);
        }
    }

    private void processLoop(LoopType loop, Map<String, Object> mappings) {
        this.addEntry(loop.getXid(), loop.getName(), mappings);
        Iterator<JAXBElement<?>> iter = loop.getSegmentOrLoopOrRepeat().iterator();
        while (iter.hasNext()) {
            Object element = iter.next().getValue();
            if (element instanceof SegmentType) {
                SegmentType segment = (SegmentType)element;
                this.processSegment(segment, mappings);
                continue;
            }
            if (!(element instanceof LoopType)) continue;
            this.processLoop((LoopType)element, mappings);
        }
    }

    private void processSegment(SegmentType segment, Map<String, Object> mappings) {
        this.addEntry(segment.getXid(), segment.getName(), mappings);
        for (Object component : segment.getElementOrComposite()) {
            if (component instanceof CompositeType) {
                this.processComposite((CompositeType)component, mappings);
                continue;
            }
            if (!(component instanceof ElementType)) continue;
            ElementType element = (ElementType)component;
            this.addEntry(element.getXid(), element.getName(), mappings);
        }
    }

    private void processComposite(CompositeType composite, Map<String, Object> mappings) {
        this.addEntry(composite.getDataEle(), composite.getName(), mappings);
        for (ElementType element : composite.getElement()) {
            this.addEntry(element.getXid(), element.getName(), mappings);
        }
    }

    public String getDataType() {
        return new EDIDataTypeDelegate().getName();
    }
}

