/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.dimse;

import com.mirth.connect.connectors.dimse.DICOMDispatcher;
import com.mirth.connect.connectors.dimse.DICOMDispatcherProperties;
import com.mirth.connect.connectors.dimse.DICOMReceiver;
import com.mirth.connect.connectors.dimse.DICOMReceiverProperties;
import com.mirth.connect.util.MirthSSLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che2.tool.dcmrcv.MirthDcmRcv;
import org.dcm4che2.tool.dcmsnd.MirthDcmSnd;

public class DICOMConfigurationUtil {
    public static void configureDcmRcv(MirthDcmRcv dcmrcv, DICOMReceiver connector, DICOMReceiverProperties connectorProperties, String[] protocols) throws Exception {
        if (!StringUtils.equals((CharSequence)connectorProperties.getTls(), (CharSequence)"notls")) {
            String keyStorePW;
            String keyStore;
            String keyPW;
            String trustStorePW;
            if (connectorProperties.getTls().equals("without")) {
                dcmrcv.setTlsWithoutEncyrption();
            } else if (connectorProperties.getTls().equals("3des")) {
                dcmrcv.setTls3DES_EDE_CBC();
            } else if (connectorProperties.getTls().equals("aes")) {
                dcmrcv.setTlsAES_128_CBC();
            }
            String trustStore = connector.getReplacer().replaceValues(connectorProperties.getTrustStore(), connector.getChannelId(), connector.getChannel().getName());
            if (StringUtils.isNotBlank((CharSequence)trustStore)) {
                dcmrcv.setTrustStoreURL(trustStore);
            }
            if (StringUtils.isNotBlank((CharSequence)(trustStorePW = connector.getReplacer().replaceValues(connectorProperties.getTrustStorePW(), connector.getChannelId(), connector.getChannel().getName())))) {
                dcmrcv.setTrustStorePassword(trustStorePW);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyPW = connector.getReplacer().replaceValues(connectorProperties.getKeyPW(), connector.getChannelId(), connector.getChannel().getName())))) {
                dcmrcv.setKeyPassword(keyPW);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyStore = connector.getReplacer().replaceValues(connectorProperties.getKeyStore(), connector.getChannelId(), connector.getChannel().getName())))) {
                dcmrcv.setKeyStoreURL(keyStore);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyStorePW = connector.getReplacer().replaceValues(connectorProperties.getKeyStorePW(), connector.getChannelId(), connector.getChannel().getName())))) {
                dcmrcv.setKeyStorePassword(keyStorePW);
            }
            dcmrcv.setTlsNeedClientAuth(connectorProperties.isNoClientAuth());
            protocols = (String[])ArrayUtils.clone((Object[])protocols);
            if (connectorProperties.isNossl2()) {
                if (ArrayUtils.contains((Object[])protocols, (Object)"SSLv2Hello")) {
                    ArrayList<String> protocolsList = new ArrayList<String>(Arrays.asList(protocols));
                    protocolsList.remove("SSLv2Hello");
                    protocols = protocolsList.toArray(new String[protocolsList.size()]);
                }
            } else if (!ArrayUtils.contains((Object[])protocols, (Object)"SSLv2Hello")) {
                ArrayList<String> protocolsList = new ArrayList<String>(Arrays.asList(protocols));
                protocolsList.add("SSLv2Hello");
                protocols = protocolsList.toArray(new String[protocolsList.size()]);
            }
            dcmrcv.setTlsProtocol(MirthSSLUtil.getEnabledHttpsProtocols((String[])protocols));
            dcmrcv.initTLS();
        }
    }

    public static void configureDcmSnd(MirthDcmSnd dcmsnd, DICOMDispatcher connector, DICOMDispatcherProperties connectorProperties, String[] protocols) throws Exception {
        if (connectorProperties.getTls() != null && !connectorProperties.getTls().equals("notls")) {
            if (connectorProperties.getTls().equals("without")) {
                dcmsnd.setTlsWithoutEncyrption();
            }
            if (connectorProperties.getTls().equals("3des")) {
                dcmsnd.setTls3DES_EDE_CBC();
            }
            if (connectorProperties.getTls().equals("aes")) {
                dcmsnd.setTlsAES_128_CBC();
            }
            if (connectorProperties.getTrustStore() != null && !connectorProperties.getTrustStore().equals("")) {
                dcmsnd.setTrustStoreURL(connectorProperties.getTrustStore());
            }
            if (connectorProperties.getTrustStorePW() != null && !connectorProperties.getTrustStorePW().equals("")) {
                dcmsnd.setTrustStorePassword(connectorProperties.getTrustStorePW());
            }
            if (connectorProperties.getKeyPW() != null && !connectorProperties.getKeyPW().equals("")) {
                dcmsnd.setKeyPassword(connectorProperties.getKeyPW());
            }
            if (connectorProperties.getKeyStore() != null && !connectorProperties.getKeyStore().equals("")) {
                dcmsnd.setKeyStoreURL(connectorProperties.getKeyStore());
            }
            if (connectorProperties.getKeyStorePW() != null && !connectorProperties.getKeyStorePW().equals("")) {
                dcmsnd.setKeyStorePassword(connectorProperties.getKeyStorePW());
            }
            dcmsnd.setTlsNeedClientAuth(connectorProperties.isNoClientAuth());
            protocols = (String[])ArrayUtils.clone((Object[])protocols);
            if (connectorProperties.isNossl2()) {
                if (ArrayUtils.contains((Object[])protocols, (Object)"SSLv2Hello")) {
                    ArrayList<String> protocolsList = new ArrayList<String>(Arrays.asList(protocols));
                    protocolsList.remove("SSLv2Hello");
                    protocols = protocolsList.toArray(new String[protocolsList.size()]);
                }
            } else if (!ArrayUtils.contains((Object[])protocols, (Object)"SSLv2Hello")) {
                ArrayList<String> protocolsList = new ArrayList<String>(Arrays.asList(protocols));
                protocolsList.add("SSLv2Hello");
                protocols = protocolsList.toArray(new String[protocolsList.size()]);
            }
            protocols = MirthSSLUtil.getEnabledHttpsProtocols((String[])protocols);
            dcmsnd.setTlsProtocol(protocols);
            dcmsnd.initTLS();
        }
    }
}

