/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.dimse;

import com.mirth.connect.connectors.dimse.DICOMConfiguration;
import com.mirth.connect.connectors.dimse.DICOMReceiverProperties;
import com.mirth.connect.connectors.dimse.DefaultDICOMConfiguration;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcm4che2.tool.dcmrcv.MirthDcmRcv;

public class DICOMReceiver
extends SourceConnector {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private DICOMReceiverProperties connectorProperties;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private DICOMConfiguration configuration = null;
    private MirthDcmRcv dcmrcv;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (DICOMReceiverProperties)this.getConnectorProperties();
        String configurationClass = this.configurationController.getProperty(this.connectorProperties.getProtocol(), "dicomConfigurationClass");
        try {
            this.configuration = (DICOMConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Throwable t) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultDICOMConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        this.dcmrcv = new MirthDcmRcv(this, this.configuration);
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
        try {
            this.dcmrcv.setPort(NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getListenerConnectorProperties().getPort(), this.getChannelId(), this.getChannel().getName())));
            this.dcmrcv.setHostname(this.replacer.replaceValues(this.connectorProperties.getListenerConnectorProperties().getHost(), this.getChannelId(), this.getChannel().getName()));
            String[] only_def_ts = new String[]{"1.2.840.10008.1.2"};
            String[] native_le_ts = new String[]{"1.2.840.10008.1.2"};
            String[] native_ts = new String[]{"1.2.840.10008.1.2"};
            String[] non_retired_ts = new String[]{"1.2.840.10008.1.2"};
            String destination = this.replacer.replaceValues(this.connectorProperties.getDest(), this.getChannelId(), this.getChannel().getName());
            if (StringUtils.isNotBlank((CharSequence)destination)) {
                this.dcmrcv.setDestination(destination);
            }
            if (this.connectorProperties.isDefts()) {
                this.dcmrcv.setTransferSyntax(only_def_ts);
            } else if (this.connectorProperties.isNativeData()) {
                if (this.connectorProperties.isBigEndian()) {
                    this.dcmrcv.setTransferSyntax(native_ts);
                } else {
                    this.dcmrcv.setTransferSyntax(native_le_ts);
                }
            } else if (this.connectorProperties.isBigEndian()) {
                this.dcmrcv.setTransferSyntax(non_retired_ts);
            }
            String aeTitle = this.replacer.replaceValues(this.connectorProperties.getApplicationEntity(), this.getChannelId(), this.getChannel().getName());
            aeTitle = (String)StringUtils.defaultIfBlank((CharSequence)aeTitle, null);
            this.dcmrcv.setAEtitle(aeTitle);
            int value = NumberUtils.toInt((String)this.connectorProperties.getReaper());
            if (value != 10) {
                this.dcmrcv.setAssociationReaperPeriod(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getIdleTo())) != 60) {
                this.dcmrcv.setIdleTimeout(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getRequestTo())) != 5) {
                this.dcmrcv.setRequestTimeout(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getReleaseTo())) != 5) {
                this.dcmrcv.setReleaseTimeout(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getSoCloseDelay())) != 50) {
                this.dcmrcv.setSocketCloseDelay(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getRspDelay())) > 0) {
                this.dcmrcv.setDimseRspDelay(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getRcvpdulen())) != 16) {
                this.dcmrcv.setMaxPDULengthReceive(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getSndpdulen())) != 16) {
                this.dcmrcv.setMaxPDULengthSend(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getSosndbuf())) > 0) {
                this.dcmrcv.setSendBufferSize(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getSorcvbuf())) > 0) {
                this.dcmrcv.setReceiveBufferSize(value);
            }
            if ((value = NumberUtils.toInt((String)this.connectorProperties.getBufSize())) != 1) {
                this.dcmrcv.setFileBufferSize(value);
            }
            this.dcmrcv.setPackPDV(this.connectorProperties.isPdv1());
            this.dcmrcv.setTcpNoDelay(!this.connectorProperties.isTcpDelay());
            value = NumberUtils.toInt((String)this.connectorProperties.getAsync());
            if (value > 0) {
                this.dcmrcv.setMaxOpsPerformed(value);
            }
            this.dcmrcv.initTransferCapability();
            this.configuration.configureDcmRcv(this.dcmrcv, this, this.connectorProperties);
            this.dcmrcv.start();
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Failed to start DICOM Listener", (Throwable)e);
        }
    }

    public void onStop() throws ConnectorTaskException {
        try {
            this.dcmrcv.stop();
        }
        catch (Exception e) {
            this.logger.error("Unable to close DICOM port.", (Throwable)e);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.DISCONNECTED));
        }
        this.logger.debug("closed DICOM port");
    }

    public void onHalt() throws ConnectorTaskException {
        this.onStop();
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    public TemplateValueReplacer getReplacer() {
        return this.replacer;
    }
}

