/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.util.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;

public class VersionLogger {
    private static boolean ourInitialized = false;
    private static String ourVersion;
    private static final Logger LOG;

    private VersionLogger() {
    }

    public static void init() {
        if (!ourInitialized) {
            VersionLogger.printHapiVersion();
            VersionLogger.checkStructureLibraries();
            VersionLogger.checkDOMImplementation();
            ourInitialized = true;
        }
    }

    private static void checkDOMImplementation() {
        try {
            DOMImplementation impl = (DOMImplementation)XMLUtils.getDOMImpl();
            if (impl == null) {
                LOG.warn("DOM Level 3 (Load and Save) is NOT supported by the XML library found first on your classpath!");
                LOG.warn("XML parsing and encoding as well as working with Conformance Profiles will fail.");
            }
        }
        catch (Throwable e) {
            LOG.warn("Error occured while trying to retrieve a DOMImplementation.", e);
            LOG.warn("XML parsing and encoding as well as working with Conformance Profiles will fail.");
        }
    }

    private static void checkStructureLibraries() {
        StringBuilder sb = new StringBuilder();
        for (Version v : Version.availableVersions()) {
            sb.append(v.getVersion());
            sb.append(sb.length() > 0 ? ", " : "");
        }
        if (sb.length() == 0) {
            LOG.warn("No HL7 structure libraries found on the classpath!");
        } else {
            LOG.info("Default Structure libraries found for HL7 versions {}", (Object)sb.toString());
        }
    }

    private static void printHapiVersion() {
        InputStream is = null;
        try {
            is = VersionLogger.class.getResourceAsStream("/ca/uhn/hl7v2/hapi-version.properties");
            Properties p = new Properties();
            p.load(is);
            ourVersion = p.getProperty("version");
            LOG.info("HAPI version is: " + ourVersion);
        }
        catch (IOException e) {
            LOG.warn("Unable to determine HAPI version information", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getVersion() {
        return ourVersion;
    }

    static {
        LOG = LoggerFactory.getLogger(VersionLogger.class);
    }
}

