/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.User;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/users")
@Tag(name="Users")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface UserServletInterface
extends BaseServletInterface {
    public static final String LOGIN_SERVER_URL_HEADER = "X-Mirth-Server-Url";
    public static final String LOGIN_DATA_HEADER = "X-Mirth-Login-Data";

    @POST
    @Path(value="/_login")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Logs in to the BridgeLink server using the specified name and password.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="loginStatus", ref="../apiexamples/login_status_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="loginStatus", ref="../apiexamples/login_status_json")})})
    @MirthOperation(name="login", display="Login")
    public LoginStatus login(@Param(value="username") @Parameter(description="The username to login with.", required=true, schema=@Schema(defaultValue="admin")) @FormParam(value="username") String var1, @Param(value="password", excludeFromAudit=true) @Parameter(description="The password to login with.", required=true, schema=@Schema(defaultValue="admin")) @FormParam(value="password") String var2) throws ClientException;

    @POST
    @Path(value="/_logout")
    @Operation(summary="Logs out of the server.")
    @MirthOperation(name="logout", display="Logout")
    public void logout() throws ClientException;

    @POST
    @Path(value="/_inactivityLogout")
    @Operation(summary="User has been inactive and automatically logged out.")
    @MirthOperation(name="inactivityLogout", display="Logged out due to inactivity")
    public void inactivityLogout() throws ClientException;

    @POST
    @Path(value="/")
    @Operation(summary="Creates a new user.")
    @MirthOperation(name="createUser", display="Create new user", permission="manageUsers")
    public void createUser(@Param(value="user") @RequestBody(description="The User object to create.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="user", ref="../apiexamples/new_user_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="user", ref="../apiexamples/new_user_json")})}) User var1) throws ClientException;

    @GET
    @Path(value="/")
    @Operation(summary="Returns a List of all users.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="allUsers", ref="../apiexamples/user_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="allUsers", ref="../apiexamples/user_list_json")})})
    @MirthOperation(name="getAllUsers", display="Get all users", permission="manageUsers", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<User> getAllUsers() throws ClientException;

    @GET
    @Path(value="/{userIdOrName}")
    @Operation(summary="Returns a specific user by ID or username.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="user", ref="../apiexamples/user_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="user", ref="../apiexamples/user_json")})})
    @MirthOperation(name="getUser", display="Get user", permission="manageUsers", type=Operation.ExecuteType.ASYNC, auditable=false)
    public User getUser(@Param(value="userIdOrName") @Parameter(description="The unique ID or username of the user to retrieve.", required=true) @PathParam(value="userIdOrName") String var1) throws ClientException;

    @GET
    @Path(value="/current")
    @Operation(summary="Returns the current logged in user.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="user", ref="../apiexamples/user_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="user", ref="../apiexamples/user_json")})})
    @MirthOperation(name="getCurrentUser", display="Get current user", auditable=false)
    public User getCurrentUser() throws ClientException;

    @PUT
    @Path(value="/{userId}")
    @Operation(summary="Updates a specified user.")
    @MirthOperation(name="updateUser", display="Update user", permission="manageUsers")
    public void updateUser(@Param(value="userId") @Parameter(description="The unique ID of the user to update.", required=true) @PathParam(value="userId") Integer var1, @Param(value="user") @RequestBody(description="The User object to update.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="user", ref="../apiexamples/user_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="user", ref="../apiexamples/user_json")})}) User var2) throws ClientException;

    @POST
    @Path(value="/_checkPassword")
    @Consumes(value={"text/plain"})
    @Operation(summary="Checks the password against the configured password policies.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="passwordRequirementList", ref="../apiexamples/password_requirement_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="passwordRequirementList", ref="../apiexamples/password_requirement_list_json")})})
    @MirthOperation(name="checkUserPassword", display="Check a password against requirements.", permission="manageUsers")
    public List<String> checkUserPassword(@Param(value="plainPassword", excludeFromAudit=true) @Parameter(description="The plaintext password to check.", required=true) String var1) throws ClientException;

    @PUT
    @Path(value="/{userId}/password")
    @Consumes(value={"text/plain"})
    @Operation(summary="Updates a user's password.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="passwordRequirementList", ref="../apiexamples/password_requirement_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="passwordRequirementList", ref="../apiexamples/password_requirement_list_json")})})
    @MirthOperation(name="updateUserPassword", display="Update a user's password", permission="manageUsers")
    public List<String> updateUserPassword(@Param(value="userId") @Parameter(description="The unique ID of the user to update the password for.", required=true) @PathParam(value="userId") Integer var1, @Param(value="plainPassword", excludeFromAudit=true) @Parameter(description="The plaintext password to update with.", required=true) String var2) throws ClientException;

    @DELETE
    @Path(value="/{userId}")
    @Operation(summary="Removes a specific user.")
    @MirthOperation(name="removeUser", display="Remove user", permission="manageUsers")
    public void removeUser(@Param(value="userId") @Parameter(description="The unique ID of the user to remove.", required=true) @PathParam(value="userId") Integer var1) throws ClientException;

    @GET
    @Path(value="/{userId}/loggedIn")
    @Operation(summary="Returns a true if the specified user is logged in to the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="loggedIn", ref="../apiexamples/boolean_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="loggedIn", ref="../apiexamples/boolean_json")})})
    @MirthOperation(name="isUserLoggedIn", display="Check if user is logged in", permission="manageUsers")
    public boolean isUserLoggedIn(@Param(value="userId") @Parameter(description="The unique ID of the user.", required=true) @PathParam(value="userId") Integer var1) throws ClientException;

    @GET
    @Path(value="/{userId}/preferences")
    @Operation(summary="Returns a Map of user preferences, optionally filtered by a set of property names.")
    @MirthOperation(name="getUserPreferences", display="Get user preferences", auditable=false)
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/xml", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_xml")}), @Content(mediaType="application/json", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_json")})})
    public Properties getUserPreferences(@Param(value="userId") @Parameter(description="The unique ID of the user.", required=true) @PathParam(value="userId") Integer var1, @Param(value="names") @Parameter(description="An optional set of property names to filter by.") @QueryParam(value="name") Set<String> var2) throws ClientException;

    @GET
    @Path(value="/{userId}/preferences/{name}")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns a specific user preference.")
    @MirthOperation(name="getUserPreference", display="Get user preference", auditable=false)
    public String getUserPreference(@Param(value="userId") @Parameter(description="The unique ID of the user.", required=true) @PathParam(value="userId") Integer var1, @Param(value="name") @Parameter(description="The name of the user property to retrieve.", required=true) @PathParam(value="name") String var2) throws ClientException;

    @PUT
    @Path(value="/{userId}/preferences")
    @Operation(summary="Updates multiple user preferences.")
    @MirthOperation(name="setUserPreferences", display="Set user preferences")
    public void setUserPreferences(@Param(value="userId") @Parameter(description="The unique ID of the user.", required=true) @PathParam(value="userId") Integer var1, @Param(value="properties") @RequestBody(description="The properties to update for the user.", required=true, content={@Content(mediaType="application/xml", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="properties", ref="../apiexamples/properties_xml")}), @Content(mediaType="application/json", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="properties", ref="../apiexamples/properties_json")})}) Properties var2) throws ClientException;

    @POST
    @Path(value="/{userId}/notificationAcknowledged")
    @Operation(summary="User notification has been acknowledged.")
    @MirthOperation(name="userNotificationAcknowledged", display="Login notification accepted")
    public void setUserNotificationAcknowledged(@Param(value="userId") @Parameter(description="The unique ID of the user.", required=true) @PathParam(value="userId") Integer var1) throws ClientException;

    @PUT
    @Path(value="/{userId}/preferences/{name}")
    @Consumes(value={"text/plain"})
    @Operation(summary="Updates a user preference.")
    @MirthOperation(name="setUserPreference", display="Set user preference")
    public void setUserPreference(@Param(value="userId") @Parameter(description="The unique ID of the user.", required=true) @PathParam(value="userId") Integer var1, @Param(value="name") @Parameter(description="The name of the user property to update.", required=true) @PathParam(value="name") String var2, @Param(value="value") @Parameter(description="The value to update the property with.", required=true) String var3) throws ClientException;
}

