/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.FilterTransformerElement;
import com.mirth.connect.model.FilterTransformerIterable;
import com.mirth.connect.util.ScriptBuilderException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class IteratorProperties<C extends FilterTransformerElement>
implements Serializable,
Purgable,
FilterTransformerIterable<C> {
    public static final String PLUGIN_POINT = "Iterator";
    private String target;
    private String indexVariable;
    private List<String> prefixSubstitutions;
    private List<C> children;

    public IteratorProperties() {
        this.target = "";
        this.indexVariable = "i";
        this.prefixSubstitutions = new ArrayList<String>();
        this.children = new ArrayList<C>();
    }

    public IteratorProperties(IteratorProperties<C> props) {
        this.target = props.getTarget();
        this.indexVariable = props.getIndexVariable();
        this.prefixSubstitutions = new ArrayList<String>(props.getPrefixSubstitutions());
        this.children = new ArrayList<C>();
        for (FilterTransformerElement element : props.getChildren()) {
            this.children.add(element.clone());
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getIndexVariable() {
        return this.indexVariable;
    }

    public void setIndexVariable(String indexVariable) {
        this.indexVariable = indexVariable;
    }

    public List<String> getPrefixSubstitutions() {
        return this.prefixSubstitutions;
    }

    public void setPrefixSubstitutions(List<String> prefixSubstitutions) {
        this.prefixSubstitutions = prefixSubstitutions;
    }

    public List<C> getChildren() {
        return this.children;
    }

    public List<C> getEnabledElements() {
        ArrayList<FilterTransformerElement> enabledElements = new ArrayList<FilterTransformerElement>();
        for (FilterTransformerElement element : this.children) {
            if (!element.isEnabled()) continue;
            enabledElements.add(element);
        }
        return enabledElements;
    }

    public void setChildren(List<C> children) {
        this.children = children;
    }

    public String getScript(boolean loadFiles) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        LinkedList<IteratorProperties<C>> ancestors = new LinkedList<IteratorProperties<C>>();
        script.append(StringUtils.defaultString((String)this.getPreScript(loadFiles, ancestors)));
        script.append(StringUtils.defaultString((String)this.getIterationScript(loadFiles, ancestors)));
        script.append(StringUtils.defaultString((String)this.getPostScript(loadFiles, ancestors)));
        return script.toString();
    }

    @Override
    public String getPreScript(boolean loadFiles, LinkedList<IteratorProperties<C>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        ancestors.push(this);
        for (FilterTransformerElement child : this.getEnabledElements()) {
            if (!(child instanceof FilterTransformerIterable)) continue;
            script.append(StringUtils.defaultString((String)((FilterTransformerIterable)((Object)child)).getPreScript(loadFiles, ancestors))).append('\n');
        }
        ancestors.pop();
        return script.toString();
    }

    @Override
    public String getIterationScript(boolean loadFiles, LinkedList<IteratorProperties<C>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        ancestors.push(this);
        script.append("for (var ").append(this.indexVariable).append(" = 0; ").append(this.indexVariable).append(" < getArrayOrXmlLength(").append(this.target).append("); ").append(this.indexVariable).append("++) {\n");
        for (FilterTransformerElement child : this.getEnabledElements()) {
            script.append('\n');
            if (child instanceof FilterTransformerIterable) {
                script.append(StringUtils.defaultString((String)((FilterTransformerIterable)((Object)child)).getIterationScript(loadFiles, ancestors)));
            } else {
                script.append(StringUtils.defaultString((String)child.getScript(loadFiles)));
            }
            script.append('\n');
        }
        script.append("\n}\n");
        ancestors.pop();
        return script.toString();
    }

    @Override
    public String getPostScript(boolean loadFiles, LinkedList<IteratorProperties<C>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        ancestors.push(this);
        for (FilterTransformerElement child : this.getEnabledElements()) {
            if (!(child instanceof FilterTransformerIterable)) continue;
            script.append(StringUtils.defaultString((String)((FilterTransformerIterable)((Object)child)).getPostScript(loadFiles, ancestors))).append('\n');
        }
        ancestors.pop();
        return script.toString();
    }

    public abstract IteratorProperties<C> clone();

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("prefixSubstitutionsCount", CollectionUtils.size(this.prefixSubstitutions));
        purgedProperties.put("children", PurgeUtil.purgeList(this.children));
        return purgedProperties;
    }
}

