/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.alert;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.model.alert.AlertConnectors;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@XStreamAlias(value="alertChannels")
public class AlertChannels
implements Serializable,
Migratable,
Purgable {
    private boolean newChannelSource = false;
    private boolean newChannelDestination = false;
    private Set<String> enabledChannels = new HashSet<String>();
    private Set<String> disabledChannels = new HashSet<String>();
    private Map<String, AlertConnectors> partialChannels = new HashMap<String, AlertConnectors>();

    public boolean isNewChannelSource() {
        return this.newChannelSource;
    }

    public boolean isNewChannelDestination() {
        return this.newChannelDestination;
    }

    public Set<String> getEnabledChannels() {
        return this.enabledChannels;
    }

    public Set<String> getDisabledChannels() {
        return this.disabledChannels;
    }

    public Map<String, AlertConnectors> getPartialChannels() {
        return this.partialChannels;
    }

    public void setNewChannel(boolean source, boolean destinations) {
        this.newChannelSource = source;
        this.newChannelDestination = destinations;
    }

    public void addChannel(String channelId, Map<Integer, Boolean> connectorMap) {
        AlertConnectors connectors = new AlertConnectors();
        boolean allEnabled = true;
        boolean allDisabled = true;
        boolean matchesNewChannel = true;
        for (Map.Entry<Integer, Boolean> entry : connectorMap.entrySet()) {
            Integer metaDataId = entry.getKey();
            boolean enabled = entry.getValue();
            if (enabled) {
                allDisabled = false;
                connectors.getEnabledConnectors().add(metaDataId);
            } else {
                allEnabled = false;
                connectors.getDisabledConnectors().add(metaDataId);
            }
            if (metaDataId == null || metaDataId > 0) {
                if (enabled == this.newChannelDestination) continue;
                matchesNewChannel = false;
                continue;
            }
            if (enabled == this.newChannelSource) continue;
            matchesNewChannel = false;
        }
        if (!matchesNewChannel) {
            if (allEnabled) {
                this.enabledChannels.add(channelId);
            } else if (allDisabled) {
                this.disabledChannels.add(channelId);
            } else {
                this.partialChannels.put(channelId, connectors);
            }
        }
    }

    public boolean isChannelEnabled(String channelId) {
        if (this.enabledChannels.contains(channelId)) {
            return true;
        }
        if (this.disabledChannels.contains(channelId)) {
            return false;
        }
        if (this.partialChannels.containsKey(channelId)) {
            Set<Integer> enabledConnectors = this.partialChannels.get(channelId).getEnabledConnectors();
            return enabledConnectors.size() > 0;
        }
        return this.newChannelSource || this.newChannelDestination;
    }

    public boolean isConnectorEnabled(String channelId, Integer metaDataId) {
        if (this.enabledChannels.contains(channelId)) {
            return true;
        }
        if (this.disabledChannels.contains(channelId)) {
            return false;
        }
        if (this.partialChannels.containsKey(channelId)) {
            Set<Integer> enabledConnectors = this.partialChannels.get(channelId).getEnabledConnectors();
            Set<Integer> disabledConnectors = this.partialChannels.get(channelId).getDisabledConnectors();
            return enabledConnectors.contains(metaDataId) || enabledConnectors.contains(null) && !disabledConnectors.contains(metaDataId);
        }
        if (metaDataId == null || metaDataId > 0) {
            return this.newChannelDestination;
        }
        return this.newChannelSource;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("newChannelSource", this.newChannelSource);
        purgedProperties.put("newChannelDestination", this.newChannelDestination);
        purgedProperties.put("enabledChannelsCount", this.enabledChannels.size());
        purgedProperties.put("disabledChannelsCount", this.disabledChannels.size());
        purgedProperties.put("partialChannelsCount", this.partialChannels.size());
        return purgedProperties;
    }
}

