/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.InvalidThrowable;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class ThrowableConverter
extends ReflectionConverter {
    private HierarchicalStreamCopier copier = new HierarchicalStreamCopier();

    public ThrowableConverter(Mapper mapper) {
        super(mapper, JVM.newReflectionProvider());
    }

    public boolean canConvert(Class type) {
        return type != null && Throwable.class.isAssignableFrom(type);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (value instanceof InvalidThrowable) {
            try {
                DonkeyElement element = new DonkeyElement(((InvalidThrowable)value).getThrowableXml());
                String version = element.getAttribute("version");
                if (StringUtils.isNotEmpty((CharSequence)version)) {
                    writer.addAttribute("version", version);
                }
                for (DonkeyElement child : element.getChildElements()) {
                    this.copier.copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(child.toXml()), (XmlPullParser)new MXParser()), writer);
                }
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
        }
        Throwable t = (Throwable)value;
        if (t.getCause() == null) {
            try {
                t.initCause(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        t.getStackTrace();
        super.marshal(value, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.underlyingReader() instanceof DocumentReader) {
            DonkeyElement element = new DonkeyElement((Element)((DocumentReader)reader.underlyingReader()).getCurrent());
            String preUnmarshalXml = null;
            try {
                try {
                    preUnmarshalXml = element.toXml();
                }
                catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                    // empty catch block
                }
                return super.unmarshal(reader, context);
            }
            catch (Throwable t) {
                return new InvalidThrowable(preUnmarshalXml, element, reader);
            }
        }
        return super.unmarshal(reader, context);
    }
}

