/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.filter;

import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.filter.SearchFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ChannelTagSearchFilter
extends SearchFilter {
    private Set<String> channelIds = null;
    private List<String> filteredTagNames;
    private List<ChannelTag> channelTags = new ArrayList<ChannelTag>();

    public ChannelTagSearchFilter(Set<ChannelTag> channelTags, List<String> filteredTagNames) {
        this.filteredTagNames = filteredTagNames;
        ArrayList<String> lowercaseTagNames = new ArrayList<String>();
        for (String tagName : filteredTagNames) {
            lowercaseTagNames.add(tagName.toLowerCase());
        }
        for (ChannelTag tag : channelTags) {
            if (!lowercaseTagNames.contains(tag.getName().toLowerCase())) continue;
            this.channelTags.add(new ChannelTag(tag));
            if (this.channelIds == null) {
                this.channelIds = new HashSet<String>(tag.getChannelIds());
                continue;
            }
            Iterator<String> it = this.channelIds.iterator();
            while (it.hasNext()) {
                if (tag.getChannelIds().contains(it.next())) continue;
                it.remove();
            }
        }
        if (this.channelIds == null) {
            this.channelIds = new HashSet<String>();
        }
    }

    @Override
    public List<String> getValues() {
        return this.filteredTagNames;
    }

    @Override
    public boolean acceptChannelId(String channelId) {
        return this.channelIds.contains(channelId);
    }

    @Override
    public boolean acceptChannelName(String channelName) {
        return true;
    }

    @Override
    public boolean acceptChannel(Channel channel) {
        return this.channelIds.contains(channel.getId());
    }

    @Override
    public boolean acceptDashboardStatus(DashboardStatus status) {
        return this.channelIds.contains(status.getChannelId());
    }

    @Override
    public boolean acceptChannelStatus(ChannelStatus status) {
        return this.channelIds.contains(status.getChannel().getId());
    }

    @Override
    public String toDisplayString() {
        StringBuilder builder = new StringBuilder();
        Iterator<ChannelTag> it = this.channelTags.iterator();
        while (it.hasNext()) {
            builder.append(it.next().getName());
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

