/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.transmission.framemode;

import com.mirth.connect.donkey.server.message.StreamHandler;
import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameStreamHandlerException;
import com.mirth.connect.util.TcpUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrameStreamHandler
extends StreamHandler {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected byte[] startOfMessageBytes;
    protected byte[] endOfMessageBytes;
    protected boolean returnDataOnException;
    private ByteArrayOutputStream capturedBytes;
    private List<Byte> endBytesBuffer;
    private byte lastByte;
    private boolean streamDone;
    private boolean checkStartOfMessageBytes;
    private int currentByte;

    public FrameStreamHandler(InputStream inputStream, OutputStream outputStream, BatchStreamReader batchStreamReader, TransmissionModeProperties transmissionModeProperties) {
        super(inputStream, outputStream, batchStreamReader);
        FrameModeProperties frameModeProperties = (FrameModeProperties)transmissionModeProperties;
        this.startOfMessageBytes = TcpUtil.stringToByteArray(frameModeProperties.getStartOfMessageBytes());
        this.endOfMessageBytes = TcpUtil.stringToByteArray(frameModeProperties.getEndOfMessageBytes());
        this.returnDataOnException = this.endOfMessageBytes.length == 0;
        this.checkStartOfMessageBytes = true;
        this.streamDone = false;
    }

    public byte[] getStartOfMessageBytes() {
        return this.startOfMessageBytes;
    }

    public void setStartOfMessageBytes(byte[] startOfMessageBytes) {
        this.startOfMessageBytes = startOfMessageBytes;
    }

    public byte[] getEndOfMessageBytes() {
        return this.endOfMessageBytes;
    }

    public void setEndOfMessageBytes(byte[] endOfMessageBytes) {
        this.endOfMessageBytes = endOfMessageBytes;
    }

    public boolean isReturnDataOnException() {
        return this.returnDataOnException;
    }

    public void setReturnDataOnException(boolean returnDataOnException) {
        this.returnDataOnException = returnDataOnException;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.batchStreamReader.setInputStream(inputStream);
    }

    public void reset() {
        this.checkStartOfMessageBytes = true;
        this.streamDone = false;
    }

    public byte[] read() throws IOException {
        block22: {
            if (this.streamDone || this.inputStream == null) {
                return null;
            }
            this.capturedBytes = new ByteArrayOutputStream();
            ArrayList<Byte> firstBytes = new ArrayList<Byte>();
            this.endBytesBuffer = new ArrayList<Byte>();
            try {
                if (this.checkStartOfMessageBytes) {
                    int i = 0;
                    while (i < this.startOfMessageBytes.length) {
                        this.currentByte = this.inputStream.read();
                        this.logger.trace("Checking for start of message bytes, currentByte: " + this.currentByte);
                        if (this.currentByte != -1) {
                            if (firstBytes.size() < this.startOfMessageBytes.length) {
                                firstBytes.add((byte)this.currentByte);
                            }
                            if (this.currentByte == (this.startOfMessageBytes[i] & 0xFF)) {
                                ++i;
                                continue;
                            }
                            i = 0;
                            continue;
                        }
                        this.streamDone = true;
                        if (firstBytes.size() > 0) {
                            throw new FrameStreamHandlerException(true, this.startOfMessageBytes, ArrayUtils.toPrimitive((Byte[])firstBytes.toArray(new Byte[0])));
                        }
                        return null;
                    }
                    this.checkStartOfMessageBytes = false;
                }
                this.batchStreamReader.initialize();
                while ((this.currentByte = this.batchStreamReader.getNextByte()) != -1 || this.endOfMessageBytes.length > 0 && !this.endBytesBuffer.isEmpty()) {
                    byte[] returnBytes;
                    if (this.currentByte == -1) {
                        this.currentByte = this.endBytesBuffer.remove(0).byteValue();
                        this.streamDone = true;
                    } else {
                        this.lastByte = (byte)this.currentByte;
                    }
                    if (this.endOfMessageBytes.length > 0 && !this.streamDone) {
                        if (this.endBytesBuffer.size() == this.endOfMessageBytes.length) {
                            this.capturedBytes.write(this.endBytesBuffer.remove(0).byteValue());
                        }
                        this.endBytesBuffer.add((byte)this.currentByte);
                        boolean endBytesFound = true;
                        for (int i = 0; i <= this.endBytesBuffer.size() - 1; ++i) {
                            if (this.endBytesBuffer.get(i) == this.endOfMessageBytes[i]) continue;
                            endBytesFound = false;
                            break;
                        }
                        if (endBytesFound) {
                            this.streamDone = true;
                            return this.capturedBytes.toByteArray();
                        }
                    } else {
                        this.capturedBytes.write(this.currentByte);
                    }
                    if (this.streamDone || (returnBytes = this.batchStreamReader.checkForIntermediateMessage(this.capturedBytes, this.endBytesBuffer, (int)this.lastByte)) == null) continue;
                    return returnBytes;
                }
            }
            catch (Throwable e) {
                if (this.returnDataOnException) break block22;
                if (e instanceof IOException) {
                    if (this.checkStartOfMessageBytes && firstBytes.size() > 0) {
                        throw new FrameStreamHandlerException(true, this.startOfMessageBytes, ArrayUtils.toPrimitive((Byte[])firstBytes.toArray(new Byte[0])), e);
                    }
                    if (this.capturedBytes.size() + this.endBytesBuffer.size() > 0 && this.endOfMessageBytes.length > 0) {
                        throw new FrameStreamHandlerException(false, this.endOfMessageBytes, this.getLastBytes(), e);
                    }
                    throw (IOException)e;
                }
                return null;
            }
        }
        if (this.endOfMessageBytes.length > 0) {
            throw new FrameStreamHandlerException(false, this.endOfMessageBytes, this.getLastBytes());
        }
        this.checkStartOfMessageBytes = true;
        for (Byte bufByte : this.endBytesBuffer) {
            this.capturedBytes.write(bufByte.byteValue());
        }
        return this.capturedBytes.size() > 0 ? this.capturedBytes.toByteArray() : null;
    }

    public void write(byte[] data) throws IOException {
        this.writeFrame(data);
    }

    protected void writeFrame(byte[] data) throws IOException {
        this.write(this.startOfMessageBytes, data, this.endOfMessageBytes);
    }

    protected void write(byte[] ... dataArrays) throws IOException {
        if (dataArrays == null || this.outputStream == null) {
            return;
        }
        DataOutputStream dos = new DataOutputStream(this.outputStream);
        for (byte[] data : dataArrays) {
            if (data == null) continue;
            for (byte b : data) {
                dos.writeByte(b);
            }
        }
        try {
            dos.flush();
        }
        catch (SocketException e) {
            this.logger.debug("Socket closed while trying to flush.");
        }
    }

    private byte[] getLastBytes() {
        int capturedBytesLength = this.capturedBytes != null ? this.capturedBytes.size() : 0;
        int endBytesBufferLength = this.endBytesBuffer != null ? this.endBytesBuffer.size() : 0;
        byte[] lastBytes = new byte[Math.min(capturedBytesLength + endBytesBufferLength, this.endOfMessageBytes.length)];
        int index = 0;
        if (this.capturedBytes != null) {
            byte[] capturedByteArray = this.capturedBytes.toByteArray();
            for (int i = capturedBytesLength - lastBytes.length + endBytesBufferLength; i >= 0 && i < capturedBytesLength; ++i) {
                lastBytes[index++] = capturedByteArray[i];
            }
        }
        if (this.endBytesBuffer != null) {
            for (byte b : this.endBytesBuffer) {
                lastBytes[index++] = b;
            }
        }
        return lastBytes;
    }
}

